/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.core.other;

import com.minecraftabnormals.abnormals_core.core.util.BlockUtil;
import com.minecraftabnormals.abnormals_core.core.util.DataUtil;
import com.minecraftabnormals.savageandravage.common.entity.BurningBannerEntity;
import com.minecraftabnormals.savageandravage.common.entity.MischiefArrowEntity;
import com.minecraftabnormals.savageandravage.common.entity.SporeCloudEntity;
import com.minecraftabnormals.savageandravage.common.entity.block.SporeBombEntity;
import com.minecraftabnormals.savageandravage.common.item.CreeperSporesItem;
import com.minecraftabnormals.savageandravage.core.other.SREvents;
import com.minecraftabnormals.savageandravage.core.registry.SRBlocks;
import com.minecraftabnormals.savageandravage.core.registry.SRItems;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.BannerItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;

public class SRCompat {
    public static void registerCompat() {
        SRCompat.registerFlammables();
        SRCompat.registerDispenserBehaviors();
    }

    public static void registerFlammables() {
        DataUtil.registerFlammable((Block)((Block)SRBlocks.CREEPER_SPORE_SACK.get()), (int)30, (int)60);
        DataUtil.registerFlammable((Block)((Block)SRBlocks.SPORE_BOMB.get()), (int)15, (int)100);
    }

    public static void registerDispenserBehaviors() {
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)SRItems.MISCHIEF_ARROW.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World world, IPosition position, ItemStack stack) {
                return new MischiefArrowEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)SRItems.CREEPER_SPORES.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            protected ProjectileEntity func_82499_a(World world, IPosition position, ItemStack stack) {
                SporeCloudEntity cloud = new SporeCloudEntity(world, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
                cloud.setCloudSize(CreeperSporesItem.getThrownSporeCloudSize(world.func_201674_k()));
                return cloud;
            }
        });
        DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)SRBlocks.SPORE_BOMB.get()), (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                BlockPos blockpos = BlockUtil.offsetPos((IBlockSource)source);
                SporeBombEntity sporeBomb = new SporeBombEntity((World)world, (double)blockpos.func_177958_n() + 0.5, blockpos.func_177956_o(), (double)blockpos.func_177952_p() + 0.5, null);
                world.func_217376_c((Entity)sporeBomb);
                world.func_184148_a(null, sporeBomb.func_226277_ct_(), sporeBomb.func_226278_cu_(), sporeBomb.func_226281_cx_(), SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
                stack.func_190918_g(1);
                return stack;
            }
        });
        ForgeRegistries.ITEMS.getEntries().stream().map(Map.Entry::getValue).filter(i -> i instanceof BannerItem).forEach(i -> DataUtil.registerAlternativeDispenseBehavior((DataUtil.AlternativeDispenseBehavior)new DataUtil.AlternativeDispenseBehavior("savageandravage", i, (source, stack) -> !BlockUtil.getEntitiesAtOffsetPos((IBlockSource)source, LivingEntity.class, EntityPredicates.field_180132_d.and(new EntityPredicates.ArmoredMob(stack))).isEmpty(), ArmorItem.field_96605_cw, (id1, id2) -> id2.equals("quark") ? 1 : 0)));
        DataUtil.registerAlternativeDispenseBehavior((DataUtil.AlternativeDispenseBehavior)new DataUtil.AlternativeDispenseBehavior("savageandravage", Items.field_151033_d, (source, stack) -> SREvents.isValidBurningBannerPos((World)source.func_197524_h(), BlockUtil.offsetPos((IBlockSource)source)), (IDispenseItemBehavior)new DefaultDispenseItemBehavior(){

            protected ItemStack func_82487_b(IBlockSource source, ItemStack stack) {
                ServerWorld world = source.func_197524_h();
                world.func_217376_c((Entity)new BurningBannerEntity((World)world, BlockUtil.offsetPos((IBlockSource)source), null));
                if (stack.func_96631_a(1, world.field_73012_v, null)) {
                    stack.func_190920_e(0);
                }
                return stack;
            }
        }));
    }
}

