/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.world.gen.feature;

import com.minecraftabnormals.savageandravage.common.entity.CreepieEntity;
import com.minecraftabnormals.savageandravage.common.entity.GrieferEntity;
import com.minecraftabnormals.savageandravage.core.registry.SRBlocks;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.fml.ModList;

public class EnclosureFeature
extends Feature<NoFeatureConfig> {
    private static final Direction[] horizontalDirections = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private final BlockPos.Mutable currentPos = new BlockPos.Mutable();
    private BlockPos originalStartPos;

    public EnclosureFeature(Codec<NoFeatureConfig> featureConfigCodec) {
        super(featureConfigCodec);
    }

    public boolean place(ISeedReader reader, ChunkGenerator generator, Random rand, BlockPos centerPos, NoFeatureConfig config) {
        int minY = centerPos.func_177956_o() - (4 + rand.nextInt(2));
        this.originalStartPos = centerPos;
        if ((centerPos = this.findSuitablePosition(reader, centerPos, minY, rand)) != null) {
            GrieferEntity griefer;
            ArrayList<BlockPos> holePositions = new ArrayList<BlockPos>();
            ArrayList<BlockPos> edgePositions = new ArrayList<BlockPos>();
            holePositions.add(centerPos);
            for (Direction dir : horizontalDirections) {
                edgePositions.add(centerPos.func_177972_a(dir));
            }
            for (int i = 0; i <= 5 + rand.nextInt(5); ++i) {
                edgePositions = this.expandHole(edgePositions, holePositions, centerPos, reader, rand);
            }
            if (holePositions.size() <= 1) {
                return false;
            }
            this.generateEdges(edgePositions, reader, rand);
            ArrayList<BlockPos> outlinePositions = this.findOutlines(edgePositions, holePositions, reader);
            this.generateHole(holePositions, minY, reader, rand);
            ArrayList<BlockPos> clearOutlinePositions = this.generateFences(outlinePositions, reader, rand);
            for (BlockPos outlinePos : outlinePositions) {
                this.fixFenceConnections(reader, outlinePos);
            }
            if (!clearOutlinePositions.isEmpty() && (griefer = (GrieferEntity)((EntityType)SREntities.GRIEFER.get()).func_200721_a((World)reader.func_201672_e())) != null) {
                BlockPos.Mutable grieferPos = clearOutlinePositions.get(rand.nextInt(clearOutlinePositions.size())).func_239590_i_();
                griefer.func_70012_b(grieferPos.func_177958_n(), grieferPos.func_177956_o(), grieferPos.func_177952_p(), 0.0f, 0.0f);
                griefer.func_110163_bv();
                griefer.func_213386_a((IServerWorld)reader, reader.func_175649_E((BlockPos)grieferPos), SpawnReason.CHUNK_GENERATION, null, null);
                reader.func_217376_c((Entity)griefer);
            }
            this.generateDecorations(this.getDecorationStarts(outlinePositions, edgePositions, holePositions, reader), reader, rand);
            return true;
        }
        return false;
    }

    private BlockPos findSuitablePosition(ISeedReader reader, BlockPos centerPos, int minY, Random rand) {
        BlockPos.Mutable pos = centerPos.func_239590_i_();
        ArrayList<BlockPos.Mutable> suitablePositions = new ArrayList<BlockPos.Mutable>();
        for (int bigX = centerPos.func_177958_n() - 3; bigX < centerPos.func_177958_n() + 3; ++bigX) {
            for (int bigZ = centerPos.func_177952_p() - 3; bigZ < centerPos.func_177952_p() + 3; ++bigZ) {
                boolean areaClear = true;
                for (int x = bigX - 4; x <= bigX + 4; ++x) {
                    for (int z = bigZ - 4; z <= bigZ + 4; ++z) {
                        for (int y = minY; y <= centerPos.func_177956_o() + 1; ++y) {
                            pos.func_181079_c(x, y, z);
                            if (y >= centerPos.func_177956_o() != reader.func_180495_p((BlockPos)pos).func_200015_d((IBlockReader)reader, (BlockPos)pos) && Math.abs(this.originalStartPos.func_177958_n() - pos.func_177958_n()) <= 11 && Math.abs(this.originalStartPos.func_177952_p() - pos.func_177952_p()) <= 11) continue;
                            areaClear = false;
                        }
                    }
                }
                if (!areaClear) continue;
                pos.func_181079_c(bigX, centerPos.func_177956_o(), bigZ);
                suitablePositions.add(pos);
            }
        }
        return !suitablePositions.isEmpty() ? (BlockPos)suitablePositions.get(rand.nextInt(suitablePositions.size())) : null;
    }

    private boolean isSurfacePositionClear(ISeedReader reader, BlockPos pos) {
        if (Math.abs(this.originalStartPos.func_177958_n() - pos.func_177958_n()) < 12 && Math.abs(this.originalStartPos.func_177952_p() - pos.func_177952_p()) < 12 && !reader.func_180495_p(pos).func_200015_d((IBlockReader)reader, pos)) {
            return reader.func_180495_p(pos.func_177972_a(Direction.DOWN)).func_200015_d((IBlockReader)reader, pos.func_177972_a(Direction.DOWN));
        }
        return false;
    }

    private ArrayList<BlockPos> expandHole(ArrayList<BlockPos> edgePositions, ArrayList<BlockPos> holePositions, BlockPos centerPos, ISeedReader reader, Random rand) {
        ArrayList<BlockPos> newEdgePositions = new ArrayList<BlockPos>(edgePositions);
        for (BlockPos edgePos : edgePositions) {
            if (!((double)rand.nextInt(49) > edgePos.func_177951_i((Vector3i)centerPos))) continue;
            ArrayList<BlockPos> validPotentialPositions = new ArrayList<BlockPos>();
            boolean hasHoleNeighbor = false;
            boolean isNothingBlocking = true;
            for (Direction dir : horizontalDirections) {
                this.currentPos.func_189533_g((Vector3i)edgePos.func_177972_a(dir).func_239590_i_());
                if (!holePositions.contains(this.currentPos)) {
                    if (edgePositions.contains(this.currentPos)) continue;
                    if (this.isSurfacePositionClear(reader, (BlockPos)this.currentPos)) {
                        validPotentialPositions.add(this.currentPos.func_185334_h());
                        continue;
                    }
                    isNothingBlocking = false;
                    break;
                }
                hasHoleNeighbor = true;
            }
            if (!isNothingBlocking) continue;
            if (hasHoleNeighbor) {
                if (validPotentialPositions.size() == 0) {
                    holePositions.add(edgePos);
                    newEdgePositions.remove(edgePos);
                    continue;
                }
                if (!(rand.nextFloat() < 1.0f / ((float)validPotentialPositions.size() + 1.0f))) continue;
                newEdgePositions.addAll(validPotentialPositions);
                newEdgePositions.remove(edgePos);
                holePositions.add(edgePos);
                continue;
            }
            newEdgePositions.remove(edgePos);
        }
        return newEdgePositions;
    }

    private void generateEdges(ArrayList<BlockPos> edgePositions, ISeedReader reader, Random rand) {
        for (BlockPos edgePos : edgePositions) {
            if (!(rand.nextFloat() < 0.6f)) continue;
            reader.func_180501_a(edgePos.func_177972_a(Direction.DOWN), Blocks.field_150350_a.func_176223_P(), 3);
            reader.func_180501_a(edgePos, Blocks.field_150350_a.func_176223_P(), 3);
            reader.func_180501_a(edgePos.func_177972_a(Direction.UP), Blocks.field_150350_a.func_176223_P(), 3);
        }
    }

    private ArrayList<BlockPos> findOutlines(ArrayList<BlockPos> edgePositions, ArrayList<BlockPos> holePositions, ISeedReader reader) {
        ArrayList<BlockPos> outlinePositions = new ArrayList<BlockPos>();
        for (BlockPos edgePos : edgePositions) {
            for (Direction dir : horizontalDirections) {
                this.currentPos.func_189533_g((Vector3i)edgePos.func_177972_a(dir));
                if (!(edgePositions.contains(this.currentPos) || holePositions.contains(this.currentPos) || reader.func_180495_p((BlockPos)this.currentPos).func_200015_d((IBlockReader)reader, (BlockPos)this.currentPos))) {
                    outlinePositions.add(this.currentPos.func_185334_h());
                }
                this.currentPos.func_189533_g((Vector3i)this.currentPos.func_177972_a(dir.func_176746_e()));
                if (edgePositions.contains(this.currentPos) || holePositions.contains(this.currentPos) || reader.func_180495_p((BlockPos)this.currentPos).func_200015_d((IBlockReader)reader, (BlockPos)this.currentPos)) continue;
                outlinePositions.add(this.currentPos.func_185334_h());
            }
        }
        return outlinePositions;
    }

    private void generateHole(ArrayList<BlockPos> holePositions, int minY, ISeedReader reader, Random rand) {
        for (BlockPos holePos : holePositions) {
            MobEntity entity;
            this.currentPos.func_189533_g((Vector3i)holePos);
            for (int i = minY; i < holePos.func_177956_o() + 2; ++i) {
                this.currentPos.func_185336_p(i);
                if (i == minY) {
                    reader.func_180501_a((BlockPos)this.currentPos, Blocks.field_196660_k.func_176223_P(), 3);
                    continue;
                }
                if (i == minY + 1) {
                    reader.func_180501_a((BlockPos)this.currentPos, rand.nextFloat() < 0.4f ? (rand.nextFloat() > 0.3f ? Blocks.field_150349_c.func_176223_P() : Blocks.field_196555_aI.func_176223_P()) : Blocks.field_150350_a.func_176223_P(), 3);
                    continue;
                }
                reader.func_180501_a((BlockPos)this.currentPos, Blocks.field_150350_a.func_176223_P(), 3);
            }
            if (!(rand.nextFloat() < 0.3f) || (entity = rand.nextFloat() < 0.5f ? (MobEntity)EntityType.field_200797_k.func_200721_a((World)reader.func_201672_e()) : (MobEntity)((EntityType)SREntities.CREEPIE.get()).func_200721_a((World)reader.func_201672_e())) == null) continue;
            entity.func_70012_b((double)this.currentPos.func_177958_n() + 0.5, (double)(minY + 1), (double)this.currentPos.func_177952_p() + 0.5, 0.0f, 0.0f);
            entity.func_110163_bv();
            if (entity instanceof CreepieEntity) {
                ((CreepieEntity)entity).attackPlayersOnly = true;
            }
            entity.func_213386_a((IServerWorld)reader, reader.func_175649_E((BlockPos)this.currentPos), SpawnReason.CHUNK_GENERATION, null, null);
            reader.func_217376_c((Entity)entity);
        }
    }

    private ArrayList<BlockPos> generateFences(ArrayList<BlockPos> outlinePositions, ISeedReader reader, Random rand) {
        BlockPos.Mutable secondFencePos = new BlockPos.Mutable();
        ArrayList<BlockPos> nonFenceOutlines = new ArrayList<BlockPos>(outlinePositions);
        if (!nonFenceOutlines.isEmpty()) {
            block0: for (BlockPos firstFencePos : outlinePositions) {
                if (!(rand.nextFloat() < 0.25f)) continue;
                for (Direction dir : horizontalDirections) {
                    secondFencePos.func_189533_g((Vector3i)firstFencePos.func_177972_a(dir));
                    if (!nonFenceOutlines.contains(secondFencePos) || !reader.func_180495_p(secondFencePos.func_177972_a(Direction.DOWN)).func_200015_d((IBlockReader)reader, secondFencePos.func_177972_a(Direction.DOWN))) continue;
                    reader.func_180501_a(firstFencePos, Blocks.field_180406_aS.func_176223_P(), 3);
                    reader.func_180501_a((BlockPos)secondFencePos, Blocks.field_180406_aS.func_176223_P(), 3);
                    nonFenceOutlines.remove(firstFencePos);
                    nonFenceOutlines.remove(secondFencePos);
                    continue block0;
                }
            }
        }
        return nonFenceOutlines;
    }

    private void fixFenceConnections(ISeedReader reader, BlockPos pos) {
        BlockState originalState = reader.func_180495_p(pos);
        if (originalState.func_177230_c() instanceof FenceBlock) {
            BlockPos.Mutable neighborPos = new BlockPos.Mutable();
            for (Direction dir : horizontalDirections) {
                neighborPos.func_189533_g((Vector3i)pos.func_177972_a(dir));
                BlockState neighborState = reader.func_180495_p((BlockPos)neighborPos);
                if (!(neighborState.func_177230_c() instanceof FenceBlock)) continue;
                originalState = (BlockState)originalState.func_206870_a((Property)SixWayBlock.field_196491_B.get(dir), (Comparable)Boolean.valueOf(true));
                neighborState = (BlockState)neighborState.func_206870_a((Property)SixWayBlock.field_196491_B.get(dir.func_176734_d()), (Comparable)Boolean.valueOf(true));
                reader.func_180501_a(pos, originalState, 3);
                reader.func_180501_a(neighborPos.func_185334_h(), neighborState, 3);
            }
        }
    }

    private ArrayList<Pair<Direction, BlockPos>> getDecorationStarts(ArrayList<BlockPos> outlinePositions, ArrayList<BlockPos> edgePositions, ArrayList<BlockPos> holePositions, ISeedReader reader) {
        ArrayList<Pair<Direction, BlockPos>> decorationStarts = new ArrayList<Pair<Direction, BlockPos>>();
        for (BlockPos outlinePos : outlinePositions) {
            block1: for (Direction dir : horizontalDirections) {
                this.currentPos.func_189533_g((Vector3i)outlinePos.func_177972_a(dir));
                if (outlinePositions.contains(this.currentPos) || edgePositions.contains(this.currentPos)) continue;
                for (int attempts = 0; attempts < 4; ++attempts) {
                    this.currentPos.func_189533_g((Vector3i)this.currentPos.func_177972_a(dir));
                    if (outlinePositions.contains(this.currentPos) || edgePositions.contains(this.currentPos) || !this.isSurfacePositionClear(reader, (BlockPos)this.currentPos)) continue;
                    boolean shouldTryAgain = false;
                    BlockPos start = this.currentPos.func_185334_h();
                    boolean isClear = true;
                    this.currentPos.func_189533_g((Vector3i)start.func_177967_a(dir.func_176735_f(), 2));
                    BlockPos.Mutable mainForwardPos = this.currentPos.func_239590_i_();
                    for (int i = 0; i < 5 && isClear; ++i) {
                        for (int j = 0; j < 5 && isClear; ++j) {
                            if (!this.isSurfacePositionClear(reader, (BlockPos)this.currentPos)) {
                                isClear = false;
                            } else if (outlinePositions.contains(this.currentPos) || edgePositions.contains(this.currentPos) || holePositions.contains(this.currentPos)) {
                                isClear = false;
                                shouldTryAgain = true;
                            } else {
                                BlockPos.Mutable checkingPos = new BlockPos.Mutable();
                                for (Direction subDir : horizontalDirections) {
                                    checkingPos.func_189533_g((Vector3i)this.currentPos.func_177972_a(subDir));
                                    if (reader.func_180495_p((BlockPos)checkingPos).func_200015_d((IBlockReader)reader, (BlockPos)checkingPos)) {
                                        isClear = false;
                                        break;
                                    }
                                    if (!outlinePositions.contains(checkingPos) && !edgePositions.contains(checkingPos) && !holePositions.contains(checkingPos)) continue;
                                    isClear = false;
                                    shouldTryAgain = true;
                                    break;
                                }
                            }
                            this.currentPos.func_189533_g((Vector3i)this.currentPos.func_177972_a(dir.func_176746_e()));
                        }
                        mainForwardPos.func_189533_g((Vector3i)mainForwardPos.func_177972_a(dir));
                        this.currentPos.func_189533_g((Vector3i)mainForwardPos);
                    }
                    if (isClear) {
                        decorationStarts.add((Pair<Direction, BlockPos>)new Pair((Object)dir, (Object)start));
                    }
                    if (!shouldTryAgain) continue block1;
                }
            }
        }
        return decorationStarts;
    }

    private void generateDecorations(ArrayList<Pair<Direction, BlockPos>> potentialStarts, ISeedReader reader, Random rand) {
        int decorationIndex = 0;
        BlockPos[] decorationCenters = new BlockPos[3];
        while (decorationIndex < 3 && !potentialStarts.isEmpty()) {
            BlockPos[][] decorationPositions;
            block35: {
                int j;
                int i;
                Direction dir;
                block34: {
                    Pair<Direction, BlockPos> positionInfo = potentialStarts.get(rand.nextInt(potentialStarts.size()));
                    this.currentPos.func_189533_g((Vector3i)positionInfo.getSecond());
                    dir = (Direction)positionInfo.getFirst();
                    decorationPositions = new BlockPos[5][5];
                    this.currentPos.func_189533_g((Vector3i)this.currentPos.func_177967_a(dir.func_176735_f(), 2));
                    BlockPos.Mutable mainForwardPos = this.currentPos.func_239590_i_();
                    for (int i2 = 0; i2 < 5; ++i2) {
                        for (int j2 = 0; j2 < 5; ++j2) {
                            if (j2 == 2 && i2 == 2) {
                                decorationCenters[decorationIndex] = this.currentPos.func_185334_h();
                            }
                            decorationPositions[j2][i2] = this.currentPos.func_185334_h();
                            this.currentPos.func_189533_g((Vector3i)this.currentPos.func_177972_a(dir.func_176746_e()));
                        }
                        mainForwardPos.func_189533_g((Vector3i)mainForwardPos.func_177972_a(dir));
                        this.currentPos.func_189533_g((Vector3i)mainForwardPos);
                    }
                    boolean doesNotIntersect = true;
                    if (decorationIndex > 0) {
                        this.currentPos.func_189533_g((Vector3i)decorationCenters[decorationIndex]);
                        for (i = 0; i < decorationIndex; ++i) {
                            if (Math.abs(this.currentPos.func_177958_n() - decorationCenters[i].func_177958_n()) > 5 || Math.abs(this.currentPos.func_177952_p() - decorationCenters[i].func_177952_p()) > 5) continue;
                            doesNotIntersect = false;
                            break;
                        }
                    }
                    potentialStarts.remove(positionInfo);
                    if (!doesNotIntersect) continue;
                    if (decorationIndex != 0) break block34;
                    switch (rand.nextInt(ModList.get().isLoaded("quark") ? 3 : 2)) {
                        case 0: {
                            for (i = 0; i <= 1; ++i) {
                                for (j = 1; j <= 2; ++j) {
                                    this.currentPos.func_189533_g((Vector3i)decorationPositions[j][i]);
                                    reader.func_180501_a((BlockPos)this.currentPos, Blocks.field_150462_ai.func_176223_P(), 3);
                                    this.currentPos.func_189533_g((Vector3i)this.currentPos.func_177972_a(Direction.UP));
                                    if (i == 1 && j == 2) {
                                        reader.func_180501_a((BlockPos)this.currentPos, (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir), 3);
                                        LockableLootTileEntity.func_195479_a((IBlockReader)reader, (Random)rand, (BlockPos)this.currentPos, (ResourceLocation)new ResourceLocation("savageandravage", "chests/enclosure"));
                                        continue;
                                    }
                                    reader.func_180501_a((BlockPos)this.currentPos, Blocks.field_150462_ai.func_176223_P(), 3);
                                }
                            }
                            break block35;
                        }
                        case 1: {
                            for (i = 0; i < 3; ++i) {
                                BlockState stairsState;
                                if (i == 0) {
                                    stairsState = (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir);
                                    reader.func_180501_a(decorationPositions[1][i], stairsState, 3);
                                    reader.func_180501_a(decorationPositions[2][i], stairsState, 3);
                                    reader.func_180501_a(decorationPositions[3][i], stairsState, 3);
                                    continue;
                                }
                                if (i == 1) {
                                    reader.func_180501_a(decorationPositions[1][i], (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir.func_176746_e()), 3);
                                    reader.func_180501_a(decorationPositions[2][i], ((Block)SRBlocks.BLAST_PROOF_PLATES.get()).func_176223_P(), 3);
                                    reader.func_180501_a(decorationPositions[2][i].func_177972_a(Direction.UP), (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir), 3);
                                    LockableLootTileEntity.func_195479_a((IBlockReader)reader, (Random)rand, (BlockPos)decorationPositions[2][i].func_177972_a(Direction.UP), (ResourceLocation)new ResourceLocation("savageandravage", "chests/enclosure"));
                                    reader.func_180501_a(decorationPositions[3][i], (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir.func_176735_f()), 3);
                                    continue;
                                }
                                stairsState = (BlockState)((Block)SRBlocks.BLAST_PROOF_STAIRS.get()).func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir.func_176734_d());
                                reader.func_180501_a(decorationPositions[1][i], stairsState, 3);
                                reader.func_180501_a(decorationPositions[2][i], stairsState, 3);
                                reader.func_180501_a(decorationPositions[3][i], stairsState, 3);
                            }
                            break block35;
                        }
                        case 2: {
                            reader.func_180501_a(decorationPositions[2][0], ((Block)SRBlocks.CREEPER_SPORE_SACK.get()).func_176223_P(), 3);
                            reader.func_180501_a(decorationPositions[3][0], (BlockState)Blocks.field_150486_ae.func_176223_P().func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)dir), 3);
                            LockableLootTileEntity.func_195479_a((IBlockReader)reader, (Random)rand, (BlockPos)decorationPositions[3][0], (ResourceLocation)new ResourceLocation("savageandravage", "chests/enclosure"));
                        }
                    }
                    break block35;
                }
                switch (rand.nextInt(3)) {
                    case 0: {
                        for (i = 0; i < 6; ++i) {
                            if (i == 0 || i == 4) {
                                for (j = 0; j < 5; ++j) {
                                    reader.func_180501_a(decorationPositions[j][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                    reader.func_180501_a(decorationPositions[j][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                                    if (i != 4) continue;
                                    reader.func_180501_a(decorationPositions[2][i], Blocks.field_196672_s.func_176223_P(), 3);
                                }
                                continue;
                            }
                            if (i == 5) {
                                reader.func_180501_a(decorationPositions[2][4].func_177972_a(dir), (BlockState)Blocks.field_196699_eK.func_176223_P().func_206870_a((Property)HorizontalFaceBlock.field_185512_D, (Comparable)dir), 3);
                                continue;
                            }
                            reader.func_180501_a(decorationPositions[0][i], Blocks.field_180406_aS.func_176223_P(), 3);
                            reader.func_180501_a(decorationPositions[0][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                            reader.func_180501_a(decorationPositions[4][i], Blocks.field_180406_aS.func_176223_P(), 3);
                            reader.func_180501_a(decorationPositions[4][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                            if (i != 3) continue;
                            reader.func_180501_a(decorationPositions[2][i], ((Block)SRBlocks.SPORE_BOMB.get()).func_176223_P(), 3);
                        }
                        break;
                    }
                    case 1: {
                        for (i = 0; i < 4; ++i) {
                            if (i > 0 && i < 3) {
                                reader.func_180501_a(decorationPositions[1][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[1][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[4][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[4][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                                CreeperEntity creeper = (CreeperEntity)EntityType.field_200797_k.func_200721_a((World)reader.func_201672_e());
                                if (creeper == null) continue;
                                this.currentPos.func_189533_g((Vector3i)decorationPositions[2 + rand.nextInt(2)][i]);
                                creeper.func_70012_b((double)this.currentPos.func_177958_n(), (double)this.currentPos.func_177956_o(), (double)this.currentPos.func_177952_p(), 0.0f, 0.0f);
                                creeper.func_110163_bv();
                                creeper.func_213386_a((IServerWorld)reader, reader.func_175649_E((BlockPos)this.currentPos), SpawnReason.CHUNK_GENERATION, null, null);
                                reader.func_217376_c((Entity)creeper);
                                continue;
                            }
                            for (int j3 = 1; j3 < 5; ++j3) {
                                reader.func_180501_a(decorationPositions[j3][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[j3][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                            }
                        }
                        break;
                    }
                    case 2: {
                        for (i = 0; i < 3; ++i) {
                            if (i == 1) {
                                reader.func_180501_a(decorationPositions[1][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[1][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[3][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[3][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                                CreeperEntity creeper = (CreeperEntity)EntityType.field_200797_k.func_200721_a((World)reader.func_201672_e());
                                if (creeper == null) continue;
                                this.currentPos.func_189533_g((Vector3i)decorationPositions[2][i]);
                                creeper.func_70012_b((double)this.currentPos.func_177958_n(), (double)this.currentPos.func_177956_o(), (double)this.currentPos.func_177952_p(), 0.0f, 0.0f);
                                creeper.func_110163_bv();
                                creeper.func_213386_a((IServerWorld)reader, reader.func_175649_E((BlockPos)this.currentPos), SpawnReason.CHUNK_GENERATION, null, null);
                                reader.func_217376_c((Entity)creeper);
                                continue;
                            }
                            for (int j4 = 1; j4 < 4; ++j4) {
                                reader.func_180501_a(decorationPositions[j4][i], Blocks.field_180406_aS.func_176223_P(), 3);
                                reader.func_180501_a(decorationPositions[j4][i].func_177972_a(Direction.UP), Blocks.field_180406_aS.func_176223_P(), 3);
                            }
                        }
                        break;
                    }
                }
            }
            BlockPos[][] blockPosArray = decorationPositions;
            int n = blockPosArray.length;
            for (int i = 0; i < n; ++i) {
                BlockPos[] positions;
                for (BlockPos position : positions = blockPosArray[i]) {
                    reader.func_180495_p(position).func_235734_a_((IWorld)reader, position, 3);
                    reader.func_180495_p(position.func_177972_a(Direction.UP)).func_235734_a_((IWorld)reader, position.func_177972_a(Direction.UP), 3);
                }
            }
            ++decorationIndex;
        }
    }
}

