/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.common.entity.IceChunkEntity;
import com.minecraftabnormals.savageandravage.common.entity.IceCloudEntity;
import com.minecraftabnormals.savageandravage.core.registry.SRItems;
import com.minecraftabnormals.savageandravage.core.registry.SRSounds;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.AbstractRaiderEntity;
import net.minecraft.entity.monster.SpellcastingIllagerEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class IceologerEntity
extends SpellcastingIllagerEntity {
    private UUID iceChunkEntityUUID;
    private int iceChunkEntity;
    public double prevChasingPosX;
    public double prevChasingPosY;
    public double prevChasingPosZ;
    public double chasingPosX;
    public double chasingPosY;
    public double chasingPosZ;
    public float prevCameraYaw;
    public float cameraYaw;

    public IceologerEntity(EntityType<IceologerEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SpellcastingIllagerEntity.CastingASpellGoal((SpellcastingIllagerEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AvoidEntityGoal((CreatureEntity)this, PlayerEntity.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new AttackIceChunkGoal());
        this.field_70714_bg.func_75776_a(6, (Goal)new AttackIceCloudGoal());
        this.field_70714_bg.func_75776_a(8, (Goal)new RandomWalkingGoal((CreatureEntity)this, 0.6));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, (Goal)new LookAtGoal((MobEntity)this, MobEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{AbstractRaiderEntity.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractVillagerEntity.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return LivingEntity.func_233639_cI_().func_233815_a_(Attributes.field_233819_b_, 16.0).func_233814_a_(Attributes.field_233824_g_).func_233815_a_(Attributes.field_233821_d_, 0.5);
    }

    private void updateCape() {
        this.prevChasingPosX = this.chasingPosX;
        this.prevChasingPosY = this.chasingPosY;
        this.prevChasingPosZ = this.chasingPosZ;
        double d0 = this.func_226277_ct_() - this.chasingPosX;
        double d1 = this.func_226278_cu_() - this.chasingPosY;
        double d2 = this.func_226281_cx_() - this.chasingPosZ;
        if (d0 > 10.0) {
            this.chasingPosX = this.func_226277_ct_();
        }
        if (d2 > 10.0) {
            this.chasingPosZ = this.func_226281_cx_();
        }
        if (d1 > 10.0) {
            this.chasingPosY = this.func_226278_cu_();
        }
        if (d0 < -10.0) {
            this.chasingPosX = this.func_226277_ct_();
        }
        if (d2 < -10.0) {
            this.chasingPosZ = this.func_226281_cx_();
        }
        if (d1 < -10.0) {
            this.chasingPosY = this.func_226278_cu_();
        }
        this.chasingPosX += d0 * 0.25;
        this.chasingPosZ += d2 * 0.25;
        this.chasingPosY += d1 * 0.25;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.updateCape();
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.prevCameraYaw = this.cameraYaw;
        float f = this.field_70122_E && !this.func_233643_dh_() && !this.func_203007_ba() ? Math.min(0.1f, MathHelper.func_76133_a((double)IceologerEntity.func_213296_b((Vector3d)this.func_213322_ci()))) : 0.0f;
        this.cameraYaw += (f - this.cameraYaw) * 0.4f;
    }

    public void func_213660_a(int wave, boolean p_213660_2_) {
    }

    protected SoundEvent func_184639_G() {
        return (SoundEvent)SRSounds.ENTITY_ICEOLOGER_AMBIENT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SRSounds.ENTITY_ICEOLOGER_DEATH.get();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SRSounds.ENTITY_ICEOLOGER_HURT.get();
    }

    public SoundEvent func_213654_dW() {
        return (SoundEvent)SRSounds.ENTITY_ICEOLOGER_CELEBRATE.get();
    }

    public SoundEvent func_193086_dk() {
        return (SoundEvent)SRSounds.ENTITY_ICEOLOGER_CAST_SPELL.get();
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)SRItems.ICEOLOGER_SPAWN_EGG.get());
    }

    @Nullable
    public IceChunkEntity getIceChunk() {
        if (this.iceChunkEntityUUID != null && this.field_70170_p instanceof ServerWorld) {
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.iceChunkEntityUUID);
            return entity instanceof IceChunkEntity ? (IceChunkEntity)entity : null;
        }
        if (this.iceChunkEntity == 0) {
            return null;
        }
        Entity entity = this.field_70170_p.func_73045_a(this.iceChunkEntity);
        return entity instanceof IceChunkEntity ? (IceChunkEntity)entity : null;
    }

    public void setIceChunk(@Nullable IceChunkEntity target) {
        if (target != null) {
            this.iceChunkEntity = target.func_145782_y();
            this.iceChunkEntityUUID = target.func_110124_au();
        }
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223225_d_;
    }

    public boolean func_213637_dY() {
        return true;
    }

    public static boolean canIceologerSpawn(EntityType<? extends IceologerEntity> patrollerType, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        return worldIn.func_180495_p(pos).func_203425_a(Blocks.field_150433_aE) && IceologerEntity.func_223324_d(patrollerType, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)random);
    }

    class AttackIceCloudGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private AttackIceCloudGoal() {
            super((SpellcastingIllagerEntity)IceologerEntity.this);
        }

        protected int func_190869_f() {
            return 10;
        }

        protected int func_190872_i() {
            return 80;
        }

        protected void func_190868_j() {
            LivingEntity target = IceologerEntity.this.func_70638_az();
            if (target != null) {
                IceCloudEntity iceCloud = new IceCloudEntity(IceologerEntity.this.func_226277_ct_(), IceologerEntity.this.func_226278_cu_(), IceologerEntity.this.func_226281_cx_(), target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), IceologerEntity.this.field_70170_p);
                iceCloud.func_212361_a((Entity)IceologerEntity.this);
                IceologerEntity.this.field_70170_p.func_217376_c((Entity)iceCloud);
            }
        }

        protected SoundEvent func_190871_k() {
            return (SoundEvent)SRSounds.GENERIC_PREPARE_ATTACK.get();
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.SUMMON_VEX;
        }
    }

    class AttackIceChunkGoal
    extends SpellcastingIllagerEntity.UseSpellGoal {
        private AttackIceChunkGoal() {
            super((SpellcastingIllagerEntity)IceologerEntity.this);
        }

        public boolean func_75250_a() {
            return IceologerEntity.this.getIceChunk() == null && super.func_75250_a();
        }

        protected int func_190869_f() {
            return 40;
        }

        protected int func_190872_i() {
            return 100;
        }

        protected void func_190868_j() {
            LivingEntity target = IceologerEntity.this.func_70638_az();
            if (IceologerEntity.this.getIceChunk() == null) {
                IceChunkEntity iceChunk = new IceChunkEntity(IceologerEntity.this.field_70170_p, (Entity)IceologerEntity.this, (Entity)target);
                IceologerEntity.this.setIceChunk(iceChunk);
                IceologerEntity.this.field_70170_p.func_217376_c((Entity)iceChunk);
            }
        }

        protected SoundEvent func_190871_k() {
            return (SoundEvent)SRSounds.GENERIC_PREPARE_ATTACK.get();
        }

        protected SpellcastingIllagerEntity.SpellType func_193320_l() {
            return SpellcastingIllagerEntity.SpellType.FANGS;
        }
    }
}

