/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.savageandravage.core.registry.SREffects;
import com.minecraftabnormals.savageandravage.core.registry.SREntities;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.BlockParticleData;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;

public class IceChunkEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public static final int HOVER_TIME = 80;
    public static final int HOVER_DISTANCE = 3;
    private UUID casterEntityUUID;
    private int casterEntity;
    private UUID targetEntityUUID;
    private int targetEntity;
    private int hoverTicks;

    public IceChunkEntity(EntityType<IceChunkEntity> entityType, World world) {
        super(entityType, world);
    }

    public IceChunkEntity(World world, @Nullable Entity caster, @Nullable Entity target) {
        this((EntityType<IceChunkEntity>)((EntityType)SREntities.ICE_CHUNK.get()), world);
        if (target != null) {
            this.func_70080_a(target.func_226277_ct_(), target.func_226283_e_(1.0) + 3.0, target.func_226281_cx_(), this.field_70177_z, this.field_70125_A);
        }
        this.setCaster(caster);
        this.setTarget(target);
    }

    private void onImpact(RayTraceResult result) {
        if (!this.field_70170_p.func_201670_d()) {
            BlockState state = Blocks.field_150403_cj.func_176223_P();
            SoundType soundtype = state.getSoundType((IWorldReader)this.field_70170_p, this.func_233580_cy_(), null);
            this.func_184185_a(soundtype.func_185845_c(), (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)new BlockParticleData(ParticleTypes.field_197611_d, state), this.func_226277_ct_(), this.func_226278_cu_() + (double)this.func_213302_cg() / 2.0, this.func_226281_cx_(), 256, (double)this.func_213311_cf() / 2.0, (double)this.func_213302_cg() / 2.0, (double)this.func_213311_cf() / 2.0, 1.0);
        }
        this.func_70106_y();
    }

    private void onImpactEntity(EntityRayTraceResult result) {
        Entity entity = result.func_216348_a();
        entity.func_70097_a(DamageSource.func_76354_b((Entity)this, (Entity)this.getCaster()), 8.0f);
        if (entity instanceof LivingEntity) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance((Effect)SREffects.FROSTBITE.get(), 160, 0, false, false, true));
        }
    }

    @Nullable
    public Entity getCaster() {
        if (this.casterEntityUUID != null && this.field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(this.casterEntityUUID);
        }
        return this.casterEntity != 0 ? this.field_70170_p.func_73045_a(this.casterEntity) : null;
    }

    public void setCaster(@Nullable Entity caster) {
        this.casterEntity = caster == null ? 0 : caster.func_145782_y();
        this.casterEntityUUID = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public Entity getTarget() {
        if (this.targetEntityUUID != null && this.field_70170_p instanceof ServerWorld) {
            return ((ServerWorld)this.field_70170_p).func_217461_a(this.targetEntityUUID);
        }
        return this.targetEntity != 0 ? this.field_70170_p.func_73045_a(this.targetEntity) : null;
    }

    public void setTarget(@Nullable Entity target) {
        this.targetEntity = target == null ? 0 : target.func_145782_y();
        this.targetEntityUUID = target == null ? null : target.func_110124_au();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        ++this.hoverTicks;
        Entity target = this.getTarget();
        if (this.hoverTicks < 80) {
            if (target != null) {
                this.func_70107_b(target.func_226277_ct_(), target.func_226283_e_(1.0) + 3.0, target.func_226281_cx_());
            }
        } else if (this.hoverTicks >= 100) {
            if (target != null) {
                this.func_213317_d(Vector3d.field_186680_a);
            }
            this.setTarget(null);
        }
        if (!this.field_70170_p.func_201670_d()) {
            RayTraceResult result = ProjectileHelper.func_234618_a_((Entity)this, this::canHitEntity);
            List intersecting = this.field_70170_p.func_175647_a(Entity.class, this.func_174813_aQ(), this::canHitEntity);
            if (result.func_216346_c() != RayTraceResult.Type.MISS || !intersecting.isEmpty()) {
                intersecting.forEach(e -> this.onImpactEntity(new EntityRayTraceResult(e)));
                if (result.func_216346_c() == RayTraceResult.Type.ENTITY && intersecting.isEmpty()) {
                    this.onImpactEntity((EntityRayTraceResult)result);
                }
                this.onImpact(result);
            }
        }
        if (target == null) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.05, 0.0));
            this.func_70107_b(this.func_226277_ct_() + this.func_213322_ci().func_82615_a(), this.func_226278_cu_() + this.func_213322_ci().func_82617_b(), this.func_226281_cx_() + this.func_213322_ci().func_82616_c());
        }
    }

    protected boolean canHitEntity(Entity entity) {
        if (!entity.func_175149_v() && entity.func_70089_S() && entity.func_70067_L() && !entity.field_70145_X) {
            Entity caster = this.getCaster();
            return caster == null || !caster.func_184223_x(entity);
        }
        return false;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT nbt) {
        this.casterEntityUUID = nbt.func_186855_b("Caster") ? nbt.func_186857_a("Caster") : null;
        this.targetEntityUUID = nbt.func_186855_b("Target") ? nbt.func_186857_a("Target") : null;
        this.hoverTicks = nbt.func_74762_e("HoverTicks");
    }

    protected void func_213281_b(CompoundNBT nbt) {
        if (this.casterEntityUUID != null) {
            nbt.func_186854_a("Caster", this.casterEntityUUID);
        }
        if (this.targetEntityUUID != null) {
            nbt.func_186854_a("Target", this.targetEntityUUID);
        }
        nbt.func_74768_a("HoverTicks", this.hoverTicks);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(PacketBuffer buf) {
        Entity target = this.getTarget();
        buf.func_150787_b(target == null ? 0 : target.func_145782_y());
        buf.func_150787_b(this.hoverTicks);
    }

    public void readSpawnData(PacketBuffer buf) {
        this.targetEntity = buf.func_150792_a();
        this.hoverTicks = buf.func_150792_a();
    }
}

