/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftabnormals.savageandravage.common.entity;

import com.minecraftabnormals.abnormals_core.core.api.IAgeableEntity;
import com.minecraftabnormals.savageandravage.common.entity.IOwnableMob;
import com.minecraftabnormals.savageandravage.common.entity.goals.CreepieSwellGoal;
import com.minecraftabnormals.savageandravage.common.entity.goals.FollowMobOwnerGoal;
import com.minecraftabnormals.savageandravage.common.entity.goals.MobOwnerHurtByTargetGoal;
import com.minecraftabnormals.savageandravage.common.entity.goals.MobOwnerHurtTargetGoal;
import com.minecraftabnormals.savageandravage.core.SRConfig;
import com.minecraftabnormals.savageandravage.core.registry.SRParticles;
import com.minecraftabnormals.savageandravage.core.registry.SRSounds;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.AreaEffectCloudEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IChargeableMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.OcelotEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

@OnlyIn(value=Dist.CLIENT, _interface=IChargeableMob.class)
public class CreepieEntity
extends MonsterEntity
implements IChargeableMob,
IOwnableMob,
IAgeableEntity {
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> POWERED = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IGNITED = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<UUID>> OWNER_UUID = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> CONVERSION_TIME = EntityDataManager.func_187226_a(CreepieEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public boolean attackPlayersOnly;
    public int lastActiveTime;
    public int timeSinceIgnited;
    public int fuseTime = 30;
    private int growingAge = -24000;
    private int forcedAgeTimer;
    private float explosionRadius = 1.2f;
    private boolean hasStartedConverting = false;

    public CreepieEntity(EntityType<? extends CreepieEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70728_aV = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(2, (Goal)new CreepieSwellGoal(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, OcelotEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(3, (Goal)new AvoidEntityGoal((CreatureEntity)this, CatEntity.class, 6.0f, 1.0, 1.2));
        this.field_70714_bg.func_75776_a(4, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowMobOwnerGoal((MobEntity)this, 1.0, 2.0f, 20.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 0.8));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new MobOwnerHurtByTargetGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new MobOwnerHurtTargetGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MobEntity.class, 5, false, false, target -> this.getOwnerId() == null && !(target instanceof CreepieEntity) && !(target instanceof CreeperEntity) && !this.attackPlayersOnly));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, 5, false, false, target -> this.getOwnerId() == null));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 5.0).func_233815_a_(Attributes.field_233821_d_, 0.35);
    }

    public int func_82143_as() {
        return this.func_70638_az() == null ? 3 : 3 + (int)(this.func_110143_aJ() - 1.0f);
    }

    protected boolean func_225511_J_() {
        return this.getOwner() == null;
    }

    public boolean func_230292_f_(PlayerEntity playerIn) {
        return this.getOwner() == null;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        boolean flag = super.func_225503_b_(distance, damageMultiplier);
        this.timeSinceIgnited = (int)((float)this.timeSinceIgnited + distance * 1.5f);
        if (this.timeSinceIgnited > this.fuseTime - 5) {
            this.timeSinceIgnited = this.fuseTime - 5;
        }
        return flag;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STATE, (Object)-1);
        this.field_70180_af.func_187214_a(POWERED, (Object)false);
        this.field_70180_af.func_187214_a(IGNITED, (Object)false);
        this.field_70180_af.func_187214_a(CONVERSION_TIME, (Object)-1);
        this.field_70180_af.func_187214_a(OWNER_UUID, Optional.empty());
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.getOwnerId() != null) {
            compound.func_186854_a("OwnerUUID", this.getOwnerId());
        }
        compound.func_74768_a("Age", this.getGrowingAge());
        compound.func_74768_a("ConversionTime", this.getConversionTime());
        compound.func_74777_a("Fuse", (short)this.fuseTime);
        compound.func_74776_a("ExplosionRadius", this.explosionRadius);
        compound.func_74757_a("Ignited", this.hasIgnited());
        if (((Boolean)this.field_70180_af.func_187225_a(POWERED)).booleanValue()) {
            compound.func_74757_a("Powered", true);
        }
        compound.func_74757_a("AttackPlayersOnly", this.attackPlayersOnly);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (compound.func_150297_b("Fuse", 99)) {
            this.fuseTime = compound.func_74765_d("Fuse");
        }
        if (compound.func_150297_b("ExplosionRadius", 99)) {
            this.explosionRadius = compound.func_74760_g("ExplosionRadius");
        }
        if (compound.func_150297_b("Age", 99)) {
            this.setGrowingAge(compound.func_74762_e("Age"));
        }
        if (compound.func_74767_n("Ignited")) {
            this.ignite();
        }
        this.field_70180_af.func_187227_b(POWERED, (Object)compound.func_74767_n("Powered"));
        if (compound.func_150297_b("ConversionTime", 99) && compound.func_74762_e("ConversionTime") > -1) {
            this.startConversion(compound.func_74762_e("ConversionTime"));
        }
        if (compound.func_186855_b("OwnerUUID")) {
            this.setOwnerId(compound.func_186857_a("OwnerUUID"));
        }
        this.attackPlayersOnly = compound.func_74767_n("AttackPlayersOnly");
    }

    public boolean func_225509_J__() {
        return (Boolean)this.field_70180_af.func_187225_a(POWERED);
    }

    public void setCharged(boolean charged) {
        this.field_70180_af.func_187227_b(POWERED, (Object)charged);
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)Items.field_196167_cx);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return sizeIn.field_220316_b * 0.8f;
    }

    public int getGrowingAge() {
        return this.growingAge;
    }

    private void ageUp(int growthSeconds) {
        int i = this.getGrowingAge();
        if ((i += growthSeconds * 20) > 0) {
            i = 0;
        }
        this.setGrowingAge(i);
        if (this.forcedAgeTimer == 0) {
            this.forcedAgeTimer = 40;
        }
    }

    public void setGrowingAge(int age) {
        int i = this.growingAge;
        this.growingAge = age;
        if (i < 0 && age >= 0) {
            this.startConversion(this.field_70146_Z.nextInt(80) + 160);
        }
    }

    protected void explode() {
        if (!this.field_70170_p.func_201670_d()) {
            Explosion.Mode mode = (Boolean)SRConfig.COMMON.creepieExplosionsDestroyBlocks.get() != false && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this) ? Explosion.Mode.DESTROY : Explosion.Mode.NONE;
            float chargedModifier = this.func_225509_J__() ? 2.0f : 1.0f;
            this.field_70729_aU = true;
            this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.explosionRadius * chargedModifier, mode);
            this.func_70106_y();
            this.spawnLingeringCloud();
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.func_201670_d() && this.forcedAgeTimer > 0) {
            if (this.forcedAgeTimer % 4 == 0) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226282_d_(1.0), this.func_226279_cv_() + 0.5, this.func_226287_g_(1.0), 0.0, 0.0, 0.0);
            }
            --this.forcedAgeTimer;
        }
        if (this.func_70089_S()) {
            int i = this.getGrowingAge();
            if (i < 0) {
                this.setGrowingAge(++i);
            } else if (i > 0) {
                this.setGrowingAge(--i);
            }
        }
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.5f;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return (SoundEvent)SRSounds.ENTITY_CREEPIE_HURT.get();
    }

    protected SoundEvent func_184615_bR() {
        return (SoundEvent)SRSounds.ENTITY_CREEPIE_DEATH.get();
    }

    public void func_70071_h_() {
        if (this.func_70089_S()) {
            int i;
            this.lastActiveTime = this.timeSinceIgnited;
            if (this.hasIgnited()) {
                this.setCreeperState(1);
            }
            if ((i = this.getCreeperState()) > 0 && this.timeSinceIgnited == 0) {
                this.func_184185_a((SoundEvent)SRSounds.ENTITY_CREEPIE_PRIMED.get(), this.func_70599_aP(), this.func_70647_i());
            }
            this.timeSinceIgnited += i;
            if (this.timeSinceIgnited < 0) {
                this.timeSinceIgnited = 0;
            }
            if (this.timeSinceIgnited >= this.fuseTime) {
                this.timeSinceIgnited = this.fuseTime;
                this.explode();
            }
            if (this.isConverting()) {
                if (this.hasStartedConverting) {
                    this.func_184185_a((SoundEvent)SRSounds.ENTITY_CREEPIE_CONVERT.get(), 1.0f, 1.0f);
                    this.hasStartedConverting = false;
                }
                this.setConversionTime(this.getConversionTime() - 1);
                if (this.getConversionTime() <= 0) {
                    this.finishConversion(this.field_70170_p);
                }
                if (this.field_70170_p.func_201670_d()) {
                    this.field_70170_p.func_195594_a((IParticleData)SRParticles.CREEPER_SPORES.get(), this.func_226277_ct_() - 0.5 + (double)this.field_70146_Z.nextFloat(), this.func_226278_cu_() + 0.5, this.func_226281_cx_() - 0.5 + (double)this.field_70146_Z.nextFloat(), 0.0, (double)(this.field_70146_Z.nextFloat() / 5.0f), 0.0);
                }
            }
        }
        super.func_70071_h_();
    }

    public boolean func_70652_k(Entity entityIn) {
        return true;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() == Items.field_196106_bc && this.getGrowingAge() < 0) {
            this.consumeItemFromStack(player, itemstack);
            this.ageUp((int)((float)(-this.getGrowingAge() / 20) * 0.1f));
            return ActionResultType.SUCCESS;
        }
        if (itemstack.func_77973_b() == Items.field_151033_d) {
            this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            if (!this.field_70170_p.func_201670_d()) {
                this.ignite();
                itemstack.func_222118_a(1, (LivingEntity)player, p_213625_1_ -> p_213625_1_.func_213334_d(hand));
            }
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.FAIL;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getCreeperFlashIntensity(float partialTicks) {
        return MathHelper.func_219799_g((float)partialTicks, (float)this.lastActiveTime, (float)this.timeSinceIgnited) / (float)(this.fuseTime - 2);
    }

    public int getCreeperState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public void setCreeperState(int state) {
        this.field_70180_af.func_187227_b(STATE, (Object)state);
    }

    public boolean hasIgnited() {
        return (Boolean)this.field_70180_af.func_187225_a(IGNITED);
    }

    public void ignite() {
        this.field_70180_af.func_187227_b(IGNITED, (Object)true);
    }

    protected void spawnLingeringCloud() {
        Collection collection = this.func_70651_bq();
        if (!collection.isEmpty()) {
            AreaEffectCloudEntity areaeffectcloudentity = new AreaEffectCloudEntity(this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_());
            areaeffectcloudentity.func_184483_a(1.0f);
            areaeffectcloudentity.func_184495_b(-0.5f);
            areaeffectcloudentity.func_184485_d(10);
            areaeffectcloudentity.func_184486_b(areaeffectcloudentity.func_184489_o() / 2);
            areaeffectcloudentity.func_184487_c(-areaeffectcloudentity.func_184490_j() / (float)areaeffectcloudentity.func_184489_o());
            for (EffectInstance effectinstance : collection) {
                areaeffectcloudentity.func_184496_a(new EffectInstance(effectinstance));
            }
            this.field_70170_p.func_217376_c((Entity)areaeffectcloudentity);
        }
    }

    private void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
    }

    public boolean func_184652_a(PlayerEntity player) {
        return !this.func_110167_bD() && this.getOwnerId() != null;
    }

    @Override
    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.field_70180_af.func_187225_a(OWNER_UUID)).orElse(null);
    }

    @Override
    public void setOwnerId(@Nullable UUID ownerId) {
        this.field_70180_af.func_187227_b(OWNER_UUID, Optional.ofNullable(ownerId));
    }

    @Override
    @Nullable
    public LivingEntity getOwner() {
        if (!this.field_70170_p.func_201670_d()) {
            UUID uuid = this.getOwnerId();
            if (uuid == null) {
                return null;
            }
            Entity entity = ((ServerWorld)this.field_70170_p).func_217461_a(uuid);
            return entity instanceof LivingEntity ? (LivingEntity)entity : null;
        }
        return null;
    }

    public boolean func_213336_c(LivingEntity target) {
        return target != this.getOwner() && super.func_213336_c(target);
    }

    @Override
    public boolean shouldAttackEntity(LivingEntity target, LivingEntity owner) {
        boolean shouldAttack = true;
        if (target instanceof IOwnableMob) {
            shouldAttack = ((IOwnableMob)target).getOwner() != owner;
        } else if (target instanceof TameableEntity) {
            shouldAttack = ((TameableEntity)target).func_70902_q() != owner;
        } else if (target instanceof PlayerEntity && owner instanceof PlayerEntity) {
            shouldAttack = ((PlayerEntity)owner).func_96122_a((PlayerEntity)target);
        }
        return shouldAttack;
    }

    public boolean isConverting() {
        return (Integer)this.func_184212_Q().func_187225_a(CONVERSION_TIME) > -1;
    }

    private void startConversion(int conversionTime) {
        this.setConversionTime(conversionTime);
        this.hasStartedConverting = true;
    }

    public int getConversionTime() {
        return (Integer)this.func_184212_Q().func_187225_a(CONVERSION_TIME);
    }

    private void setConversionTime(int conversionTimeIn) {
        this.field_70180_af.func_187227_b(CONVERSION_TIME, (Object)conversionTimeIn);
    }

    private LivingEntity finishConversion(World world) {
        CreeperEntity creeperEntity = (CreeperEntity)EntityType.field_200797_k.func_200721_a(this.field_70170_p);
        if (creeperEntity == null) {
            return null;
        }
        creeperEntity.func_82149_j((Entity)this);
        if (!this.field_70170_p.func_201670_d()) {
            creeperEntity.func_213386_a((IServerWorld)((ServerWorld)world), this.field_70170_p.func_175649_E(creeperEntity.func_233580_cy_()), SpawnReason.CONVERSION, null, null);
        }
        creeperEntity.func_94061_f(this.func_175446_cd());
        if (this.func_145818_k_()) {
            creeperEntity.func_200203_b(this.func_200201_e());
            creeperEntity.func_174805_g(this.func_174833_aM());
        }
        if (this.func_225509_J__()) {
            creeperEntity.func_184212_Q().func_187227_b(CreeperEntity.field_184714_b, (Object)true);
        }
        if (this.func_104002_bU()) {
            creeperEntity.func_110163_bv();
        }
        if (this.func_110167_bD()) {
            if (this.func_110166_bE() != null) {
                creeperEntity.func_110162_b(this.func_110166_bE(), true);
            }
            this.func_110160_i(true, false);
        }
        if (this.func_184187_bx() != null) {
            creeperEntity.func_184220_m(this.func_184187_bx());
        }
        creeperEntity.func_184224_h(this.func_190530_aW());
        creeperEntity.func_70606_j(creeperEntity.func_110138_aP());
        this.field_70729_aU = true;
        this.func_70106_y();
        this.field_70170_p.func_217376_c((Entity)creeperEntity);
        this.func_184185_a((SoundEvent)SRSounds.ENTITY_CREEPIE_GROW.get(), 1.0f, 1.0f);
        return creeperEntity;
    }

    public Team func_96124_cp() {
        LivingEntity owner = this.getOwner();
        if (owner != null) {
            return owner.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean func_184191_r(Entity entityIn) {
        LivingEntity owner = this.getOwner();
        if (entityIn == owner) {
            return true;
        }
        if (owner != null) {
            return owner.func_184191_r(entityIn);
        }
        return super.func_184191_r(entityIn);
    }

    public boolean hasGrowthProgress() {
        return true;
    }

    public void resetGrowthProgress() {
        this.setGrowingAge(-24000);
    }

    public boolean canAge(boolean isGrowing) {
        return isGrowing;
    }

    public LivingEntity attemptAging(boolean isGrowing) {
        if (isGrowing) {
            this.growingAge = 0;
            return this.finishConversion(this.field_70170_p);
        }
        return this;
    }
}

