/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen.treeplacers;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.blockstateprovider.BlockStateProvider;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import twilightforest.worldgen.TwilightFeatures;

public class DangleFromTreeDecorator
extends TreeDecorator {
    public static final Codec<DangleFromTreeDecorator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.intRange((int)0, (int)32).fieldOf("attempts_minimum").forGetter(o -> o.count), (App)Codec.intRange((int)0, (int)32).fieldOf("random_add_attempts").orElse((Object)0).forGetter(o -> o.randomAddCount), (App)Codec.intRange((int)1, (int)24).fieldOf("minimum_required_length").forGetter(o -> o.minimumRequiredLength), (App)Codec.intRange((int)1, (int)24).fieldOf("base_length").forGetter(o -> o.baseLength), (App)Codec.intRange((int)0, (int)16).fieldOf("random_add_length").orElse((Object)0).forGetter(o -> o.randomAddLength), (App)BlockStateProvider.field_236796_a_.fieldOf("rope_provider").forGetter(o -> o.rope), (App)BlockStateProvider.field_236796_a_.fieldOf("baggage_provider").forGetter(o -> o.baggage)).apply((Applicative)instance, DangleFromTreeDecorator::new));
    private final int count;
    private final int randomAddCount;
    private final int minimumRequiredLength;
    private final int baseLength;
    private final int randomAddLength;
    private final BlockStateProvider rope;
    private final BlockStateProvider baggage;

    public DangleFromTreeDecorator(int count, int randomAddCount, int minimumRequiredLength, int baseLength, int randomAddLength, BlockStateProvider rope, BlockStateProvider baggage) {
        this.count = count;
        this.randomAddCount = randomAddCount;
        this.minimumRequiredLength = minimumRequiredLength;
        this.baseLength = baseLength;
        this.randomAddLength = randomAddLength;
        this.rope = rope;
        this.baggage = baggage;
    }

    protected TreeDecoratorType<DangleFromTreeDecorator> func_230380_a_() {
        return TwilightFeatures.DANGLING_DECORATOR;
    }

    public void func_225576_a_(ISeedReader world, Random random, List<BlockPos> trunkBlocks, List<BlockPos> leafBlocks, Set<BlockPos> decorations, MutableBoundingBox mutableBoundingBox) {
        if (leafBlocks.isEmpty()) {
            return;
        }
        int totalTries = this.count + random.nextInt(this.randomAddCount + 1);
        int leafTotal = leafBlocks.size();
        totalTries = Math.min(totalTries, leafTotal);
        for (int attempt = 0; attempt < totalTries; ++attempt) {
            int ropeUnrolling;
            boolean clearedOfPossibleLeaves = false;
            BlockPos pos = leafBlocks.get(random.nextInt(leafTotal));
            int cordLength = this.baseLength + random.nextInt(this.randomAddLength + 1);
            for (ropeUnrolling = 1; ropeUnrolling <= cordLength; ++ropeUnrolling) {
                boolean isAir = world.func_175623_d(pos.func_177979_c(ropeUnrolling));
                if (!clearedOfPossibleLeaves && isAir) {
                    clearedOfPossibleLeaves = true;
                }
                if (!clearedOfPossibleLeaves || isAir) continue;
                cordLength = ropeUnrolling;
                break;
            }
            if (cordLength <= this.minimumRequiredLength) continue;
            for (ropeUnrolling = 1; ropeUnrolling < cordLength; ++ropeUnrolling) {
                pos = pos.func_177979_c(1);
                this.func_227423_a_((IWorldWriter)world, pos, this.rope.func_225574_a_(random, pos), decorations, mutableBoundingBox);
            }
            pos = pos.func_177979_c(1);
            this.func_227423_a_((IWorldWriter)world, pos, this.baggage.func_225574_a_(random, pos), decorations, mutableBoundingBox);
        }
    }
}

