/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.worldgen;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.foliageplacer.FoliagePlacer;
import net.minecraft.world.gen.foliageplacer.FoliagePlacerType;
import net.minecraft.world.gen.placement.ConfiguredPlacement;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.NoPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraft.world.gen.treedecorator.TreeDecorator;
import net.minecraft.world.gen.treedecorator.TreeDecoratorType;
import net.minecraft.world.gen.trunkplacer.AbstractTrunkPlacer;
import net.minecraft.world.gen.trunkplacer.TrunkPlacerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.TwilightForestMod;
import twilightforest.worldgen.OutOfStructurePlacement;
import twilightforest.worldgen.treeplacers.BranchingTrunkPlacer;
import twilightforest.worldgen.treeplacers.DangleFromTreeDecorator;
import twilightforest.worldgen.treeplacers.HollowTrunkPlacer;
import twilightforest.worldgen.treeplacers.LeafSpheroidFoliagePlacer;
import twilightforest.worldgen.treeplacers.TreeCorePlacer;
import twilightforest.worldgen.treeplacers.TreeRootsDecorator;
import twilightforest.worldgen.treeplacers.TrunkRiser;
import twilightforest.worldgen.treeplacers.TrunkSideDecorator;

@Mod.EventBusSubscriber(modid="twilightforest", bus=Mod.EventBusSubscriber.Bus.MOD)
public final class TwilightFeatures {
    private static final List<FoliagePlacerType<?>> FOLIAGE_PLACER_TYPES = new ArrayList();
    private static final List<TreeDecoratorType<?>> TREE_DECORATOR_TYPES = new ArrayList();
    public static final TrunkPlacerType<BranchingTrunkPlacer> TRUNK_BRANCHING = TwilightFeatures.registerTrunk(TwilightForestMod.prefix("branching_trunk_placer"), BranchingTrunkPlacer.CODEC);
    public static final TrunkPlacerType<TrunkRiser> TRUNK_RISER = TwilightFeatures.registerTrunk(TwilightForestMod.prefix("trunk_mover_upper"), TrunkRiser.CODEC);
    public static final TrunkPlacerType<HollowTrunkPlacer> HOLLOW_TRUNK = TwilightFeatures.registerTrunk(TwilightForestMod.prefix("hollow_trunk_placer"), HollowTrunkPlacer.CODEC);
    public static final FoliagePlacerType<LeafSpheroidFoliagePlacer> FOLIAGE_SPHEROID = TwilightFeatures.registerFoliage(TwilightForestMod.prefix("spheroid_foliage_placer"), LeafSpheroidFoliagePlacer.CODEC);
    public static final TreeDecoratorType<TreeCorePlacer> CORE_PLACER = TwilightFeatures.registerTreeFeature(TwilightForestMod.prefix("core_placer"), TreeCorePlacer.CODEC);
    public static final TreeDecoratorType<TrunkSideDecorator> TRUNKSIDE_DECORATOR = TwilightFeatures.registerTreeFeature(TwilightForestMod.prefix("trunkside_decorator"), TrunkSideDecorator.CODEC);
    public static final TreeDecoratorType<TreeRootsDecorator> TREE_ROOTS = TwilightFeatures.registerTreeFeature(TwilightForestMod.prefix("tree_roots"), TreeRootsDecorator.CODEC);
    public static final TreeDecoratorType<DangleFromTreeDecorator> DANGLING_DECORATOR = TwilightFeatures.registerTreeFeature(TwilightForestMod.prefix("dangle_from_tree_decorator"), DangleFromTreeDecorator.CODEC);
    public static final Placement<NoPlacementConfig> PLACEMENT_NOTFSTRUCTURE = new OutOfStructurePlacement((Codec<NoPlacementConfig>)NoPlacementConfig.field_236555_a_);
    public static final ConfiguredPlacement<?> CONFIGURED_PLACEMENT_NOTFSTRUCTURE = PLACEMENT_NOTFSTRUCTURE.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_);
    public static final ConfiguredPlacement<?> CONFIGURED_PLACEMENT_NOTFSTRUCTURE_WITHHEIGHTMAP = CONFIGURED_PLACEMENT_NOTFSTRUCTURE.func_227228_a_(Placement.field_242904_h.func_227446_a_((IPlacementConfig)NoPlacementConfig.field_236556_b_));

    private static <P extends FoliagePlacer> FoliagePlacerType<P> registerFoliage(ResourceLocation name, Codec<P> codec) {
        FoliagePlacerType type = new FoliagePlacerType(codec);
        type.setRegistryName(name);
        FOLIAGE_PLACER_TYPES.add(type);
        return type;
    }

    private static <P extends AbstractTrunkPlacer> TrunkPlacerType<P> registerTrunk(ResourceLocation name, Codec<P> codec) {
        return (TrunkPlacerType)Registry.func_218322_a((Registry)Registry.field_239701_aw_, (ResourceLocation)name, (Object)new TrunkPlacerType(codec));
    }

    private static <P extends TreeDecorator> TreeDecoratorType<P> registerTreeFeature(ResourceLocation name, Codec<P> codec) {
        TreeDecoratorType type = new TreeDecoratorType(codec);
        type.setRegistryName(name);
        TREE_DECORATOR_TYPES.add(type);
        return type;
    }

    protected static <FC extends IFeatureConfig, F extends Feature<FC>> ConfiguredFeature<FC, F> registerWorldFeature(ResourceLocation rl, ConfiguredFeature<FC, F> feature) {
        return (ConfiguredFeature)Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)rl, feature);
    }

    @SubscribeEvent
    public static void registerFoliagePlacers(RegistryEvent.Register<FoliagePlacerType<?>> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])FOLIAGE_PLACER_TYPES.toArray(new FoliagePlacerType[0]));
    }

    @SubscribeEvent
    public static void registerTreeDecorators(RegistryEvent.Register<TreeDecoratorType<?>> evt) {
        evt.getRegistry().registerAll((IForgeRegistryEntry[])TREE_DECORATOR_TYPES.toArray(new TreeDecoratorType[0]));
    }

    @SubscribeEvent
    public static void registerPlacementConfigs(RegistryEvent.Register<Placement<?>> evt) {
        evt.getRegistry().register(PLACEMENT_NOTFSTRUCTURE.setRegistryName(TwilightForestMod.prefix("nostructure")));
    }
}

