/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures;

import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.DispenserBlock;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.HorizontalFaceBlock;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.tileentity.DispenserTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructureManager;
import net.minecraft.world.gen.feature.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.entity.TFEntities;
import twilightforest.entity.passive.QuestRamEntity;
import twilightforest.structures.TFStructureComponentOld;
import twilightforest.util.ColorUtil;

public class QuestGroveComponent
extends TFStructureComponentOld {
    private static final int RADIUS = 13;
    private static final BlockState MOSSY_STONEBRICK = Blocks.field_196698_dj.func_176223_P();
    private static final BlockState CHISELED_STONEBRICK = Blocks.field_196702_dl.func_176223_P();
    protected boolean beastPlaced = false;
    protected boolean dispenserPlaced = false;

    public QuestGroveComponent(TemplateManager manager, CompoundNBT nbt) {
        super(TFFeature.TFQuest1, nbt);
    }

    public QuestGroveComponent(TFFeature feature, int i, int x, int y, int z) {
        super(TFFeature.TFQuest1, feature, i);
        this.func_186164_a(Direction.SOUTH);
        this.field_74887_e = feature.getComponentToAddBoundingBox(x, y, z, -13, 0, -13, 26, 10, 26, Direction.SOUTH);
    }

    public boolean func_230383_a_(ISeedReader world, StructureManager manager, ChunkGenerator generator, Random rand, MutableBoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        int bz;
        int by;
        int bx;
        BlockPos pos;
        for (Direction e : Direction.Plane.HORIZONTAL) {
            this.makeWallSide(world, e, sbb);
        }
        for (int x = 10; x < 17; ++x) {
            for (int z = 10; z < 17; ++z) {
                if (x == 10 || x == 16 || z == 10 || z == 16) {
                    if (rand.nextInt(2) <= 0) continue;
                    this.func_175811_a(world, MOSSY_STONEBRICK, x, -1, z, sbb);
                    continue;
                }
                if (x == 11 || x == 15 || z == 11 || z == 15) {
                    if (rand.nextInt(3) <= 0) continue;
                    this.func_175811_a(world, MOSSY_STONEBRICK, x, -1, z, sbb);
                    continue;
                }
                this.func_175811_a(world, MOSSY_STONEBRICK, x, -1, z, sbb);
            }
        }
        this.func_175811_a(world, (BlockState)((BlockState)Blocks.field_150430_aB.func_176223_P().func_206870_a((Property)HorizontalFaceBlock.field_196366_M, (Comparable)AttachFace.WALL)).func_206870_a((Property)HorizontalBlock.field_185512_D, (Comparable)Direction.SOUTH), 13, 5, 19, sbb);
        this.func_175811_a(world, MOSSY_STONEBRICK, 12, 7, 20, sbb);
        this.func_175811_a(world, MOSSY_STONEBRICK, 13, 7, 20, sbb);
        this.func_175811_a(world, MOSSY_STONEBRICK, 14, 7, 20, sbb);
        this.func_175811_a(world, MOSSY_STONEBRICK, 12, 7, 21, sbb);
        this.func_175811_a(world, MOSSY_STONEBRICK, 13, 7, 21, sbb);
        this.func_175811_a(world, MOSSY_STONEBRICK, 14, 7, 21, sbb);
        if (!this.dispenserPlaced && sbb.func_175898_b((Vector3i)(pos = new BlockPos(bx = this.func_74865_a(13, 20), by = this.func_74862_a(6), bz = this.func_74873_b(13, 20))))) {
            this.dispenserPlaced = true;
            world.func_180501_a(pos, (BlockState)Blocks.field_150367_z.func_176223_P().func_206870_a((Property)DispenserBlock.field_176441_a, (Comparable)Direction.NORTH), 4);
            DispenserTileEntity ted = (DispenserTileEntity)world.func_175625_s(pos);
            for (int i = 0; i < 4; ++i) {
                ted.func_70299_a(i, new ItemStack((IItemProvider)ColorUtil.WOOL.getRandomColor(rand), 1));
            }
        }
        if (!this.beastPlaced && sbb.func_175898_b((Vector3i)(pos = new BlockPos(bx = this.func_74865_a(13, 13), by = this.func_74862_a(0), bz = this.func_74873_b(13, 13))))) {
            this.beastPlaced = true;
            QuestRamEntity ram = new QuestRamEntity(TFEntities.quest_ram, (World)world.func_201672_e());
            ram.func_70107_b(bx, by, bz);
            ram.func_213390_a(pos, 13);
            ram.func_213386_a((IServerWorld)world, world.func_175649_E(pos), SpawnReason.STRUCTURE, null, null);
            world.func_217376_c((Entity)ram);
        }
        return true;
    }

    private void makeWallSide(ISeedReader world, Direction direction, MutableBoundingBox sbb) {
        Direction temp = this.func_186165_e();
        this.func_186164_a(direction);
        this.placeOuterArch(world, 3, -1, sbb);
        this.placeOuterArch(world, 11, -1, sbb);
        this.placeOuterArch(world, 19, -1, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 0, 0, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 0, 1, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 0, 2, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 0, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 1, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 2, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 8, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 9, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 10, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 16, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 17, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 18, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 24, 3, 0, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 25, 3, 0, sbb);
        for (int x = 0; x < 9; ++x) {
            for (int y = 0; y < 9; ++y) {
                for (int z = 0; z < 2; ++z) {
                    if (x != 0 && x != 1 && x != 7 && x != 8 && y != 0 && y != 1 && y != 7 && y != 8) continue;
                    this.func_175811_a(world, MOSSY_STONEBRICK, x + 9, y - 2, z + 5, sbb);
                }
            }
        }
        this.func_175811_a(world, CHISELED_STONEBRICK, 6, 0, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 6, 1, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 6, 2, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 6, 3, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 6, 4, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 7, 4, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 8, 4, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 18, 4, 6, sbb);
        this.func_175811_a(world, CHISELED_STONEBRICK, 19, 4, 6, sbb);
        this.func_186164_a(temp);
    }

    private void placeOuterArch(ISeedReader world, int ox, int oy, MutableBoundingBox sbb) {
        for (int x = 0; x < 5; ++x) {
            for (int y = 0; y < 6; ++y) {
                if (x != 0 && x != 4 && y != 0 && y != 5) continue;
                this.func_175811_a(world, MOSSY_STONEBRICK, x + ox, y + oy, 0, sbb);
            }
        }
    }
}

