/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import java.io.IOException;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.fml.network.NetworkEvent;
import twilightforest.entity.TFPartEntity;

public class UpdateTFMultipartPacket {
    private int id;
    private PacketBuffer buffer;
    private Entity entity;

    public UpdateTFMultipartPacket(PacketBuffer buf) {
        this.id = buf.readInt();
        this.buffer = buf;
    }

    public UpdateTFMultipartPacket(Entity entity) {
        this.entity = entity;
    }

    public void encode(PacketBuffer buf) {
        try {
            buf.writeInt(this.entity.func_145782_y());
            PartEntity[] parts = this.entity.getParts();
            if (parts != null) {
                for (PartEntity part : parts) {
                    if (!(part instanceof TFPartEntity)) continue;
                    TFPartEntity tfPart = (TFPartEntity)part;
                    tfPart.writeData(buf);
                    boolean dirty = tfPart.func_184212_Q().func_187223_a();
                    buf.writeBoolean(dirty);
                    if (!dirty) continue;
                    EntityDataManager.func_187229_a((List)tfPart.func_184212_Q().func_187221_b(), (PacketBuffer)buf);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static class Handler {
        public static boolean onMessage(final UpdateTFMultipartPacket message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
                        if (world == null) {
                            return;
                        }
                        Entity ent = world.func_73045_a(message.id);
                        if (ent != null && ent.isMultipartEntity()) {
                            PartEntity[] parts = ent.getParts();
                            if (parts == null) {
                                return;
                            }
                            for (PartEntity part : parts) {
                                List data;
                                if (!(part instanceof TFPartEntity)) continue;
                                TFPartEntity tfPart = (TFPartEntity)part;
                                tfPart.readData(message.buffer);
                                if (!message.buffer.readBoolean() || (data = EntityDataManager.func_187215_b((PacketBuffer)message.buffer)) == null) continue;
                                tfPart.func_184212_Q().func_187218_a(data);
                            }
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            return true;
        }
    }
}

