/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SMapDataPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import twilightforest.TFFeature;
import twilightforest.TFMagicMapData;
import twilightforest.item.TFItems;
import twilightforest.network.MagicMapPacket;
import twilightforest.network.TFPacketHandler;
import twilightforest.worldgen.biomes.BiomeKeys;

public class MagicMapItem
extends FilledMapItem {
    public static final String STR_ID = "magicmap";
    private static final Map<ResourceLocation, MapColorBrightness> BIOME_COLORS = new HashMap<ResourceLocation, MapColorBrightness>();
    private static final Map<ChunkPos, Biome[]> CACHE = new HashMap<ChunkPos, Biome[]>();

    protected MagicMapItem(Item.Properties props) {
        super(props);
    }

    public static ItemStack setupNewMap(World world, int worldX, int worldZ, byte scale, boolean trackingPosition, boolean unlimitedTracking) {
        ItemStack itemstack = new ItemStack((IItemProvider)TFItems.magic_map.get());
        MagicMapItem.createMapData(itemstack, world, worldX, worldZ, scale, trackingPosition, unlimitedTracking, (RegistryKey<World>)world.func_234923_W_());
        return itemstack;
    }

    @Nullable
    public static TFMagicMapData getData(ItemStack stack, World world) {
        return TFMagicMapData.getMagicMapData(world, MagicMapItem.getMapName(MagicMapItem.func_195949_f((ItemStack)stack)));
    }

    @Nullable
    protected TFMagicMapData getCustomMapData(ItemStack stack, World world) {
        TFMagicMapData mapdata = MagicMapItem.getData(stack, world);
        if (mapdata == null && !world.field_72995_K) {
            mapdata = MagicMapItem.createMapData(stack, world, world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e(), 3, false, false, (RegistryKey<World>)world.func_234923_W_());
        }
        return mapdata;
    }

    private static TFMagicMapData createMapData(ItemStack stack, World world, int x, int z, int scale, boolean trackingPosition, boolean unlimitedTracking, RegistryKey<World> dimension) {
        int i = world.func_217395_y();
        TFMagicMapData mapdata = new TFMagicMapData(MagicMapItem.getMapName(i));
        mapdata.func_237241_a_(x, z, scale, trackingPosition, unlimitedTracking, dimension);
        TFMagicMapData.registerMagicMapData(world, mapdata);
        stack.func_196082_o().func_74768_a("map", i);
        return mapdata;
    }

    public static String getMapName(int id) {
        return "magicmap_" + id;
    }

    public void func_77872_a(World world, Entity viewer, MapData data) {
        if (world.func_234923_W_() == data.field_76200_c && viewer instanceof PlayerEntity) {
            int biomesPerPixel = 4;
            int blocksPerPixel = 16;
            int centerX = data.field_76201_a;
            int centerZ = data.field_76199_b;
            int viewerX = MathHelper.func_76128_c((double)(viewer.func_226277_ct_() - (double)centerX)) / blocksPerPixel + 64;
            int viewerZ = MathHelper.func_76128_c((double)(viewer.func_226281_cx_() - (double)centerZ)) / blocksPerPixel + 64;
            int viewRadiusPixels = 512 / blocksPerPixel;
            int startX = (centerX / blocksPerPixel - 64) * biomesPerPixel;
            int startZ = (centerZ / blocksPerPixel - 64) * biomesPerPixel;
            Biome[] biomes = CACHE.computeIfAbsent(new ChunkPos(startX, startZ), pos -> {
                Biome[] array = new Biome[128 * biomesPerPixel * 128 * biomesPerPixel];
                for (int l = 0; l < 128 * biomesPerPixel; ++l) {
                    for (int i1 = 0; i1 < 128 * biomesPerPixel; ++i1) {
                        array[l * 128 * biomesPerPixel + i1] = world.func_226691_t_(new BlockPos(startX * biomesPerPixel + i1 * biomesPerPixel, 0, startZ * biomesPerPixel + l * biomesPerPixel));
                    }
                }
                return array;
            });
            for (int xPixel = viewerX - viewRadiusPixels + 1; xPixel < viewerX + viewRadiusPixels; ++xPixel) {
                for (int zPixel = viewerZ - viewRadiusPixels - 1; zPixel < viewerZ + viewRadiusPixels; ++zPixel) {
                    int worldZ;
                    int worldX;
                    if (xPixel < 0 || zPixel < 0 || xPixel >= 128 || zPixel >= 128) continue;
                    int xPixelDist = xPixel - viewerX;
                    int zPixelDist = zPixel - viewerZ;
                    boolean shouldFuzz = xPixelDist * xPixelDist + zPixelDist * zPixelDist > (viewRadiusPixels - 2) * (viewRadiusPixels - 2);
                    Biome biome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel];
                    Biome overBiome = biomes[xPixel * biomesPerPixel + zPixel * biomesPerPixel * 128 * biomesPerPixel + 1];
                    Biome downBiome = biomes[xPixel * biomesPerPixel + (zPixel * biomesPerPixel + 1) * 128 * biomesPerPixel];
                    biome = overBiome != null && BiomeKeys.STREAM.func_240901_a_().equals((Object)overBiome.getRegistryName()) ? overBiome : (downBiome != null && BiomeKeys.STREAM.func_240901_a_().equals((Object)downBiome.getRegistryName()) ? downBiome : biome);
                    MapColorBrightness colorBrightness = this.getMapColorPerBiome(world, biome);
                    MaterialColor mapcolor = colorBrightness.color;
                    int brightness = colorBrightness.brightness;
                    if (zPixel < 0 || xPixelDist * xPixelDist + zPixelDist * zPixelDist >= viewRadiusPixels * viewRadiusPixels || shouldFuzz && (xPixel + zPixel & 1) == 0) continue;
                    byte orgPixel = data.field_76198_e[xPixel + zPixel * 128];
                    byte ourPixel = (byte)(mapcolor.field_76290_q * 4 + brightness);
                    if (orgPixel != ourPixel) {
                        data.field_76198_e[xPixel + zPixel * 128] = ourPixel;
                        data.func_176053_a(xPixel, zPixel);
                    }
                    if (!TFFeature.isInFeatureChunk(worldX = (centerX / blocksPerPixel + xPixel - 64) * blocksPerPixel, worldZ = (centerZ / blocksPerPixel + zPixel - 64) * blocksPerPixel)) continue;
                    byte mapX = (byte)((float)(worldX - centerX) / (float)blocksPerPixel * 2.0f);
                    byte mapZ = (byte)((float)(worldZ - centerZ) / (float)blocksPerPixel * 2.0f);
                    TFFeature feature = TFFeature.getFeatureAt(worldX, worldZ, (ISeedReader)((ServerWorld)world));
                    TFMagicMapData tfData = (TFMagicMapData)data;
                    tfData.tfDecorations.add(new TFMagicMapData.TFMapDecoration(feature.ordinal(), mapX, mapZ, 8));
                }
            }
        }
    }

    private MapColorBrightness getMapColorPerBiome(World world, Biome biome) {
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        if (biome == null) {
            return new MapColorBrightness(MaterialColor.field_151646_E);
        }
        ResourceLocation key = biome.getRegistryName();
        MapColorBrightness color = BIOME_COLORS.get(key);
        if (color != null) {
            return color;
        }
        return new MapColorBrightness(biome.func_242440_e().func_242502_e().func_204108_a().func_185909_g((IBlockReader)world, BlockPos.field_177992_a));
    }

    private static void setupBiomeColors() {
        MagicMapItem.putBiomeColor(BiomeKeys.FOREST, new MapColorBrightness(MaterialColor.field_151669_i, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.DENSE_FOREST, new MapColorBrightness(MaterialColor.field_151669_i, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.LAKE, new MapColorBrightness(MaterialColor.field_151662_n, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.STREAM, new MapColorBrightness(MaterialColor.field_151662_n, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.SWAMP, new MapColorBrightness(MaterialColor.field_151648_G, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.FIRE_SWAMP, new MapColorBrightness(MaterialColor.field_151655_K, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.CLEARING, new MapColorBrightness(MaterialColor.field_151661_c, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.OAK_SAVANNAH, new MapColorBrightness(MaterialColor.field_151661_c, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.HIGHLANDS, new MapColorBrightness(MaterialColor.field_151664_l, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.THORNLANDS, new MapColorBrightness(MaterialColor.field_151663_o, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.FINAL_PLATEAU, new MapColorBrightness(MaterialColor.field_197656_x, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.FIREFLY_FOREST, new MapColorBrightness(MaterialColor.field_151653_I, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.DARK_FOREST, new MapColorBrightness(MaterialColor.field_151651_C, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.DARK_FOREST_CENTER, new MapColorBrightness(MaterialColor.field_151676_q, 3));
        MagicMapItem.putBiomeColor(BiomeKeys.SNOWY_FOREST, new MapColorBrightness(MaterialColor.field_151666_j, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.GLACIER, new MapColorBrightness(MaterialColor.field_151657_g, 1));
        MagicMapItem.putBiomeColor(BiomeKeys.MUSHROOM_FOREST, new MapColorBrightness(MaterialColor.field_151676_q, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.DENSE_MUSHROOM_FOREST, new MapColorBrightness(MaterialColor.field_151671_v, 0));
        MagicMapItem.putBiomeColor(BiomeKeys.ENCHANTED_FOREST, new MapColorBrightness(MaterialColor.field_151679_y, 2));
        MagicMapItem.putBiomeColor(BiomeKeys.SPOOKY_FOREST, new MapColorBrightness(MaterialColor.field_151678_z, 0));
    }

    private static void putBiomeColor(RegistryKey<Biome> biome, MapColorBrightness color) {
        BIOME_COLORS.put(biome.func_240901_a_(), color);
    }

    public static int getBiomeColor(Biome biome) {
        MapColorBrightness c;
        if (BIOME_COLORS.isEmpty()) {
            MagicMapItem.setupBiomeColors();
        }
        return (c = BIOME_COLORS.get(ForgeRegistries.BIOMES.getKey((IForgeRegistryEntry)biome))) != null ? MagicMapItem.getMapColor(c) : -16777216;
    }

    public static int getMapColor(MapColorBrightness mcb) {
        int i = 220;
        switch (mcb.color.field_76290_q) {
            case 3: {
                i = 135;
                break;
            }
            case 2: {
                i = 255;
                break;
            }
            case 0: {
                i = 180;
            }
        }
        int j = (mcb.color.field_76291_p >> 16 & 0xFF) * i / 255;
        int k = (mcb.color.field_76291_p >> 8 & 0xFF) * i / 255;
        int l = (mcb.color.field_76291_p & 0xFF) * i / 255;
        return 0xFF000000 | l << 16 | k << 8 | j;
    }

    public void func_77622_d(ItemStack stack, World world, PlayerEntity player) {
    }

    @Nullable
    public IPacket<?> func_150911_c(ItemStack stack, World world, PlayerEntity player) {
        IPacket p = super.func_150911_c(stack, world, player);
        if (p instanceof SMapDataPacket) {
            TFMagicMapData mapdata = this.getCustomMapData(stack, world);
            return TFPacketHandler.CHANNEL.toVanillaPacket((Object)new MagicMapPacket(mapdata, (SMapDataPacket)p), NetworkDirection.PLAY_TO_CLIENT);
        }
        return p;
    }

    private static class MapColorBrightness {
        public MaterialColor color;
        public int brightness;

        public MapColorBrightness(MaterialColor color, int brightness) {
            this.color = color;
            this.brightness = brightness;
        }

        public MapColorBrightness(MaterialColor color) {
            this.color = color;
            this.brightness = 1;
        }
    }
}

