/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.client.model.armor.FieryArmorModel;

public class FieryArmorItem
extends ArmorItem {
    private static final Map<EquipmentSlotType, BipedModel<?>> fieryArmorModel = new EnumMap(EquipmentSlotType.class);

    public FieryArmorItem(IArmorMaterial armorMaterial, EquipmentSlotType armorType, Item.Properties props) {
        super(armorMaterial, armorType, props);
    }

    public String getArmorTexture(ItemStack itemstack, Entity entity, EquipmentSlotType slot, String layer) {
        if (slot == EquipmentSlotType.LEGS) {
            return "twilightforest:textures/armor/fiery_2.png";
        }
        return "twilightforest:textures/armor/fiery_1.png";
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flags) {
        super.func_77624_a(stack, world, tooltip, flags);
        tooltip.add((ITextComponent)new TranslationTextComponent(this.func_77658_a() + ".tooltip"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public <A extends BipedModel<?>> A getArmorModel(LivingEntity entityLiving, ItemStack itemStack, EquipmentSlotType armorSlot, A oldModel) {
        return (A)fieryArmorModel.get(armorSlot);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initArmorModel() {
        fieryArmorModel.put(EquipmentSlotType.HEAD, new FieryArmorModel(0.75f));
        fieryArmorModel.put(EquipmentSlotType.CHEST, new FieryArmorModel(1.0f));
        fieryArmorModel.put(EquipmentSlotType.LEGS, new FieryArmorModel(0.5f));
        fieryArmorModel.put(EquipmentSlotType.FEET, new FieryArmorModel(1.0f));
    }
}

