/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.enums;

import java.util.Locale;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.SkullBlock;
import net.minecraft.util.IStringSerializable;
import twilightforest.tileentity.spawner.AlphaYetiSpawnerTileEntity;
import twilightforest.tileentity.spawner.BossSpawnerTileEntity;
import twilightforest.tileentity.spawner.FinalBossSpawnerTileEntity;
import twilightforest.tileentity.spawner.HydraSpawnerTileEntity;
import twilightforest.tileentity.spawner.KnightPhantomSpawnerTileEntity;
import twilightforest.tileentity.spawner.LichSpawnerTileEntity;
import twilightforest.tileentity.spawner.MinoshroomSpawnerTileEntity;
import twilightforest.tileentity.spawner.NagaSpawnerTileEntity;
import twilightforest.tileentity.spawner.SnowQueenSpawnerTileEntity;
import twilightforest.tileentity.spawner.TowerBossSpawnerTileEntity;

public enum BossVariant implements IStringSerializable,
SkullBlock.ISkullType
{
    NAGA(TrophyType.GOLD, NagaSpawnerTileEntity::new),
    LICH(TrophyType.GOLD, LichSpawnerTileEntity::new),
    HYDRA(TrophyType.GOLD, HydraSpawnerTileEntity::new),
    UR_GHAST(TrophyType.GOLD, TowerBossSpawnerTileEntity::new),
    KNIGHT_PHANTOM(TrophyType.IRON, KnightPhantomSpawnerTileEntity::new),
    SNOW_QUEEN(TrophyType.GOLD, SnowQueenSpawnerTileEntity::new),
    MINOSHROOM(TrophyType.IRON, MinoshroomSpawnerTileEntity::new),
    ALPHA_YETI(TrophyType.IRON, AlphaYetiSpawnerTileEntity::new),
    QUEST_RAM(TrophyType.IRONWOOD, null),
    FINAL_BOSS(TrophyType.GOLD, FinalBossSpawnerTileEntity::new);

    private final Supplier<? extends BossSpawnerTileEntity<?>> factory;
    private final TrophyType trophyType;
    public static final BossVariant[] VARIANTS;

    private BossVariant(TrophyType trophyType, Supplier<? extends BossSpawnerTileEntity<?>> factory) {
        this.factory = factory;
        this.trophyType = trophyType;
    }

    public String func_176610_l() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public TrophyType getTrophyType() {
        return this.trophyType;
    }

    public boolean hasSpawner() {
        return this.factory != null;
    }

    @Nullable
    public BossSpawnerTileEntity<?> getSpawner() {
        return this.factory != null ? this.factory.get() : null;
    }

    static {
        VARIANTS = BossVariant.values();
    }

    public static enum TrophyType {
        GOLD("trophy"),
        IRON("trophy_minor"),
        IRONWOOD("trophy_quest");

        private final String modelName;

        private TrophyType(String modelName) {
            this.modelName = modelName;
        }

        public String getModelName() {
            return this.modelName;
        }
    }
}

