/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRendersAsItem;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

@OnlyIn(value=Dist.CLIENT, _interface=IRendersAsItem.class)
public class CharmEffectEntity
extends Entity
implements IRendersAsItem {
    private static final DataParameter<Integer> DATA_OWNER = EntityDataManager.func_187226_a(CharmEffectEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<ItemStack> DATA_ITEMID = EntityDataManager.func_187226_a(CharmEffectEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    private static final double DISTANCE = 0.75;
    private double interpTargetX;
    private double interpTargetY;
    private double interpTargetZ;
    private double interpTargetYaw;
    private double interpTargetPitch;
    private int newPosRotationIncrements;
    public float offset;

    public CharmEffectEntity(EntityType<? extends CharmEffectEntity> type, World world) {
        super(type, world);
    }

    public CharmEffectEntity(EntityType<? extends CharmEffectEntity> type, World world, LivingEntity owner, Item item) {
        this(type, world);
        this.setOwner(owner);
        this.setItemID(item);
        this.func_70012_b(owner.func_226277_ct_(), owner.func_226278_cu_() + (double)owner.func_70047_e(), owner.func_226281_cx_(), owner.field_70177_z, owner.field_70125_A);
        Vector3d look = new Vector3d(0.75, 0.0, 0.0);
        double x = this.func_226277_ct_() + look.field_72450_a * 0.75;
        double z = this.func_226281_cx_() + look.field_72449_c * 0.75;
        this.func_70107_b(x, this.func_226278_cu_(), z);
    }

    public void func_70071_h_() {
        LivingEntity orbiting;
        this.field_70142_S = this.func_226277_ct_();
        this.field_70137_T = this.func_226278_cu_();
        this.field_70136_U = this.func_226281_cx_();
        super.func_70071_h_();
        if (this.newPosRotationIncrements > 0) {
            double d0 = this.func_226277_ct_() + (this.interpTargetX - this.func_226277_ct_()) / (double)this.newPosRotationIncrements;
            double d1 = this.func_226278_cu_() + (this.interpTargetY - this.func_226278_cu_()) / (double)this.newPosRotationIncrements;
            double d2 = this.func_226281_cx_() + (this.interpTargetZ - this.func_226281_cx_()) / (double)this.newPosRotationIncrements;
            double d3 = MathHelper.func_76138_g((double)(this.interpTargetYaw - (double)this.field_70177_z));
            this.field_70177_z = (float)((double)this.field_70177_z + d3 / (double)this.newPosRotationIncrements);
            this.field_70125_A = (float)((double)this.field_70125_A + (this.interpTargetPitch - (double)this.field_70125_A) / (double)this.newPosRotationIncrements);
            --this.newPosRotationIncrements;
            this.func_70107_b(d0, d1, d2);
            this.func_70101_b(this.field_70177_z, this.field_70125_A);
        }
        if ((orbiting = this.getOwner()) != null) {
            float rotation = (float)this.field_70173_aa / 10.0f + this.offset;
            Vector3d look = new Vector3d(0.75, 0.0, 0.0).func_178785_b(rotation);
            this.func_70012_b(orbiting.func_226277_ct_() + look.field_72450_a, orbiting.func_226278_cu_() + (double)orbiting.func_70047_e(), orbiting.func_226281_cx_() + look.field_72449_c, orbiting.field_70177_z, orbiting.field_70125_A);
        }
        if (!this.getItemID().func_190926_b()) {
            for (int i = 0; i < 2; ++i) {
                double dx = this.func_226277_ct_() + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                double dy = this.func_226278_cu_() + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                double dz = this.func_226281_cx_() + 0.5 * (this.field_70146_Z.nextDouble() - this.field_70146_Z.nextDouble());
                this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.getItemID()), dx, dy, dz, 0.0, 0.2, 0.0);
            }
        }
        if (!this.field_70170_p.field_72995_K && (this.field_70173_aa > 200 || orbiting != null && !orbiting.func_70089_S())) {
            this.func_70106_y();
        }
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean teleport) {
        this.interpTargetX = x;
        this.interpTargetY = y;
        this.interpTargetZ = z;
        this.interpTargetYaw = yaw;
        this.interpTargetPitch = pitch;
        this.newPosRotationIncrements = posRotationIncrements;
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(DATA_ITEMID, (Object)ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(DATA_OWNER, (Object)-1);
    }

    public void setOwner(LivingEntity owner) {
        this.field_70180_af.func_187227_b(DATA_OWNER, (Object)owner.func_145782_y());
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity e = this.field_70170_p.func_73045_a(((Integer)this.field_70180_af.func_187225_a(DATA_OWNER)).intValue());
        if (e instanceof LivingEntity) {
            return (LivingEntity)e;
        }
        return null;
    }

    public ItemStack getItemID() {
        return (ItemStack)this.field_70180_af.func_187225_a(DATA_ITEMID);
    }

    public void setItemID(Item item) {
        this.field_70180_af.func_187227_b(DATA_ITEMID, (Object)new ItemStack((IItemProvider)item));
    }

    protected void func_70037_a(CompoundNBT cmp) {
    }

    protected void func_213281_b(CompoundNBT cmp) {
    }

    @Nonnull
    public ItemStack func_184543_l() {
        return this.getItemID();
    }
}

