/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.tileentity;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import javax.annotation.Nullable;
import net.minecraft.block.DirectionalBlock;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3f;
import twilightforest.TwilightForestMod;
import twilightforest.client.BugModelAnimationHelper;
import twilightforest.client.model.entity.FireflyModel;
import twilightforest.tileentity.FireflyTileEntity;

public class FireflyTileEntityRenderer
extends TileEntityRenderer<FireflyTileEntity> {
    private final FireflyModel fireflyModel = new FireflyModel();
    private static final ResourceLocation textureLoc = TwilightForestMod.getModelTexture("firefly-tiny.png");
    private static final RenderType GLOW_LAYER;

    public FireflyTileEntityRenderer(TileEntityRendererDispatcher dispatch) {
        super(dispatch);
    }

    public void render(@Nullable FireflyTileEntity te, float partialTicks, MatrixStack ms, IRenderTypeBuffer buffer, int light, int overlay) {
        int yaw = te != null ? te.currentYaw : BugModelAnimationHelper.currentYaw;
        float glow = te != null ? te.glowIntensity : BugModelAnimationHelper.glowIntensity;
        ms.func_227860_a_();
        Direction facing = te != null ? (Direction)te.func_195044_w().func_177229_b((Property)DirectionalBlock.field_176387_N) : Direction.NORTH;
        float rotX = 90.0f;
        float rotZ = 0.0f;
        if (facing == Direction.SOUTH) {
            rotZ = 0.0f;
        } else if (facing == Direction.NORTH) {
            rotZ = 180.0f;
        } else if (facing == Direction.EAST) {
            rotZ = -90.0f;
        } else if (facing == Direction.WEST) {
            rotZ = 90.0f;
        } else if (facing == Direction.UP) {
            rotX = 0.0f;
        } else if (facing == Direction.DOWN) {
            rotX = 180.0f;
        }
        ms.func_227861_a_(0.5, 0.5, 0.5);
        ms.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(rotX));
        ms.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(rotZ));
        ms.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)yaw));
        ms.func_227860_a_();
        ms.func_227862_a_(1.0f, -1.0f, -1.0f);
        IVertexBuilder builder = buffer.getBuffer(RenderType.func_228638_b_((ResourceLocation)textureLoc));
        this.fireflyModel.func_225598_a_(ms, builder, light, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
        builder = buffer.getBuffer(GLOW_LAYER);
        this.fireflyModel.glow.func_228309_a_(ms, builder, 0xF000F0, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, glow);
        ms.func_227865_b_();
        ms.func_227865_b_();
    }

    static {
        RenderState.TransparencyState transparencyState = new RenderState.TransparencyState("twilightforest:firefly_glow", () -> {
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((int)770, (int)1);
        }, () -> {
            RenderSystem.disableBlend();
            RenderSystem.defaultBlendFunc();
        });
        RenderState.AlphaState noAlphaTest = new RenderState.AlphaState(0.0f);
        RenderState.DiffuseLightingState enableDiffuse = new RenderState.DiffuseLightingState(true);
        RenderState.CullState disableCull = new RenderState.CullState(false);
        RenderState.LightmapState enableLightmap = new RenderState.LightmapState(true);
        RenderType.State rendertype$state = RenderType.State.func_228694_a_().func_228724_a_(new RenderState.TextureState(textureLoc, false, false)).func_228726_a_(transparencyState).func_228716_a_(enableDiffuse).func_228713_a_(noAlphaTest).func_228714_a_(disableCull).func_228719_a_(enableLightmap).func_228728_a_(false);
        GLOW_LAYER = RenderType.func_228633_a_((String)"twilightforest:firefly_glow", (VertexFormat)DefaultVertexFormats.field_227852_q_, (int)7, (int)256, (boolean)true, (boolean)true, (RenderType.State)rendertype$state);
    }
}

