/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client.renderer.entity;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Random;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import twilightforest.entity.SlideBlockEntity;

public class SlideBlockRenderer
extends EntityRenderer<SlideBlockEntity> {
    public SlideBlockRenderer(EntityRendererManager manager) {
        super(manager);
        this.field_76989_e = 0.0f;
    }

    public void render(SlideBlockEntity entity, float yaw, float partialTicks, MatrixStack stack, IRenderTypeBuffer buffer, int light) {
        World world;
        BlockState blockstate;
        if (entity.getBlockState() != null && (blockstate = entity.getBlockState()).func_185901_i() == BlockRenderType.MODEL && blockstate != (world = entity.field_70170_p).func_180495_p(entity.func_233580_cy_()) && blockstate.func_185901_i() != BlockRenderType.INVISIBLE) {
            stack.func_227860_a_();
            BlockPos blockpos = new BlockPos(entity.func_226277_ct_(), entity.func_174813_aQ().field_72337_e, entity.func_226281_cx_());
            if (blockstate.func_235904_r_().contains(RotatedPillarBlock.field_176298_M)) {
                Direction.Axis axis = (Direction.Axis)blockstate.func_177229_b((Property)RotatedPillarBlock.field_176298_M);
                float angle = ((float)entity.field_70173_aa + partialTicks) * 60.0f;
                stack.func_227861_a_(0.0, 0.5, 0.0);
                if (axis == Direction.Axis.Y) {
                    stack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(angle));
                } else if (axis == Direction.Axis.X) {
                    stack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(angle));
                } else if (axis == Direction.Axis.Z) {
                    stack.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(angle));
                }
                stack.func_227861_a_(-0.5, -0.5, -0.5);
            }
            BlockRendererDispatcher blockrendererdispatcher = Minecraft.func_71410_x().func_175602_ab();
            for (RenderType type : RenderType.func_228661_n_()) {
                if (!RenderTypeLookup.canRenderInLayer((BlockState)blockstate, (RenderType)type)) continue;
                ForgeHooksClient.setRenderLayer((RenderType)type);
                blockrendererdispatcher.func_175019_b().func_228802_a_((IBlockDisplayReader)world, blockrendererdispatcher.func_184389_a(blockstate), blockstate, blockpos, stack, buffer.getBuffer(type), false, new Random(), blockstate.func_209533_a(blockpos), OverlayTexture.field_229196_a_);
            }
            ForgeHooksClient.setRenderLayer(null);
            stack.func_227865_b_();
            super.func_225623_a_((Entity)entity, yaw, partialTicks, stack, buffer, light);
        }
    }

    public ResourceLocation getEntityTexture(SlideBlockEntity entity) {
        return AtlasTexture.field_110575_b;
    }
}

