/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.capabilities;

import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import twilightforest.capabilities.shield.IShieldCapability;
import twilightforest.capabilities.shield.ShieldCapabilityHandler;
import twilightforest.capabilities.shield.ShieldCapabilityStorage;

public class CapabilityList {
    @CapabilityInject(value=IShieldCapability.class)
    public static final Capability<IShieldCapability> SHIELDS = null;

    public static void registerCapabilities() {
        CapabilityManager.INSTANCE.register(IShieldCapability.class, (Capability.IStorage)new ShieldCapabilityStorage(), ShieldCapabilityHandler::new);
        MinecraftForge.EVENT_BUS.register(CapabilityList.class);
    }

    @SubscribeEvent
    public static void attachEntityCapability(final AttachCapabilitiesEvent<Entity> e) {
        if (e.getObject() instanceof LivingEntity) {
            e.addCapability(IShieldCapability.ID, (ICapabilityProvider)new ICapabilitySerializable<CompoundNBT>(){
                IShieldCapability inst = (IShieldCapability)SHIELDS.getDefaultInstance();
                {
                    this.inst.setEntity((LivingEntity)e.getObject());
                }

                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    return SHIELDS.orEmpty(capability, LazyOptional.of(() -> this.inst));
                }

                public CompoundNBT serializeNBT() {
                    return (CompoundNBT)SHIELDS.getStorage().writeNBT(SHIELDS, (Object)this.inst, null);
                }

                public void deserializeNBT(CompoundNBT nbt) {
                    SHIELDS.getStorage().readNBT(SHIELDS, (Object)this.inst, null, (INBT)nbt);
                }
            });
        }
    }
}

