/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.world.feature.config.BigFungyssFeatureConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.Tags;

public class MegaFungyssFeature
extends Feature<BigFungyssFeatureConfig> {
    public MegaFungyssFeature(Codec<BigFungyssFeatureConfig> codec) {
        super(codec);
    }

    private int getRandomHeight(Random random) {
        return random.nextInt(4) + 11;
    }

    private boolean canGenerate(IWorld world, ChunkGenerator generator, BlockPos pos, int height, BlockPos.Mutable mutable) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height + 1 >= generator.func_230355_e_()) {
            return false;
        }
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!Tags.Blocks.STONE.func_230235_a_((Object)block)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockState state = world.func_180495_p((BlockPos)mutable.func_239621_a_((Vector3i)pos, 0, i, 0));
            if (state.isAir((IBlockReader)world, pos)) continue;
            return false;
        }
        return true;
    }

    public boolean generate(@Nonnull ISeedReader reader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, BigFungyssFeatureConfig config) {
        BlockPos.Mutable mutable;
        int height = this.getRandomHeight(rand);
        if (!this.canGenerate((IWorld)reader, generator, pos, height, mutable = new BlockPos.Mutable())) {
            return false;
        }
        this.placeStem((IWorld)reader, rand, pos, height, mutable, config);
        this.placeCap((IWorld)reader, rand, pos, height, mutable, config);
        return true;
    }

    private void placeStem(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutable, BigFungyssFeatureConfig config) {
        for (int i = 0; i < height; ++i) {
            if (!world.func_180495_p((BlockPos)mutable).canBeReplacedByLogs((IWorldReader)world, (BlockPos)mutable)) continue;
            this.placeStemBlock(world, config.stemProvider.func_225574_a_(random, pos), mutable, pos, 0, i, 0);
            this.placeStemBlock(world, config.stemProvider.func_225574_a_(random, pos), mutable, pos, 1, i, 0);
            this.placeStemBlock(world, config.stemProvider.func_225574_a_(random, pos), mutable, pos, 1, i, 1);
            this.placeStemBlock(world, config.stemProvider.func_225574_a_(random, pos), mutable, pos, 0, i, 1);
        }
    }

    private void placeStemBlock(IWorld world, BlockState state, BlockPos.Mutable mutable, BlockPos pos, int xOffset, int yOffset, int zOffset) {
        mutable.func_189533_g((Vector3i)pos);
        mutable.func_196234_d(xOffset, yOffset, zOffset);
        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, state);
    }

    private void placeCap(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutable, BigFungyssFeatureConfig config) {
        for (int i = height - 3; i <= height; ++i) {
            int zOffset;
            int xOffset;
            int distanceToStem = 2;
            for (xOffset = -distanceToStem; xOffset <= distanceToStem + 1; ++xOffset) {
                for (zOffset = -distanceToStem; zOffset <= distanceToStem + 1; ++zOffset) {
                    boolean moveDown;
                    boolean flag2;
                    boolean flag1 = i >= height && xOffset != -distanceToStem && xOffset != distanceToStem + 1 && zOffset != -distanceToStem && zOffset != distanceToStem + 1;
                    boolean bl = flag2 = i < height && (xOffset == -distanceToStem || xOffset == distanceToStem + 1 || zOffset == -distanceToStem || zOffset == distanceToStem + 1) && (xOffset != -distanceToStem && xOffset != distanceToStem + 1 || zOffset != -distanceToStem && zOffset != distanceToStem + 1);
                    if (!flag1 && !flag2) continue;
                    mutable.func_239621_a_((Vector3i)pos, xOffset, i, zOffset);
                    boolean bl2 = moveDown = xOffset == -1 && zOffset == -1 || xOffset == -1 && zOffset == 2 || xOffset == 2 && zOffset == -1 || xOffset == 2 && zOffset == 2;
                    if (moveDown) {
                        mutable.func_189536_c(Direction.DOWN);
                    }
                    BlockState state = i == height && !moveDown ? config.capProvider.func_225574_a_(random, pos) : (BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.func_225574_a_(random, pos).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(xOffset < 0))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(xOffset > 0))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(zOffset < 0))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(zOffset > 0));
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, state);
                }
            }
            for (xOffset = 0; xOffset <= 1; ++xOffset) {
                for (zOffset = 0; zOffset <= 1; ++zOffset) {
                    for (Direction direction : Direction.values()) {
                        if (direction.func_176740_k() == Direction.Axis.Y) continue;
                        mutable.func_239621_a_((Vector3i)pos, xOffset, height - 5, zOffset);
                        mutable.func_189536_c(direction);
                        if (!world.func_180495_p((BlockPos)mutable).func_196958_f()) continue;
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.func_225574_a_(random, pos).func_206870_a((Property)SixWayBlock.field_196491_B.get(direction.func_176734_d()), (Comparable)Boolean.valueOf(false)));
                    }
                }
            }
        }
        int xOffset = random.nextInt(2);
        int zOffset = random.nextInt(2);
        if (config.variant == 0) {
            this.placeSmallCap(world, random, pos, height, mutable, xOffset, zOffset, config);
            this.placeSmallCap(world, random, pos, height - 2, mutable, xOffset == 0 ? 1 : 0, zOffset == 0 ? 1 : 0, config);
        } else {
            this.placeSmallFungyss(world, random, pos, height - 1, mutable, xOffset, zOffset, config);
            this.placeSmallFungyss(world, random, pos, height - 2, mutable, xOffset == 0 ? 1 : 0, zOffset == 0 ? 1 : 0, config);
        }
    }

    private void placeSmallCap(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutable, int xOffset, int zOffset, BigFungyssFeatureConfig config) {
        Direction direction = this.getDirectionFromOffset(xOffset, zOffset);
        mutable.func_239621_a_((Vector3i)pos, xOffset, height - 8, zOffset);
        mutable.func_189536_c(direction);
        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.func_225574_a_(random, pos).func_206870_a((Property)SixWayBlock.field_196491_B.get(direction.func_176734_d()), (Comparable)Boolean.valueOf(false)));
        for (int i = 0; i <= 1; ++i) {
            direction = direction == Direction.SOUTH ? Direction.EAST : Direction.func_176731_b((int)(direction.func_176736_b() - 1));
            mutable.func_189536_c(direction);
            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.func_225574_a_(random, pos).func_206870_a((Property)SixWayBlock.field_196491_B.get(direction.func_176734_d().func_176746_e()), (Comparable)Boolean.valueOf(false)));
        }
    }

    private void placeSmallFungyss(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutable, int xOffset, int zOffset, BigFungyssFeatureConfig config) {
        Direction direction = this.getDirectionFromOffset(xOffset, zOffset);
        int stemHeight = world.func_201674_k().nextInt(2) + 2;
        mutable.func_239621_a_((Vector3i)pos, xOffset, height - 8, zOffset);
        mutable.func_189536_c(direction);
        if (stemHeight == 3) {
            mutable.func_189536_c(Direction.DOWN);
        }
        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.stemProvider.func_225574_a_(random, pos).func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)direction.func_176740_k()));
        mutable.func_189536_c(direction);
        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.hyphaeProvider.func_225574_a_(random, pos).func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)direction.func_176740_k()));
        for (int i = 0; i < stemHeight; ++i) {
            mutable.func_189536_c(Direction.UP);
            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.stemProvider.func_225574_a_(random, pos).func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)Direction.Axis.Y));
        }
        pos = mutable.func_185334_h();
        int distanceToStem = 1;
        for (int i = stemHeight; i <= stemHeight + 1; ++i) {
            for (int xPos = -distanceToStem; xPos <= distanceToStem; ++xPos) {
                for (int zPos = -distanceToStem; zPos <= distanceToStem; ++zPos) {
                    if ((i >= stemHeight + 1 || xPos == 0 && zPos == 0) && this.isCorner(xPos, zPos, distanceToStem)) continue;
                    mutable.func_239621_a_((Vector3i)pos, xPos, i - stemHeight, zPos);
                    this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, config.capProvider.func_225574_a_(random, pos));
                }
            }
        }
        this.func_230367_a_((IWorldWriter)world, pos.func_177984_a(), config.capProvider.func_225574_a_(random, pos));
    }

    private Direction getDirectionFromOffset(int xOffset, int zOffset) {
        if (xOffset == 0 && zOffset == 0) {
            return Direction.NORTH;
        }
        if (xOffset == 0 && zOffset == 1) {
            return Direction.WEST;
        }
        if (xOffset == 1 && zOffset == 0) {
            return Direction.EAST;
        }
        return Direction.SOUTH;
    }

    private boolean isCorner(int xOffset, int zOffset, int distanceToStem) {
        return (xOffset == -distanceToStem || xOffset == distanceToStem) == (zOffset == -distanceToStem || zOffset == distanceToStem);
    }
}

