/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.world.feature;

import com.mojang.serialization.Codec;
import com.stal111.forbidden_arcanus.world.feature.config.BigFungyssFeatureConfig;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.HugeMushroomBlock;
import net.minecraft.block.SixWayBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.IWorldWriter;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraftforge.common.Tags;

public class BigFungyssFeature
extends Feature<BigFungyssFeatureConfig> {
    public BigFungyssFeature(Codec<BigFungyssFeatureConfig> codec) {
        super(codec);
    }

    private int getRandomHeight(Random random, int variant) {
        if (variant == 0) {
            return random.nextInt(3) + 4;
        }
        return random.nextInt(2) + 6;
    }

    private boolean canGenerate(IWorld world, ChunkGenerator generator, BlockPos pos, int height, BlockPos.Mutable mutable) {
        if (pos.func_177956_o() < 1 || pos.func_177956_o() + height + 1 >= generator.func_230355_e_()) {
            return false;
        }
        Block block = world.func_180495_p(pos.func_177977_b()).func_177230_c();
        if (!Tags.Blocks.STONE.func_230235_a_((Object)block)) {
            return false;
        }
        for (int i = 0; i <= height; ++i) {
            BlockState state = world.func_180495_p((BlockPos)mutable.func_239621_a_((Vector3i)pos, 0, i, 0));
            if (state.isAir((IBlockReader)world, pos)) continue;
            return false;
        }
        return true;
    }

    public boolean generate(@Nonnull ISeedReader reader, @Nonnull ChunkGenerator generator, @Nonnull Random rand, @Nonnull BlockPos pos, BigFungyssFeatureConfig config) {
        BlockPos.Mutable mutable;
        int height = this.getRandomHeight(rand, config.variant);
        if (!this.canGenerate((IWorld)reader, generator, pos, height, mutable = new BlockPos.Mutable())) {
            return false;
        }
        this.placeCap((IWorld)reader, rand, pos, height, mutable, config);
        this.placeStem((IWorld)reader, rand, pos, height, mutable, config);
        return true;
    }

    private void placeStem(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutable, BigFungyssFeatureConfig config) {
        for (int i = 0; i < height; ++i) {
            mutable.func_189533_g((Vector3i)pos).func_189534_c(Direction.UP, i);
            if (!world.func_180495_p((BlockPos)mutable).canBeReplacedByLogs((IWorldReader)world, (BlockPos)mutable)) continue;
            this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, config.stemProvider.func_225574_a_(random, pos));
        }
    }

    private void placeCap(IWorld world, Random random, BlockPos pos, int height, BlockPos.Mutable mutable, BigFungyssFeatureConfig config) {
        if (config.variant == 0) {
            int distanceToStem = 1;
            for (int i = height - 2; i <= height; ++i) {
                for (int xOffset = -distanceToStem; xOffset <= distanceToStem; ++xOffset) {
                    for (int zOffset = -distanceToStem; zOffset <= distanceToStem; ++zOffset) {
                        if ((i >= height || xOffset == 0 && zOffset == 0) && this.isCorner(xOffset, zOffset, distanceToStem)) continue;
                        mutable.func_239621_a_((Vector3i)pos, xOffset, i, zOffset);
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, config.capProvider.func_225574_a_(random, pos));
                    }
                }
            }
            this.func_230367_a_((IWorldWriter)world, pos.func_177981_b(height), config.capProvider.func_225574_a_(random, pos));
        } else {
            for (int i = height - 2; i <= height; ++i) {
                int distanceToStem = i < height ? 2 : 1;
                for (int xOffset = -distanceToStem; xOffset <= distanceToStem; ++xOffset) {
                    for (int zOffset = -distanceToStem; zOffset <= distanceToStem; ++zOffset) {
                        if (i < height && this.isCorner(xOffset, zOffset, distanceToStem)) continue;
                        mutable.func_239621_a_((Vector3i)pos, xOffset, i, zOffset);
                        this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)config.capProvider.func_225574_a_(random, pos).func_206870_a((Property)HugeMushroomBlock.field_196465_z, (Comparable)Boolean.valueOf(i >= height - 1))).func_206870_a((Property)HugeMushroomBlock.field_196464_y, (Comparable)Boolean.valueOf(xOffset < 0))).func_206870_a((Property)HugeMushroomBlock.field_196461_b, (Comparable)Boolean.valueOf(xOffset > 0))).func_206870_a((Property)HugeMushroomBlock.field_196459_a, (Comparable)Boolean.valueOf(zOffset < 0))).func_206870_a((Property)HugeMushroomBlock.field_196463_c, (Comparable)Boolean.valueOf(zOffset > 0)));
                    }
                }
            }
            for (Direction direction : Direction.values()) {
                if (direction.func_176740_k() == Direction.Axis.Y) continue;
                mutable.func_239621_a_((Vector3i)pos, 0, height - 4, 0);
                mutable.func_189536_c(direction);
                this.func_230367_a_((IWorldWriter)world, (BlockPos)mutable, (BlockState)config.capProvider.func_225574_a_(random, pos).func_206870_a((Property)SixWayBlock.field_196491_B.get(direction.func_176734_d()), (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    private boolean isCorner(int xOffset, int zOffset, int distanceToStem) {
        return (xOffset == -distanceToStem || xOffset == distanceToStem) == (zOffset == -distanceToStem || zOffset == distanceToStem);
    }
}

