/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.AxeItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.IBooleanFunction;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.ForgeEventFactory;
import org.lwjgl.glfw.GLFW;

public class ModUtils {
    protected static final Random random = new Random();

    public static ResourceLocation location(String path) {
        return new ResourceLocation("forbidden_arcanus", path);
    }

    public static boolean isShiftDown() {
        return InputMappings.func_216506_a((long)GLFW.glfwGetCurrentContext(), (int)340) || InputMappings.func_216506_a((long)GLFW.glfwGetCurrentContext(), (int)344);
    }

    public static boolean applyBonemeal(ItemStack stack, ServerWorld worldIn, BlockPos pos, PlayerEntity player) {
        IGrowable igrowable;
        BlockState blockstate = worldIn.func_180495_p(pos);
        int hook = ForgeEventFactory.onApplyBonemeal((PlayerEntity)player, (World)worldIn, (BlockPos)pos, (BlockState)blockstate, (ItemStack)stack);
        if (hook != 0) {
            return hook > 0;
        }
        if (blockstate.func_177230_c() instanceof IGrowable && (igrowable = (IGrowable)blockstate.func_177230_c()).func_176473_a((IBlockReader)worldIn, pos, blockstate, worldIn.field_72995_K)) {
            if (!worldIn.field_72995_K && igrowable.func_180670_a((World)worldIn, worldIn.field_73012_v, pos, blockstate)) {
                igrowable.func_225535_a_(worldIn, worldIn.field_73012_v, pos, blockstate);
            }
            return true;
        }
        return false;
    }

    public static void addStrippable(Block block, Block strippedBlock) {
        AxeItem.field_203176_a = Maps.newHashMap((Map)AxeItem.field_203176_a);
        AxeItem.field_203176_a.put(block, strippedBlock);
    }

    public static List<?> removeLastFromList(List<?> list) {
        ArrayList list1 = new ArrayList();
        for (int i = 0; i < list.size() - 1; ++i) {
            list1.add(list.get(i));
        }
        return list1;
    }

    public static void shrinkAndAddStack(PlayerEntity player, Hand hand, ItemStack stack, ItemStack newStack) {
        stack.func_190918_g(1);
        if (stack.func_190926_b()) {
            player.func_184611_a(hand, newStack);
        } else if (!player.field_71071_by.func_70441_a(newStack)) {
            player.func_71019_a(newStack, false);
        }
    }

    public static ScorePlayerTeam createTeam(Scoreboard scoreboard, String name, TextFormatting color) {
        if (scoreboard.func_96531_f().contains(name)) {
            return scoreboard.func_96508_e(name);
        }
        ScorePlayerTeam team = scoreboard.func_96527_f(name);
        team.func_96664_a((ITextComponent)new StringTextComponent(name));
        team.func_178774_a(color);
        return team;
    }

    public static void removeTeam(Scoreboard scoreboard, ScorePlayerTeam team) {
        if (scoreboard.func_96531_f().contains(team.func_96661_b())) {
            scoreboard.func_96511_d(team);
        }
    }

    public static Collection<IRecipe<?>> getRecipesByOutput(ItemStack targetOutput, Collection<IRecipeSerializer<?>> recipeSerializer) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> {
            boolean flag = false;
            for (IRecipeSerializer serializer : recipeSerializer) {
                if (serializer != r.func_199559_b()) continue;
                flag = true;
            }
            return !r.func_192399_d() && flag && ItemStack.func_185132_d((ItemStack)targetOutput, (ItemStack)r.func_77571_b());
        }).collect(Collectors.toList());
    }

    public static Collection<IRecipe<?>> getCraftingRecipesByOutput(@Nonnull ItemStack targetOutput) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> !r.func_192399_d() && (r.func_199559_b() == IRecipeSerializer.field_222157_a || r.func_199559_b() == IRecipeSerializer.field_222158_b) && ItemStack.func_185132_d((ItemStack)targetOutput, (ItemStack)r.func_77571_b())).collect(Collectors.toList());
    }

    public static Collection<IRecipe<?>> getSmeltingRecipesByOutput(@Nonnull ItemStack targetOutput) {
        return Minecraft.func_71410_x().field_71441_e.func_199532_z().func_199510_b().stream().filter(r -> !r.func_192399_d() && r.func_199559_b() == IRecipeSerializer.field_222171_o && ItemStack.func_185132_d((ItemStack)targetOutput, (ItemStack)r.func_77571_b())).collect(Collectors.toList());
    }

    public static boolean hasBlockEnoughSolidSite(VoxelShape shape, IWorldReader world, BlockPos pos, Direction direction) {
        BlockState state = world.func_180495_p(pos);
        if (direction == Direction.DOWN && state.func_235714_a_((ITag)BlockTags.field_232869_aB_)) {
            return false;
        }
        return !VoxelShapes.func_197879_c((VoxelShape)state.func_196951_e((IBlockReader)world, pos).func_212434_a(direction), (VoxelShape)shape, (IBooleanFunction)IBooleanFunction.field_223232_c_);
    }

    public static Vector3d blockPosToVector(BlockPos pos) {
        return ModUtils.blockPosToVector(pos, 0.0);
    }

    public static Vector3d blockPosToVector(BlockPos pos, double offset) {
        return new Vector3d((double)pos.func_177958_n() + offset, (double)pos.func_177956_o() + offset, (double)pos.func_177952_p() + offset);
    }
}

