/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.util;

import com.stal111.forbidden_arcanus.aureal.capability.AurealImpl;
import com.stal111.forbidden_arcanus.aureal.capability.AurealProvider;
import com.stal111.forbidden_arcanus.aureal.capability.IAureal;
import com.stal111.forbidden_arcanus.aureal.consequence.Consequences;
import com.stal111.forbidden_arcanus.aureal.consequence.IConsequence;
import com.stal111.forbidden_arcanus.config.AurealConfig;
import com.stal111.forbidden_arcanus.network.AurealUpdatePacket;
import com.stal111.forbidden_arcanus.network.NetworkHandler;
import com.stal111.forbidden_arcanus.util.ISavedData;
import net.minecraft.entity.player.PlayerEntity;

public class AurealHelper {
    public static IAureal getCapability(PlayerEntity player) {
        return (IAureal)player.getCapability(AurealProvider.CAPABILITY).orElse((Object)new AurealImpl());
    }

    public static int getAureal(PlayerEntity player) {
        return AurealHelper.getCapability(player).getAureal();
    }

    public static void increaseAureal(PlayerEntity player, int amount) {
        AurealHelper.getCapability(player).increaseAureal(amount);
    }

    public static void increaseCorruption(PlayerEntity player, int amount) {
        IAureal aureal = AurealHelper.getCapability(player);
        for (int i = 0; i < amount; ++i) {
            aureal.increaseCorruption(1);
            int corruption = aureal.getCorruption();
            if (corruption <= 10 || ((Boolean)AurealConfig.DISABLE_CONSEQUENCES.get()).booleanValue() || !(player.func_70681_au().nextDouble() < (double)((float)(corruption + 3) / 185.0f))) continue;
            IConsequence consequence = Consequences.getRandomConsequence(player.func_70681_au()).createConsequence();
            consequence.tick(player);
            if (!(consequence instanceof ISavedData)) continue;
            aureal.addActiveConsequence(consequence);
        }
    }

    public static void playerTick(PlayerEntity player) {
        IAureal aureal = AurealHelper.getCapability(player);
        aureal.updateActiveConsequences(player);
        if (!((Boolean)AurealConfig.NATURAL_CORRUPTION_DECREASEMENT.get()).booleanValue()) {
            return;
        }
        if (aureal.getCorruption() >= 1) {
            aureal.setCorruptionTimer(aureal.getCorruptionTimer() + 1);
            if (aureal.getCorruptionTimer() >= (Integer)AurealConfig.NATURAL_CORRUPTION_DECREASEMENT_TIME.get()) {
                aureal.setCorruption(aureal.getCorruption() - 1);
                aureal.setCorruptionTimer(0);
                AurealHelper.sendAurealUpdatePacket(player);
            }
        } else if (aureal.getCorruptionTimer() != 0) {
            aureal.setCorruptionTimer(0);
        }
    }

    public static void sendAurealUpdatePacket(PlayerEntity player) {
        NetworkHandler.sendTo(player, new AurealUpdatePacket(player));
    }
}

