/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.proxy;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public abstract class SideProxy {
    public SideProxy() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SideProxy::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SideProxy::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(SideProxy::processIMC);
        MinecraftForge.EVENT_BUS.addListener(SideProxy::serverStarting);
    }

    private static void commonSetup(FMLCommonSetupEvent event) {
    }

    private static void enqueueIMC(InterModEnqueueEvent event) {
    }

    private static void processIMC(InterModProcessEvent event) {
    }

    private static void serverStarting(FMLServerStartingEvent event) {
    }

    public abstract World getClientWorld();

    public abstract PlayerEntity getClientPlayer();

    public static class Server
    extends SideProxy {
        public Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(Server::serverSetup);
        }

        @OnlyIn(value=Dist.DEDICATED_SERVER)
        private static void serverSetup(FMLDedicatedServerSetupEvent event) {
        }

        @Override
        public World getClientWorld() {
            throw new IllegalStateException("Only run on the client");
        }

        @Override
        public PlayerEntity getClientPlayer() {
            throw new IllegalStateException("Only run on the client");
        }
    }

    public static class Client
    extends SideProxy {
        @Override
        public World getClientWorld() {
            return Minecraft.func_71410_x().field_71441_e;
        }

        @Override
        public PlayerEntity getClientPlayer() {
            return Minecraft.func_71410_x().field_71439_g;
        }
    }
}

