/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.network;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.common.loader.RitualLoader;
import com.stal111.forbidden_arcanus.common.tile.forge.HephaestusForgeTileEntity;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.Ritual;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateRitualPacket {
    private final BlockPos pos;
    @Nullable
    private final Ritual ritual;

    public UpdateRitualPacket(BlockPos pos, @Nullable Ritual ritual) {
        this.pos = pos;
        this.ritual = ritual;
    }

    public static void encode(UpdateRitualPacket packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        ResourceLocation empty = new ResourceLocation("", "");
        buffer.func_192572_a(packet.ritual != null ? packet.ritual.getName() : empty);
    }

    public static UpdateRitualPacket decode(PacketBuffer buffer) {
        return new UpdateRitualPacket(buffer.func_179259_c(), RitualLoader.getRitual(buffer.func_192575_l()));
    }

    public static void consume(UpdateRitualPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = ForbiddenArcanus.proxy.getClientWorld();
            if (world == null || !(world.func_175625_s(packet.pos) instanceof HephaestusForgeTileEntity)) {
                return;
            }
            HephaestusForgeTileEntity tileEntity = (HephaestusForgeTileEntity)world.func_175625_s(packet.pos);
            if (tileEntity != null) {
                tileEntity.getRitualManager().setActiveRitual(packet.ritual);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

