/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.network;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.block.tileentity.PedestalTileEntity;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdatePedestalPacket {
    private final BlockPos pos;
    private final ItemStack stack;
    private final int itemHeight;

    public UpdatePedestalPacket(BlockPos pos, ItemStack stack, int itemHeight) {
        this.pos = pos;
        this.stack = stack;
        this.itemHeight = itemHeight;
    }

    public static void encode(UpdatePedestalPacket packet, PacketBuffer buffer) {
        buffer.func_179255_a(packet.pos);
        buffer.func_150788_a(packet.stack);
        buffer.writeInt(packet.itemHeight);
    }

    public static UpdatePedestalPacket decode(PacketBuffer buffer) {
        return new UpdatePedestalPacket(buffer.func_179259_c(), buffer.func_150791_c(), buffer.readInt());
    }

    public static void consume(UpdatePedestalPacket packet, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            assert (((NetworkEvent.Context)ctx.get()).getDirection() == NetworkDirection.PLAY_TO_CLIENT);
            World world = ForbiddenArcanus.proxy.getClientWorld();
            if (world != null && world.func_175625_s(packet.pos) instanceof PedestalTileEntity) {
                PedestalTileEntity tileEntity = (PedestalTileEntity)Objects.requireNonNull(world.func_175625_s(packet.pos));
                tileEntity.setStack(packet.stack);
                tileEntity.setItemHeight(packet.itemHeight);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

