/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.item;

import com.stal111.forbidden_arcanus.init.ModItems;
import com.stal111.forbidden_arcanus.util.ModTags;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.arguments.EntityAnchorArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.valhelsia.valhelsia_core.util.ItemStackUtils;

public class QuantumCatcherItem
extends Item {
    public QuantumCatcherItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack stack = context.func_195996_i();
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        if (this.getEntity(stack, world) != null) {
            Entity entity = this.getEntity(stack, world);
            if (!world.func_180495_p(pos).func_196953_a(new BlockItemUseContext(context))) {
                pos = pos.func_177972_a(context.func_196000_l());
            }
            if (entity == null || !world.func_180495_p(pos).func_196953_a(new BlockItemUseContext(context))) {
                return ActionResultType.FAIL;
            }
            if (!world.func_201670_d()) {
                entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
                if (context.func_195999_j() != null) {
                    entity.func_200602_a(EntityAnchorArgument.Type.EYES, context.func_195999_j().func_213303_ch());
                }
                world.func_217376_c(entity);
            }
            this.clearEntity(stack);
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return super.func_195939_a(context);
    }

    public ActionResultType onEntityInteract(ItemStack stack, PlayerEntity player, LivingEntity target, Hand hand) {
        World world = player.func_130014_f_();
        if (target instanceof PlayerEntity || ModTags.EntityTypes.QUANTUM_CATCHER_BLACKLISTED.func_230235_a_((Object)target.func_200600_R())) {
            return ActionResultType.PASS;
        }
        if (this.getEntity(stack, world) == null && target.func_70089_S()) {
            if (stack.func_190916_E() != 1) {
                ItemStackUtils.shrinkStack((PlayerEntity)player, (ItemStack)stack);
                ItemStack newStack = new ItemStack((IItemProvider)ModItems.QUANTUM_CATCHER.get());
                this.setEntity((Entity)target, newStack);
                if (!player.func_191521_c(newStack)) {
                    player.func_71019_a(newStack, false);
                }
            } else {
                this.setEntity((Entity)target, stack);
            }
            target.remove(true);
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return super.func_111207_a(stack, player, target, hand);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World world, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flag) {
        Entity entity;
        if (world != null && this.getEntity(stack, world) != null && (entity = this.getEntity(stack, world)) != null) {
            IFormattableTextComponent textComponent = new TranslationTextComponent("tooltip.forbidden_arcanus.entity").func_240702_b_(": ").func_230529_a_((ITextComponent)new StringTextComponent(Objects.requireNonNull(entity.func_200600_R().getRegistryName()).toString()));
            if (this.getEntityName(stack) != null) {
                textComponent.func_240702_b_(" (").func_230529_a_(Objects.requireNonNull(this.getEntityName(stack))).func_240702_b_(")");
            }
            textComponent.func_240699_a_(TextFormatting.GRAY);
            tooltip.add((ITextComponent)textComponent);
        }
    }

    private void setEntity(Entity entity, ItemStack stack) {
        entity.func_184210_p();
        entity.func_184226_ay();
        CompoundNBT entityNBT = new CompoundNBT();
        if (entity.func_200600_R().getRegistryName() == null) {
            return;
        }
        entityNBT.func_74778_a("entity", entity.func_200600_R().getRegistryName().toString());
        if (entity.func_145818_k_()) {
            entityNBT.func_74778_a("name", Objects.requireNonNull(entity.func_200201_e()).getString());
        }
        entity.func_70039_c(entityNBT);
        CompoundNBT itemNBT = stack.func_196082_o();
        itemNBT.func_218657_a("entity", (INBT)entityNBT);
    }

    private Entity getEntity(ItemStack stack, World world) {
        CompoundNBT itemNBT = stack.func_77978_p();
        if (itemNBT == null) {
            return null;
        }
        CompoundNBT entityNBT = itemNBT.func_74775_l("entity");
        EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(entityNBT.func_74779_i("entity")));
        if (entityType == null) {
            return null;
        }
        Entity entity = entityType.func_200721_a(world);
        if (world instanceof ServerWorld && entity != null) {
            entity.func_70020_e(entityNBT);
        }
        return entity;
    }

    private ITextComponent getEntityName(ItemStack stack) {
        CompoundNBT entityNBT;
        CompoundNBT itemNBT = stack.func_77978_p();
        if (itemNBT == null) {
            return null;
        }
        if (itemNBT.func_74764_b("entity") && (entityNBT = itemNBT.func_74775_l("entity")).func_74764_b("name")) {
            return new StringTextComponent(entityNBT.func_74779_i("name"));
        }
        return null;
    }

    private void clearEntity(ItemStack stack) {
        stack.func_77982_d(null);
    }
}

