/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.item;

import com.stal111.forbidden_arcanus.block.ArcaneCrystalObeliskBlock;
import com.stal111.forbidden_arcanus.block.properties.ArcaneCrystalObeliskPart;
import com.stal111.forbidden_arcanus.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.config.ItemConfig;
import com.stal111.forbidden_arcanus.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.init.ModBlocks;
import com.stal111.forbidden_arcanus.init.ModEntities;
import com.stal111.forbidden_arcanus.init.NewModBlocks;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.block.pattern.BlockMaterialMatcher;
import net.minecraft.block.pattern.BlockPattern;
import net.minecraft.block.pattern.BlockPatternBuilder;
import net.minecraft.block.pattern.BlockStateMatcher;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.state.Property;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.valhelsia.valhelsia_core.util.ItemStackUtils;

public class MundabiturDustItem
extends Item {
    @Nullable
    private static BlockPattern hephaestusPattern;
    @Nullable
    private static BlockPattern baseHephaestusPattern;
    @Nullable
    private static BlockPattern arcaneCrystalObeliskPattern;

    public MundabiturDustItem(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player;
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState state = world.func_180495_p(pos = context.func_195995_a());
        Block block = state.func_177230_c();
        if (this.tryTransformBlock(block, world, pos, player = context.func_195999_j())) {
            ItemStackUtils.shrinkStack((PlayerEntity)player, (ItemStack)context.func_195996_i());
            return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
        }
        return super.func_195939_a(context);
    }

    @Nonnull
    public ActionResultType func_111207_a(@Nonnull ItemStack stack, @Nonnull PlayerEntity player, @Nonnull LivingEntity target, @Nonnull Hand hand) {
        EntityDataManager dataManager;
        if (target instanceof CreeperEntity && ((Boolean)ItemConfig.MUNDABITUR_DUST_CHARGE_CREEPER.get()).booleanValue() && !((Boolean)(dataManager = target.func_184212_Q()).func_187225_a(CreeperEntity.field_184714_b)).booleanValue()) {
            dataManager.func_187227_b(CreeperEntity.field_184714_b, (Object)true);
            ItemStackUtils.shrinkStack((PlayerEntity)player, (ItemStack)stack);
            return ActionResultType.func_233537_a_((boolean)player.func_130014_f_().func_201670_d());
        }
        return ActionResultType.PASS;
    }

    private boolean tryTransformBlock(Block block, World world, BlockPos pos, PlayerEntity player) {
        if (block == Blocks.field_222429_lR) {
            BlockPattern.PatternHelper patternHelper = MundabiturDustItem.getHephaestusPattern().func_177681_a((IWorldReader)world, pos);
            if (patternHelper == null || patternHelper.func_177668_c() != Direction.UP) {
                return false;
            }
            world.func_217378_a(player, 2001, pos, Block.func_196246_j((BlockState)world.func_180495_p(pos)));
            world.func_175656_a(pos, (BlockState)ModBlocks.HEPHAESTUS_FORGE.getState().func_206870_a((Property)ModBlockStateProperties.ACTIVATED, (Comparable)Boolean.valueOf(true)));
            CrimsonLightningBoltEntity entity = new CrimsonLightningBoltEntity((EntityType<? extends LightningBoltEntity>)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()), world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
            entity.func_233623_a_(true);
            world.func_217376_c((Entity)entity);
            return true;
        }
        if (block == NewModBlocks.ARCANE_CRYSTAL_BLOCK.get() || block == NewModBlocks.ARCANE_POLISHED_DARKSTONE.get()) {
            BlockPattern.PatternHelper patternHelper = MundabiturDustItem.getArcaneCrystalObeliskPattern().func_177681_a((IWorldReader)world, pos);
            if (patternHelper == null || patternHelper.func_177668_c() != Direction.UP) {
                return false;
            }
            for (int i = 0; i < MundabiturDustItem.getArcaneCrystalObeliskPattern().func_177684_c(); ++i) {
                for (int j = 0; j < MundabiturDustItem.getArcaneCrystalObeliskPattern().func_177685_b(); ++j) {
                    CachedBlockInfo cachedBlockInfo = patternHelper.func_177670_a(i, j, 0);
                    world.func_180501_a(cachedBlockInfo.func_177508_d(), Blocks.field_150350_a.func_176223_P(), 2);
                    world.func_217379_c(2001, cachedBlockInfo.func_177508_d(), Block.func_196246_j((BlockState)cachedBlockInfo.func_177509_a()));
                }
            }
            BlockState state = ((Block)NewModBlocks.ARCANE_CRYSTAL_OBELISK.get()).func_176223_P();
            world.func_180501_a(patternHelper.func_181117_a().func_177979_c(2), (BlockState)state.func_206870_a(ArcaneCrystalObeliskBlock.PART, (Comparable)((Object)ArcaneCrystalObeliskPart.LOWER)), 2);
            world.func_180501_a(patternHelper.func_181117_a().func_177979_c(1), (BlockState)state.func_206870_a(ArcaneCrystalObeliskBlock.PART, (Comparable)((Object)ArcaneCrystalObeliskPart.MIDDLE)), 2);
            world.func_180501_a(patternHelper.func_181117_a(), (BlockState)state.func_206870_a(ArcaneCrystalObeliskBlock.PART, (Comparable)((Object)ArcaneCrystalObeliskPart.UPPER)), 2);
            return true;
        }
        return false;
    }

    public static BlockPattern getHephaestusPattern() {
        if (hephaestusPattern == null) {
            hephaestusPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"~~~~~~~~~", "***PPP***"}).func_177659_a(new String[]{"~~~~~~~~~", "*PPPAPPP*"}).func_177659_a(new String[]{"~~~~~~~~~", "*PAPPPAP*"}).func_177659_a(new String[]{"~~~~~~~~~", "PPPPCPPPP"}).func_177659_a(new String[]{"~~~~^~~~~", "PAPCACPAP"}).func_177659_a(new String[]{"~~~~~~~~~", "PPPPCPPPP"}).func_177659_a(new String[]{"~~~~~~~~~", "*PAPPPAP*"}).func_177659_a(new String[]{"~~~~~~~~~", "*PPPAPPP*"}).func_177659_a(new String[]{"~~~~~~~~~", "***PPP***"}).func_177662_a('^', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)Blocks.field_222429_lR))).func_177662_a('A', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.ARCANE_CHISELED_POLISHED_DARKSTONE.get())))).func_177662_a('C', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.CHISELED_ARCANE_POLISHED_DARKSTONE.get())))).func_177662_a('P', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.POLISHED_DARKSTONE.get())))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177662_a('*', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177661_b();
        }
        return hephaestusPattern;
    }

    public static BlockPattern getBaseHephaestusPattern() {
        if (baseHephaestusPattern == null) {
            baseHephaestusPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"***PPP***"}).func_177659_a(new String[]{"*PPPAPPP*"}).func_177659_a(new String[]{"*PAPPPAP*"}).func_177659_a(new String[]{"PPPPCPPPP"}).func_177659_a(new String[]{"PAPCACPAP"}).func_177659_a(new String[]{"PPPPCPPPP"}).func_177659_a(new String[]{"*PAPPPAP*"}).func_177659_a(new String[]{"*PPPAPPP*"}).func_177659_a(new String[]{"***PPP***"}).func_177662_a('A', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.ARCANE_CHISELED_POLISHED_DARKSTONE.get())))).func_177662_a('C', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.CHISELED_ARCANE_POLISHED_DARKSTONE.get())))).func_177662_a('P', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.POLISHED_DARKSTONE.get())))).func_177662_a('~', CachedBlockInfo.func_177510_a((Predicate)BlockMaterialMatcher.func_189886_a((Material)Material.field_151579_a))).func_177662_a('*', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.field_185928_a)).func_177661_b();
        }
        return baseHephaestusPattern;
    }

    public static BlockPattern getArcaneCrystalObeliskPattern() {
        if (arcaneCrystalObeliskPattern == null) {
            arcaneCrystalObeliskPattern = BlockPatternBuilder.func_177660_a().func_177659_a(new String[]{"#", "#", "X"}).func_177662_a('#', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.ARCANE_CRYSTAL_BLOCK.get())))).func_177662_a('X', CachedBlockInfo.func_177510_a((Predicate)BlockStateMatcher.func_177638_a((Block)((Block)NewModBlocks.ARCANE_POLISHED_DARKSTONE.get())))).func_177661_b();
        }
        return arcaneCrystalObeliskPattern;
    }
}

