/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.item;

import com.stal111.forbidden_arcanus.config.ItemConfig;
import com.stal111.forbidden_arcanus.init.ModEnchantments;
import com.stal111.forbidden_arcanus.init.ModItems;
import com.stal111.forbidden_arcanus.item.EdelwoodFishBucketItem;
import com.stal111.forbidden_arcanus.item.ICapacityBucket;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BlockState;
import net.minecraft.block.IBucketPickupHandler;
import net.minecraft.block.ILiquidContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.stats.Stats;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.wrappers.BucketPickupHandlerWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidBucketWrapper;
import net.valhelsia.valhelsia_core.util.ItemStackUtils;

public class EdelwoodBucketItem
extends Item
implements ICapacityBucket {
    private final Fluid containedBlock;
    private final Supplier<? extends Fluid> fluidSupplier;

    public EdelwoodBucketItem(Fluid containedFluidIn, Item.Properties properties) {
        super(properties);
        this.containedBlock = containedFluidIn;
        this.fluidSupplier = containedFluidIn.delegate;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean isSelected) {
        if (!EnchantmentHelper.func_82781_a((ItemStack)stack).containsKey(ModEnchantments.PERMAFROST.get()) && FluidTags.field_206960_b.func_230235_a_((Object)this.containedBlock) && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            BlockPos pos = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            if (!player.field_71075_bZ.field_75098_d) {
                Random random = new Random();
                if (random.nextDouble() < 0.005 && !world.func_201670_d()) {
                    player.field_71071_by.func_70304_b(slot);
                    player.field_71071_by.func_191971_c(slot, new ItemStack((IItemProvider)Items.field_196155_l));
                    world.func_175656_a(pos, this.containedBlock.func_207188_f().func_206883_i());
                }
            }
        }
        super.func_77663_a(stack, world, entity, slot, isSelected);
    }

    private boolean isValidFluid(Fluid fluid) {
        return fluid.func_207187_a((Fluid)Fluids.field_204547_b) || fluid.func_207187_a((Fluid)Fluids.field_204546_a) || ForgeMod.MILK.isPresent() && fluid.func_207187_a((Fluid)ForgeMod.MILK.get());
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        BlockRayTraceResult raytraceresult;
        ItemStack stack = playerIn.func_184586_b(handIn);
        ActionResult ret = ForgeEventFactory.onBucketUse((PlayerEntity)playerIn, (World)worldIn, (ItemStack)stack, (RayTraceResult)(raytraceresult = EdelwoodBucketItem.func_219968_a((World)worldIn, (PlayerEntity)playerIn, (RayTraceContext.FluidMode)(this.containedBlock == Fluids.field_204541_a || ICapacityBucket.getFullness(stack) != this.getCapacity() && !playerIn.field_71075_bZ.field_75098_d ? RayTraceContext.FluidMode.SOURCE_ONLY : RayTraceContext.FluidMode.NONE))));
        if (ret != null) {
            return ret;
        }
        if (raytraceresult.func_216346_c() == RayTraceResult.Type.MISS) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        if (raytraceresult.func_216346_c() != RayTraceResult.Type.BLOCK) {
            return ActionResult.func_226250_c_((Object)stack);
        }
        BlockRayTraceResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.func_216350_a();
        Direction direction = blockraytraceresult.func_216354_b();
        BlockPos blockpos1 = blockpos.func_177972_a(direction);
        if (worldIn.func_175660_a(playerIn, blockpos) && playerIn.func_175151_a(blockpos1, direction, stack)) {
            BlockPos blockpos2;
            BlockState blockstate1 = worldIn.func_180495_p(blockpos);
            if (this.containedBlock == Fluids.field_204541_a || this.containedBlock == blockstate1.func_204520_s().func_206886_c() && ICapacityBucket.getFullness(stack) != this.getCapacity()) {
                FluidStack fluidStack;
                IFluidHandler fluidHandler = null;
                TileEntity te = worldIn.func_175625_s(blockpos);
                if (te != null) {
                    fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).orElse(null);
                }
                if (fluidHandler == null && blockstate1.func_177230_c() instanceof IBucketPickupHandler) {
                    fluidHandler = new BucketPickupHandlerWrapper((IBucketPickupHandler)blockstate1.func_177230_c(), worldIn, blockpos);
                }
                Fluid fluid = Fluids.field_204541_a;
                if (fluidHandler != null && this.isValidFluid((fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.SIMULATE)).getFluid()) && fluidStack.getAmount() >= 1000) {
                    fluidStack = fluidHandler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    fluid = fluidStack.getFluid();
                }
                if (fluid != Fluids.field_204541_a) {
                    if (stack.func_77973_b() instanceof EdelwoodFishBucketItem) {
                        if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockpos, blockraytraceresult)) {
                            this.onLiquidPlaced(worldIn, stack, blockpos);
                            if (playerIn instanceof ServerPlayerEntity) {
                                CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos, stack);
                            }
                            playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                            return ActionResult.func_226248_a_((Object)this.emptyBucket(stack, playerIn));
                        }
                        return ActionResult.func_226251_d_((Object)stack);
                    }
                    playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                    SoundEvent soundevent = this.containedBlock.getAttributes().getEmptySound();
                    if (soundevent == null) {
                        soundevent = fluid.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187633_N : SoundEvents.field_187630_M;
                    }
                    playerIn.func_184185_a(soundevent, 1.0f, 1.0f);
                    ItemStack filled = ItemStack.field_190927_a;
                    if (fluid.func_207187_a((Fluid)Fluids.field_204546_a)) {
                        filled = this.fillBucket(stack, playerIn, (Item)ModItems.EDELWOOD_WATER_BUCKET.get());
                    } else if (fluid.func_207187_a((Fluid)Fluids.field_204547_b)) {
                        filled = this.fillBucket(stack, playerIn, (Item)ModItems.EDELWOOD_LAVA_BUCKET.get());
                    } else if (ForgeMod.MILK.isPresent() && fluid.func_207187_a((Fluid)ForgeMod.MILK.get())) {
                        filled = this.fillBucket(stack, playerIn, (Item)ModItems.EDELWOOD_MILK_BUCKET.get());
                    }
                    if (!filled.func_190926_b()) {
                        if (!worldIn.field_72995_K) {
                            CriteriaTriggers.field_204813_j.func_204817_a((ServerPlayerEntity)playerIn, new ItemStack((IItemProvider)fluid.func_204524_b()));
                        }
                        return ActionResult.func_226248_a_((Object)filled);
                    }
                    return ActionResult.func_226251_d_((Object)stack);
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            BlockPos blockPos = blockpos2 = blockstate1.func_177230_c() instanceof ILiquidContainer && this.containedBlock == Fluids.field_204546_a ? blockpos : blockpos1;
            if (this.tryPlaceContainedLiquid(playerIn, worldIn, blockpos2, blockraytraceresult)) {
                this.onLiquidPlaced(worldIn, stack, blockpos2);
                if (playerIn instanceof ServerPlayerEntity) {
                    CriteriaTriggers.field_193137_x.func_193173_a((ServerPlayerEntity)playerIn, blockpos2, stack);
                }
                playerIn.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
                return ActionResult.func_226248_a_((Object)this.emptyBucket(stack, playerIn));
            }
            return ActionResult.func_226251_d_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    protected ItemStack emptyBucket(ItemStack stack, PlayerEntity player) {
        if (!player.field_71075_bZ.field_75098_d) {
            int fullness = ICapacityBucket.getFullness(stack);
            if (fullness - 1 > 0) {
                return ICapacityBucket.setFullness(stack, fullness - 1);
            }
            return ItemStackUtils.transferEnchantments((ItemStack)stack, (ItemStack)new ItemStack((IItemProvider)ModItems.EDELWOOD_BUCKET.get()));
        }
        return stack;
    }

    public void onLiquidPlaced(World world, ItemStack stack, BlockPos pos) {
    }

    private ItemStack fillBucket(ItemStack emptyBucket, PlayerEntity player, Item fullBucket) {
        if (player.field_71075_bZ.field_75098_d) {
            return emptyBucket;
        }
        if (emptyBucket.func_77973_b() == fullBucket) {
            return ICapacityBucket.setFullness(emptyBucket, ICapacityBucket.getFullness(emptyBucket) + 1);
        }
        ItemStack stack = ItemStackUtils.transferEnchantments((ItemStack)emptyBucket, (ItemStack)new ItemStack((IItemProvider)fullBucket));
        emptyBucket.func_190918_g(1);
        if (emptyBucket.func_190926_b()) {
            return stack;
        }
        if (!player.field_71071_by.func_70441_a(stack)) {
            player.func_71019_a(stack, false);
        }
        return emptyBucket;
    }

    public boolean tryPlaceContainedLiquid(@Nullable PlayerEntity player, World worldIn, BlockPos posIn, @Nullable BlockRayTraceResult p_180616_4_) {
        if (!(this.containedBlock instanceof FlowingFluid)) {
            return false;
        }
        BlockState blockstate = worldIn.func_180495_p(posIn);
        Material material = blockstate.func_185904_a();
        boolean flag = blockstate.func_227032_a_(this.containedBlock);
        if (blockstate.func_196958_f() || flag || blockstate.func_177230_c() instanceof ILiquidContainer && ((ILiquidContainer)blockstate.func_177230_c()).func_204510_a((IBlockReader)worldIn, posIn, blockstate, this.containedBlock)) {
            if (worldIn.func_230315_m_().func_236040_e_() && this.containedBlock.func_207185_a((ITag)FluidTags.field_206959_a)) {
                int i = posIn.func_177958_n();
                int j = posIn.func_177956_o();
                int k = posIn.func_177952_p();
                worldIn.func_184133_a(player, posIn, SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.5f, 2.6f + (worldIn.field_73012_v.nextFloat() - worldIn.field_73012_v.nextFloat()) * 0.8f);
                for (int l = 0; l < 8; ++l) {
                    worldIn.func_195594_a((IParticleData)ParticleTypes.field_197594_E, (double)i + Math.random(), (double)j + Math.random(), (double)k + Math.random(), 0.0, 0.0, 0.0);
                }
            } else if (blockstate.func_177230_c() instanceof ILiquidContainer && this.containedBlock == Fluids.field_204546_a) {
                if (((ILiquidContainer)blockstate.func_177230_c()).func_204509_a((IWorld)worldIn, posIn, blockstate, ((FlowingFluid)this.containedBlock).func_207204_a(false))) {
                    this.playEmptySound(player, (IWorld)worldIn, posIn);
                }
            } else {
                if (!worldIn.field_72995_K && flag && !material.func_76224_d()) {
                    worldIn.func_175655_b(posIn, true);
                }
                this.playEmptySound(player, (IWorld)worldIn, posIn);
                worldIn.func_180501_a(posIn, this.containedBlock.func_207188_f().func_206883_i(), 11);
            }
            return true;
        }
        return p_180616_4_ != null && this.tryPlaceContainedLiquid(player, worldIn, p_180616_4_.func_216350_a().func_177972_a(p_180616_4_.func_216354_b()), null);
    }

    protected void playEmptySound(@Nullable PlayerEntity player, IWorld worldIn, BlockPos pos) {
        SoundEvent soundevent = this.containedBlock.getAttributes().getEmptySound();
        if (soundevent == null) {
            soundevent = this.containedBlock.func_207185_a((ITag)FluidTags.field_206960_b) ? SoundEvents.field_187627_L : SoundEvents.field_187624_K;
        }
        worldIn.func_184133_a(player, pos, soundevent, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        if (stack.func_77973_b() == ModItems.EDELWOOD_WATER_BUCKET.get() || stack.func_77973_b() == ModItems.EDELWOOD_LAVA_BUCKET.get()) {
            tooltip.add((ITextComponent)new StringTextComponent(" "));
            tooltip.add((ITextComponent)new StringTextComponent(" "));
        }
        super.func_77624_a(stack, world, tooltip, flag);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        if (this.getClass() == EdelwoodBucketItem.class) {
            return new FluidBucketWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public Fluid getFluid() {
        return this.fluidSupplier.get();
    }

    @Override
    public int getCapacity() {
        return this == ModItems.EDELWOOD_BUCKET.get() ? 0 : (this == ModItems.EDELWOOD_WATER_BUCKET.get() ? ((Integer)ItemConfig.EDELWOOD_WATER_BUCKET_CAPACITY.get()).intValue() : ((Integer)ItemConfig.EDELWOOD_LAVA_BUCKET_CAPACITY.get()).intValue());
    }
}

