/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.integration;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.init.ModBlocks;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class HephaestusSmithingCategory
implements IRecipeCategory<Ritual> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("forbidden_arcanus", "textures/gui/container/hephaestus_forge_jei.png");
    private final IDrawable background;
    private final IDrawable icon;
    private final List<EssenceInfo> essences = new ArrayList<EssenceInfo>();
    private final List<Pair<Integer, Integer>> inputPositions = Arrays.asList(new Pair((Object)62, (Object)11), new Pair((Object)84, (Object)23), new Pair((Object)84, (Object)47), new Pair((Object)62, (Object)57), new Pair((Object)40, (Object)47), new Pair((Object)40, (Object)23));
    private final Pair<Integer, Integer> hephaestusForgeItemPosition = new Pair((Object)62, (Object)34);
    private final Pair<Integer, Integer> outputPosition = new Pair((Object)120, (Object)35);
    private final Pair<Integer, Integer> pedestalTypePosition = new Pair((Object)122, (Object)84);

    public HephaestusSmithingCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURE, 0, 0, 147, 107);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)ModBlocks.HEPHAESTUS_FORGE.getBlock()));
        this.essences.addAll(Arrays.asList(new EssenceInfo(guiHelper.createDrawable(TEXTURE, 161, 1, 10, 10), "Aureal", 42, 79), new EssenceInfo(guiHelper.createDrawable(TEXTURE, 173, 1, 10, 10), "Souls", 58, 79), new EssenceInfo(guiHelper.createDrawable(TEXTURE, 185, 1, 10, 10), "Blood", 74, 79), new EssenceInfo(guiHelper.createDrawable(TEXTURE, 197, 1, 10, 10), "Experience", 90, 79)));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return new ResourceLocation("forbidden_arcanus", "hephaestus_smithing");
    }

    @Nonnull
    public Class<? extends Ritual> getRecipeClass() {
        return Ritual.class;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.forbidden_arcanus.category.hephaestusSmithing", (Object[])new Object[0]);
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(@Nonnull Ritual recipe, @Nonnull IIngredients ingredients) {
        ingredients.setInputIngredients(recipe.getInputs());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.getResult());
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull Ritual recipe, @Nonnull IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        itemStacks.init(0, true, ((Integer)this.hephaestusForgeItemPosition.getFirst()).intValue(), ((Integer)this.hephaestusForgeItemPosition.getSecond()).intValue());
        itemStacks.set(0, recipe.getHephaestusForgeItem());
        int index = 1;
        for (int i = 0; i < 6; ++i) {
            Ingredient ingredient2 = recipe.getInput(i);
            if (ingredient2 == null) continue;
            itemStacks.init(index, true, ((Integer)this.inputPositions.get(i).getFirst()).intValue(), ((Integer)this.inputPositions.get(i).getSecond()).intValue());
            itemStacks.set(index, Arrays.asList(ingredient2.func_193365_a()));
            ++index;
        }
        itemStacks.init(index, false, ((Integer)this.outputPosition.getFirst()).intValue(), ((Integer)this.outputPosition.getSecond()).intValue());
        itemStacks.set(index, recipe.getResult());
        itemStacks.init(++index, false, ((Integer)this.pedestalTypePosition.getFirst()).intValue(), ((Integer)this.pedestalTypePosition.getSecond()).intValue());
        itemStacks.set(index, new ItemStack((IItemProvider)recipe.getPedestalType().getBlock()));
        int pedestalIndex = index++;
        itemStacks.addTooltipCallback((slot, input, ingredient, tooltip) -> {
            if (slot == pedestalIndex) {
                tooltip.clear();
                tooltip.add(new TranslationTextComponent("jei.forbidden_arcanus.hephaestusSmithing.requiredPedestal").func_240702_b_(": ").func_230529_a_((ITextComponent)recipe.getPedestalType().getBlock().func_235333_g_()));
                tooltip.add(new TranslationTextComponent("jei.forbidden_arcanus.hephaestusSmithing.requiredLevel").func_240702_b_(": 1"));
            }
        });
    }

    public void draw(@Nonnull Ritual recipe, @Nonnull MatrixStack matrixStack, double mouseX, double mouseY) {
        this.essences.forEach(essenceInfo -> essenceInfo.getDrawable().draw(matrixStack, essenceInfo.getPosX(), essenceInfo.getPosY()));
    }

    @Nonnull
    public List<ITextComponent> getTooltipStrings(@Nonnull Ritual recipe, double mouseX, double mouseY) {
        for (EssenceInfo essenceInfo : this.essences) {
            int posX = essenceInfo.getPosX();
            int posY = essenceInfo.getPosY();
            if (!(mouseX >= (double)posX) || !(mouseY >= (double)posY) || !(mouseX <= (double)(posX + 10)) || !(mouseY <= (double)(posY + 10))) continue;
            return Collections.singletonList(new TranslationTextComponent("jei.forbidden_arcanus.hephaestusSmithing.required" + essenceInfo.getName()).func_240702_b_(": " + recipe.getEssences().getFromName(essenceInfo.getName())));
        }
        return Collections.emptyList();
    }

    private static class EssenceInfo {
        private final IDrawableStatic drawable;
        private final String name;
        private final int posX;
        private final int posY;

        public EssenceInfo(IDrawableStatic drawable, String name, int posX, int posY) {
            this.drawable = drawable;
            this.name = name;
            this.posX = posX;
            this.posY = posY;
        }

        public IDrawableStatic getDrawable() {
            return this.drawable;
        }

        public String getName() {
            return this.name;
        }

        public int getPosX() {
            return this.posX;
        }

        public int getPosY() {
            return this.posY;
        }
    }
}

