/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.gui.forbiddenmicon;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconCategory;
import com.stal111.forbidden_arcanus.gui.forbiddenmicon.ForbiddenmiconEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ForbiddenmiconPageLoadListener
implements IResourceManagerReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final int PATH_PREFIX_LENGTH = "forbiddenmicon/".length();
    public static final int PATH_SUFFIX_LENGTH = ".json".length();
    public static Map<ResourceLocation, ForbiddenmiconEntry> entries = new HashMap<ResourceLocation, ForbiddenmiconEntry>();

    public ForbiddenmiconEntry deserializeJson(ResourceLocation recipeId, JsonObject json) {
        ItemStack stack = ShapedRecipe.func_199798_a((JsonObject)json.get("topic").getAsJsonObject());
        String description = json.has("description") ? json.get("description").getAsString() : "";
        return new ForbiddenmiconEntry(stack, description, ForbiddenmiconCategory.valueOf(json.get("category").getAsString()));
    }

    public void func_195410_a(IResourceManager resourceManager) {
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        for (ResourceLocation resourcelocation : resourceManager.func_199003_a("forbiddenmicon", p_199516_0_ -> p_199516_0_.endsWith(".json") && !p_199516_0_.startsWith("_"))) {
            String s = resourcelocation.func_110623_a();
            ResourceLocation resourcelocation1 = new ResourceLocation(resourcelocation.func_110624_b(), s.substring(PATH_PREFIX_LENGTH, s.length() - PATH_SUFFIX_LENGTH));
            try {
                IResource iresource = resourceManager.func_199002_a(resourcelocation);
                Throwable throwable = null;
                try {
                    JsonObject jsonobject = (JsonObject)JSONUtils.func_188178_a((Gson)gson, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                    if (jsonobject == null) {
                        LOGGER.error("Couldn't load entry {} as it's null or empty", (Object)resourcelocation1);
                        continue;
                    }
                    ForbiddenmiconEntry entry1 = this.deserializeJson(resourcelocation, jsonobject);
                    entries.put(resourcelocation, entry1);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (iresource == null) continue;
                    if (throwable != null) {
                        try {
                            iresource.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    iresource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException e) {
                LOGGER.error("Error loading entry {}", (Object)resourcelocation1, (Object)e);
            }
        }
        LOGGER.info("Loaded {} recipes", (Object)entries.size());
    }

    public Collection<ForbiddenmiconEntry> getEntries(ForbiddenmiconCategory category) {
        ArrayList<ForbiddenmiconEntry> list = new ArrayList<ForbiddenmiconEntry>();
        entries.forEach((location, forbiddenmiconEntry) -> {
            if (forbiddenmiconEntry.getCategory() == category) {
                list.add((ForbiddenmiconEntry)forbiddenmiconEntry);
            }
        });
        return list;
    }
}

