/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.gui.element.button;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.stal111.forbidden_arcanus.gui.element.GuiElement;
import net.minecraft.util.ResourceLocation;

public abstract class ButtonElement
extends GuiElement {
    private final int startX;
    private final int startY;
    private final int blitOffset;
    private final ResourceLocation resourceLocation;
    private boolean activated = false;
    private final IPressable onPress;

    public ButtonElement(int posX, int posY, int blitOffset, int startX, int startY, int sizeX, int sizeY, ResourceLocation resourceLocation, IPressable onPress) {
        super(posX, posY, sizeX, sizeY);
        this.startX = startX;
        this.startY = startY;
        this.blitOffset = blitOffset;
        this.resourceLocation = resourceLocation;
        this.onPress = onPress;
    }

    @Override
    public void render(MatrixStack matrixStack, int x, int y) {
        this.bindTexture(this.resourceLocation);
        this.blit(matrixStack, this.blitOffset, this.startX, this.startY, this.getSizeX(), this.getSizeY(), 256, 512);
    }

    @Override
    public boolean onClicked(double x, double y) {
        if (x >= (double)this.getPosX() && y >= (double)this.getPosY() && x < (double)(this.getPosX() + this.getSizeX()) && y < (double)(this.getPosY() + this.getSizeY())) {
            this.onPress.onPress(this);
        }
        return false;
    }

    public ButtonElement setActivated(boolean activated) {
        this.activated = activated;
        return this;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public int getStartX() {
        return this.startX;
    }

    public int getStartY() {
        return this.startY;
    }

    public int getBlitOffset() {
        return this.blitOffset;
    }

    public ResourceLocation getResourceLocation() {
        return this.resourceLocation;
    }

    public static interface IPressable {
        public void onPress(ButtonElement var1);
    }
}

