/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.event;

import com.stal111.forbidden_arcanus.ForbiddenArcanus;
import com.stal111.forbidden_arcanus.config.WorldGenConfig;
import com.stal111.forbidden_arcanus.init.world.ModStructures;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.FlatChunkGenerator;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.settings.DimensionStructuresSettings;
import net.minecraft.world.gen.settings.StructureSeparationSettings;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.valhelsia.valhelsia_core.world.IValhelsiaStructure;

@Mod.EventBusSubscriber
public class WorldLoadListener {
    private static MethodHandle GETCODEC_METHOD = null;

    private static boolean getGetCodecMethod() {
        if (GETCODEC_METHOD == null) {
            Method codec = ObfuscationReflectionHelper.findMethod(ChunkGenerator.class, (String)"func_230347_a_", (Class[])new Class[0]);
            MethodHandles.Lookup l = MethodHandles.lookup();
            try {
                GETCODEC_METHOD = l.unreflect(codec);
            }
            catch (IllegalAccessException e) {
                ForbiddenArcanus.LOGGER.error("Unable to unreflect ChunkGenerator codec getter.", (Throwable)e);
                return false;
            }
        }
        return true;
    }

    @Nullable
    private static ResourceLocation getChunkGenerator(ServerWorld serverWorld) {
        ResourceLocation chunkGen;
        if (!WorldLoadListener.getGetCodecMethod()) {
            return null;
        }
        try {
            chunkGen = Registry.field_239690_aB_.func_177774_c((Object)GETCODEC_METHOD.invokeExact(serverWorld.func_72863_F().field_186029_c));
        }
        catch (Throwable throwable) {
            ForbiddenArcanus.LOGGER.error("Unable to look up " + serverWorld + "'s chunk provider's generator resource location.", throwable);
            return null;
        }
        return chunkGen;
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        if (event.getWorld() instanceof ServerWorld) {
            ServerWorld serverWorld = (ServerWorld)event.getWorld();
            if (serverWorld.func_72863_F().func_201711_g() instanceof FlatChunkGenerator && serverWorld.func_234923_W_().equals(World.field_234918_g_)) {
                return;
            }
            ResourceLocation chunkGen = WorldLoadListener.getChunkGenerator(serverWorld);
            if (chunkGen != null && chunkGen.func_110624_b().equals("terraforrged")) {
                return;
            }
            HashMap tempMap = new HashMap(serverWorld.func_72863_F().field_186029_c.func_235957_b_().func_236195_a_());
            WorldLoadListener.handleStructureBlocking(tempMap, (RegistryKey<World>)serverWorld.func_234923_W_(), (IValhelsiaStructure)ModStructures.NIPA.get(), WorldGenConfig.nipaList);
            serverWorld.func_72863_F().field_186029_c.func_235957_b_().field_236193_d_ = tempMap;
        }
    }

    private static void handleStructureBlocking(Map<Structure<?>, StructureSeparationSettings> modifiableTempMap, RegistryKey<World> dimension, IValhelsiaStructure struct, WorldGenConfig.DimensionList list) {
        if (list.allowed(dimension)) {
            modifiableTempMap.putIfAbsent(struct.getStructure(), (StructureSeparationSettings)DimensionStructuresSettings.field_236191_b_.get((Object)struct.getStructure()));
        } else {
            modifiableTempMap.remove(struct.getStructure());
        }
    }
}

