/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.tile.forge.ritual;

import com.stal111.forbidden_arcanus.block.tileentity.PedestalTileEntity;
import com.stal111.forbidden_arcanus.common.loader.RitualLoader;
import com.stal111.forbidden_arcanus.common.tile.forge.HephaestusForgeTileEntity;
import com.stal111.forbidden_arcanus.common.tile.forge.ritual.Ritual;
import com.stal111.forbidden_arcanus.entity.CrimsonLightningBoltEntity;
import com.stal111.forbidden_arcanus.init.ModEntities;
import com.stal111.forbidden_arcanus.init.ModParticles;
import com.stal111.forbidden_arcanus.init.other.ModPOITypes;
import com.stal111.forbidden_arcanus.item.IRitualStarterItem;
import com.stal111.forbidden_arcanus.network.NetworkHandler;
import com.stal111.forbidden_arcanus.network.UpdatePedestalPacket;
import com.stal111.forbidden_arcanus.network.UpdateRitualPacket;
import com.stal111.forbidden_arcanus.util.ISavedData;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class RitualManager
implements ISavedData {
    private final HephaestusForgeTileEntity tileEntity;
    private final List<BlockPos> cachedPedestals = new ArrayList<BlockPos>();
    private Ritual activeRitual;
    private int counter;
    private int lightningCounter;

    public RitualManager(HephaestusForgeTileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public HephaestusForgeTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public Ritual getActiveRitual() {
        return this.activeRitual;
    }

    public void setActiveRitual(Ritual ritual) {
        this.activeRitual = ritual;
    }

    public boolean isRitualActive() {
        return this.activeRitual != null;
    }

    public void tryStartRitual(ItemStack stack) {
        IRitualStarterItem ritualStarterItem = (IRitualStarterItem)stack.func_77973_b();
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (ritualStarterItem.getRemainingUses(stack) <= 0) {
            return;
        }
        this.forEachPedestal(PedestalTileEntity::hasStack, pedestalTileEntity -> list.add(pedestalTileEntity.getStack()), true);
        for (Ritual ritual : RitualLoader.getRituals()) {
            if (!ritual.canStart(list, this.tileEntity)) continue;
            ritualStarterItem.setRemainingUses(stack, ritualStarterItem.getRemainingUses(stack) - 1);
            this.startRitual(ritual);
            return;
        }
    }

    public void startRitual(Ritual ritual) {
        this.setActiveRitual(ritual);
        ritual.getEssences().reduceEssences(this.tileEntity);
    }

    public void tick() {
        ServerWorld world = this.getWorld();
        if (!this.isRitualActive()) {
            return;
        }
        BlockPos pos = this.getTileEntity().func_174877_v();
        Random random = world.func_201674_k();
        int time = this.getActiveRitual().getTime();
        ++this.counter;
        this.updateCachedPedestals();
        if (this.lightningCounter != 0) {
            ++this.lightningCounter;
            if (this.lightningCounter == 300) {
                ArrayList<ItemStack> list = new ArrayList<ItemStack>();
                this.forEachPedestal(PedestalTileEntity::hasStack, pedestalTileEntity -> list.add(pedestalTileEntity.getStack()));
                if (!this.getActiveRitual().checkIngredients(list, this.tileEntity)) {
                    this.failRitual(world);
                    NetworkHandler.sentToTrackingChunk(world.func_175726_f(pos), new UpdateRitualPacket(pos, this.activeRitual));
                    return;
                }
                this.lightningCounter = 0;
            }
        }
        this.forEachPedestal(PedestalTileEntity::hasStack, pedestalTileEntity -> {
            BlockPos pedestalPos = pedestalTileEntity.func_174877_v();
            if (pedestalTileEntity.getItemHeight() != 130) {
                int height = pedestalTileEntity.getItemHeight() + 1;
                pedestalTileEntity.setItemHeight(height);
                NetworkHandler.sentToTrackingChunk(world.func_175726_f(pedestalPos), new UpdatePedestalPacket(pedestalPos, pedestalTileEntity.getStack(), height));
            }
            this.addItemParticles(world, pedestalPos, pedestalTileEntity.getItemHeight(), pedestalTileEntity.getStack());
        });
        if ((float)this.counter == (float)time / 2.0f && random.nextDouble() <= this.getFailureChance() * 2.0) {
            CrimsonLightningBoltEntity entity = new CrimsonLightningBoltEntity((EntityType<? extends LightningBoltEntity>)((EntityType)ModEntities.CRIMSON_LIGHTNING_BOLT.get()), (World)world);
            entity.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.0, (double)pos.func_177952_p() + 0.5);
            entity.func_233623_a_(true);
            world.func_217376_c((Entity)entity);
            ++this.lightningCounter;
            this.forEachPedestal(PedestalTileEntity::hasStack, pedestalTileEntity -> {
                if (random.nextBoolean()) {
                    ItemStack stack = pedestalTileEntity.getStack().func_77946_l();
                    BlockPos pedestalPos = pedestalTileEntity.func_174877_v();
                    world.func_217376_c((Entity)new ItemEntity((World)world, (double)pedestalPos.func_177958_n() + 0.5, (double)((float)pedestalPos.func_177956_o() + (float)pedestalTileEntity.getItemHeight() / 100.0f), (double)pedestalPos.func_177952_p() + 0.5, stack));
                    pedestalTileEntity.clearStack();
                    NetworkHandler.sentToTrackingChunk(world.func_175726_f(pedestalPos), new UpdatePedestalPacket(pedestalPos, ItemStack.field_190927_a, 110));
                }
            });
        }
        if (this.counter == time) {
            if (random.nextDouble() > this.getFailureChance()) {
                this.finishRitual(world);
            } else {
                this.failRitual(world);
            }
        }
        NetworkHandler.sentToTrackingChunk(world.func_175726_f(pos), new UpdateRitualPacket(pos, this.activeRitual));
    }

    public void finishRitual(ServerWorld world) {
        this.tileEntity.func_70299_a(4, this.getActiveRitual().getResult());
        this.reset();
        this.forEachPedestal(PedestalTileEntity::hasStack, pedestalTileEntity -> {
            pedestalTileEntity.clearStack();
            NetworkHandler.sentToTrackingChunk(world.func_175726_f(this.tileEntity.func_174877_v()), new UpdatePedestalPacket(pedestalTileEntity.func_174877_v(), ItemStack.field_190927_a, 110));
        });
    }

    public void failRitual(ServerWorld world) {
        ItemStack stack = this.tileEntity.func_70301_a(4);
        BlockPos pos = this.tileEntity.func_174877_v();
        this.reset();
        if (!stack.func_190926_b()) {
            world.func_217376_c((Entity)new ItemEntity((World)world, (double)pos.func_177958_n() + 0.5, (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p() + 0.5, stack));
            this.tileEntity.func_70299_a(4, ItemStack.field_190927_a);
        }
        this.forEachPedestal(PedestalTileEntity::hasStack, pedestalTileEntity -> {
            pedestalTileEntity.clearStack();
            this.tileEntity.getEssenceManager().increaseCorruption(2);
            NetworkHandler.sentToTrackingChunk(world.func_175726_f(this.tileEntity.func_174877_v()), new UpdatePedestalPacket(pedestalTileEntity.func_174877_v(), ItemStack.field_190927_a, 110));
        });
        world.func_195598_a((IParticleData)ModParticles.HUGE_MAGIC_EXPLOSION.get(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0, 1.0, 0.0, 0.0, 0.0);
        world.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, (1.0f + (world.func_201674_k().nextFloat() - world.func_201674_k().nextFloat()) * 0.2f) * 0.7f);
    }

    private void addItemParticles(ServerWorld world, BlockPos pedestalPos, int itemHeight, ItemStack stack) {
        BlockPos pos = this.tileEntity.func_174877_v();
        double posX = (double)pedestalPos.func_177958_n() + 0.5;
        double posY = (double)pedestalPos.func_177956_o() + 0.1 + (double)((float)itemHeight / 100.0f);
        double posZ = (double)pedestalPos.func_177952_p() + 0.5;
        double xSpeed = 0.1 * (double)(pos.func_177958_n() - pedestalPos.func_177958_n());
        double ySpeed = 0.22;
        double zSpeed = 0.1 * (double)(pos.func_177952_p() - pedestalPos.func_177952_p());
        if (world.func_201674_k().nextDouble() < 0.6) {
            world.func_195598_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, stack), posX, posY, posZ, 0, xSpeed, ySpeed, zSpeed, 0.9);
        }
    }

    private void reset() {
        this.counter = 0;
        this.lightningCounter = 0;
        this.setActiveRitual(null);
    }

    public ServerWorld getWorld() {
        return (ServerWorld)this.tileEntity.func_145831_w();
    }

    public double getFailureChance() {
        return (float)(this.getTileEntity().getEssenceManager().getCorruption() + 5) / (float)this.getTileEntity().getLevel().getMaxCorruption() / 2.0f;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        if (this.isRitualActive()) {
            compound.func_74778_a("ActiveRitual", this.getActiveRitual().getName().toString());
            compound.func_74768_a("Counter", this.counter);
            if (this.lightningCounter != 0) {
                compound.func_74768_a("LightningCounter", this.lightningCounter);
            }
        }
        return compound;
    }

    @Override
    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("ActiveRitual")) {
            this.setActiveRitual(RitualLoader.getRitual(new ResourceLocation(compound.func_74779_i("ActiveRitual"))));
            this.counter = compound.func_74762_e("Counter");
            if (this.counter != 0) {
                this.tileEntity.getMagicCircle().setRotation(this.counter);
            }
            if (compound.func_74764_b("LightningCounter")) {
                this.lightningCounter = compound.func_74762_e("LightningCounter");
            }
        }
    }

    public void updateCachedPedestals() {
        PointOfInterestManager manager = this.getWorld().func_217443_B();
        this.cachedPedestals.clear();
        manager.func_219146_b(poiType -> poiType == ModPOITypes.PEDESTAL.get(), this.tileEntity.func_174877_v(), 4, PointOfInterestManager.Status.ANY).forEach(pointOfInterest -> this.cachedPedestals.add(pointOfInterest.func_218261_f()));
    }

    public void forEachPedestal(Predicate<PedestalTileEntity> predicate, Consumer<PedestalTileEntity> consumer) {
        this.forEachPedestal(predicate, consumer, false);
    }

    public void forEachPedestal(Predicate<PedestalTileEntity> predicate, Consumer<PedestalTileEntity> consumer, boolean updatePedestals) {
        if (updatePedestals) {
            this.updateCachedPedestals();
        }
        this.cachedPedestals.stream().map(pos -> (PedestalTileEntity)this.getWorld().func_175625_s(pos)).filter(predicate).forEach(consumer);
    }
}

