/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.common.tile.forge.ritual;

import com.stal111.forbidden_arcanus.common.tile.forge.HephaestusForgeLevel;
import com.stal111.forbidden_arcanus.common.tile.forge.HephaestusForgeTileEntity;
import com.stal111.forbidden_arcanus.util.ISavedData;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;

public class EssenceManager
implements ISavedData,
ITickableTileEntity {
    private final HephaestusForgeTileEntity tileEntity;
    private int aureal = 0;
    private int corruption = 0;
    private int souls = 0;
    private int blood = 0;
    private int experience = 0;
    private final Map<LivingEntity, Float> cachedHealth = new HashMap<LivingEntity, Float>();

    public EssenceManager(HephaestusForgeTileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    public HephaestusForgeTileEntity getTileEntity() {
        return this.tileEntity;
    }

    public HephaestusForgeLevel getLevel() {
        return this.getTileEntity().getLevel();
    }

    public int getAureal() {
        return this.aureal;
    }

    public void setAureal(int aureal) {
        this.aureal = aureal;
    }

    public void increaseAureal(int aureal) {
        if (this.getAureal() + aureal >= this.getLevel().getMaxAureal()) {
            this.setAureal(this.getLevel().getMaxAureal());
            return;
        }
        this.setAureal(this.getAureal() + aureal);
    }

    public void decreaseAureal(int aureal) {
        this.setAureal(Math.max(this.getAureal() - aureal, 0));
    }

    public int getCorruption() {
        return this.corruption;
    }

    public void setCorruption(int corruption) {
        this.corruption = corruption;
    }

    public void increaseCorruption(int corruption) {
        if (this.getCorruption() + corruption >= this.getLevel().getMaxCorruption()) {
            this.setCorruption(this.getLevel().getMaxCorruption());
            return;
        }
        this.setCorruption(this.getCorruption() + corruption);
    }

    public void decreaseCorruption(int corruption) {
        this.setCorruption(Math.max(this.getCorruption() - corruption, 0));
    }

    public int getSouls() {
        return this.souls;
    }

    public void setSouls(int souls) {
        this.souls = souls;
    }

    public void increaseSouls(int souls) {
        if (this.getSouls() + souls >= this.getLevel().getMaxSouls()) {
            this.setSouls(this.getLevel().getMaxSouls());
            return;
        }
        this.setSouls(this.getSouls() + souls);
    }

    public void decreaseSouls(int souls) {
        this.setSouls(Math.max(this.getSouls() - souls, 0));
    }

    public int getBlood() {
        return this.blood;
    }

    public void setBlood(int blood) {
        this.blood = blood;
    }

    public void increaseBlood(int blood) {
        if (this.getBlood() + blood >= this.getLevel().getMaxBlood()) {
            this.setBlood(this.getLevel().getMaxBlood());
            return;
        }
        this.setBlood(this.getBlood() + blood);
    }

    public void decreaseBlood(int blood) {
        this.setBlood(Math.max(this.getBlood() - blood, 0));
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = experience;
    }

    public void increaseExperience(int experience) {
        if (this.getExperience() + experience >= this.getLevel().getMaxExperience()) {
            this.setExperience(this.getLevel().getMaxExperience());
            return;
        }
        this.setExperience(this.getExperience() + experience);
    }

    public void decreaseExperience(int experience) {
        this.setExperience(Math.max(this.getExperience() - experience, 0));
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("Aureal", this.getAureal());
        compound.func_74768_a("Corruption", this.getCorruption());
        compound.func_74768_a("Souls", this.getSouls());
        compound.func_74768_a("Blood", this.getBlood());
        compound.func_74768_a("Experience", this.getExperience());
        return compound;
    }

    @Override
    public void read(CompoundNBT compound) {
        this.setAureal(compound.func_74762_e("Aureal"));
        this.setCorruption(compound.func_74762_e("Corruption"));
        this.setSouls(compound.func_74762_e("Souls"));
        this.setBlood(compound.func_74762_e("Blood"));
        this.setExperience(compound.func_74762_e("Experience"));
    }

    public void func_73660_a() {
        HephaestusForgeTileEntity tileEntity = this.getTileEntity();
        if (tileEntity.func_145831_w() == null) {
            return;
        }
        for (LivingEntity entity : tileEntity.getEntities()) {
            float healthDifference;
            if (!this.cachedHealth.containsKey(entity) || !((healthDifference = this.cachedHealth.get(entity).floatValue() - entity.func_110143_aJ()) > 0.0f)) continue;
            this.increaseBlood((int)healthDifference * 20);
        }
        this.cachedHealth.clear();
        for (LivingEntity entity : tileEntity.getEntities()) {
            this.cachedHealth.put(entity, Float.valueOf(entity.func_110143_aJ()));
        }
    }
}

