/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block.tileentity;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stal111.forbidden_arcanus.block.tileentity.container.DarkBeaconContainer;
import com.stal111.forbidden_arcanus.init.ModTileEntities;
import com.stal111.forbidden_arcanus.util.GuiTile;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.LockCode;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class DarkBeaconTileEntity
extends TileEntity
implements INamedContainerProvider,
ITickableTileEntity,
GuiTile {
    public static final Effect[][] EFFECTS_LIST = new Effect[][]{{Effects.field_76424_c, Effects.field_76422_e}, {Effects.field_76429_m, Effects.field_76430_j}, {Effects.field_76420_g}, {Effects.field_76428_l}};
    private static final Set<Effect> VALID_EFFECTS = Arrays.stream(EFFECTS_LIST).flatMap(Arrays::stream).collect(Collectors.toSet());
    private List<BeamSegment> beamSegments = Lists.newArrayList();
    private List<BeamSegment> field_213934_g = Lists.newArrayList();
    private int levels = 0;
    private int field_213935_i = -1;
    @Nullable
    private Effect primaryEffect;
    @Nullable
    private Effect secondaryEffect;
    @Nullable
    private ITextComponent customName;
    private LockCode field_213936_m = LockCode.field_180162_a;
    private final IIntArray field_213937_n = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return DarkBeaconTileEntity.this.levels;
                }
                case 1: {
                    return Effect.func_188409_a((Effect)DarkBeaconTileEntity.this.primaryEffect);
                }
                case 2: {
                    return Effect.func_188409_a((Effect)DarkBeaconTileEntity.this.secondaryEffect);
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    DarkBeaconTileEntity.this.levels = value;
                    break;
                }
                case 1: {
                    if (!((DarkBeaconTileEntity)DarkBeaconTileEntity.this).field_145850_b.field_72995_K && !DarkBeaconTileEntity.this.beamSegments.isEmpty()) {
                        DarkBeaconTileEntity.this.playSound(SoundEvents.field_206941_N);
                    }
                    DarkBeaconTileEntity.this.primaryEffect = DarkBeaconTileEntity.isBeaconEffect(value);
                    break;
                }
                case 2: {
                    DarkBeaconTileEntity.this.secondaryEffect = DarkBeaconTileEntity.isBeaconEffect(value);
                }
            }
        }

        public int func_221478_a() {
            return 3;
        }
    };

    public DarkBeaconTileEntity() {
        super((TileEntityType)ModTileEntities.SIGN.get());
    }

    public void func_145843_s() {
        this.playSound(SoundEvents.field_206940_M);
        super.func_145843_s();
    }

    private void addEffectsToPlayers() {
        if (!this.field_145850_b.field_72995_K && this.primaryEffect != null) {
            double d0 = this.levels * 10 + 10;
            int i = 0;
            if (this.levels >= 4 && this.primaryEffect == this.secondaryEffect) {
                i = 1;
            }
            int j = (9 + this.levels * 2) * 20;
            AxisAlignedBB axisalignedbb = new AxisAlignedBB(this.field_174879_c).func_186662_g(d0).func_72321_a(0.0, (double)this.field_145850_b.func_217301_I(), 0.0);
            List list = this.field_145850_b.func_217357_a(PlayerEntity.class, axisalignedbb);
            for (PlayerEntity playerentity : list) {
                playerentity.func_195064_c(new EffectInstance(this.primaryEffect, j, i, true, true));
            }
            if (this.levels >= 4 && this.primaryEffect != this.secondaryEffect && this.secondaryEffect != null) {
                for (PlayerEntity playerentity1 : list) {
                    playerentity1.func_195064_c(new EffectInstance(this.secondaryEffect, j, 0, true, true));
                }
            }
        }
    }

    public void playSound(SoundEvent p_205736_1_) {
        this.field_145850_b.func_184133_a(null, this.field_174879_c, p_205736_1_, SoundCategory.BLOCKS, 1.0f, 1.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.levels == 0 ? ImmutableList.of() : this.beamSegments;
    }

    public int getLevels() {
        return this.levels;
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 3, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @OnlyIn(value=Dist.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Nullable
    private static Effect isBeaconEffect(int p_184279_0_) {
        Effect effect = Effect.func_188412_a((int)p_184279_0_);
        return VALID_EFFECTS.contains(effect) ? effect : null;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.primaryEffect = DarkBeaconTileEntity.isBeaconEffect(compound.func_74762_e("Primary"));
        this.secondaryEffect = DarkBeaconTileEntity.isBeaconEffect(compound.func_74762_e("Secondary"));
        this.field_213936_m = LockCode.func_180158_b((CompoundNBT)compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Primary", Effect.func_188409_a((Effect)this.primaryEffect));
        compound.func_74768_a("Secondary", Effect.func_188409_a((Effect)this.secondaryEffect));
        compound.func_74768_a("Levels", this.levels);
        if (this.customName != null) {
            compound.func_74778_a("CustomName", ITextComponent.Serializer.func_150696_a((ITextComponent)this.customName));
        }
        this.field_213936_m.func_180157_a(compound);
        return compound;
    }

    public void setCustomName(@Nullable ITextComponent aname) {
        this.customName = aname;
    }

    @Nullable
    public Container createMenu(int i, PlayerInventory inventory, PlayerEntity player) {
        return new DarkBeaconContainer(i, this.field_145850_b, this.field_174879_c, inventory, player);
    }

    public ITextComponent func_145748_c_() {
        return this.customName != null ? this.customName : new TranslationTextComponent("container.dark_beacon");
    }

    public void func_73660_a() {
    }

    public static class BeamSegment {
        private final float[] colors;
        private int height;

        public BeamSegment(float[] colorsIn) {
            this.colors = colorsIn;
            this.height = 1;
        }

        protected void incrementHeight() {
            ++this.height;
        }

        @OnlyIn(value=Dist.CLIENT)
        public float[] getColors() {
            return this.colors;
        }

        @OnlyIn(value=Dist.CLIENT)
        public int getHeight() {
            return this.height;
        }
    }
}

