/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.block;

import com.google.common.collect.ImmutableMap;
import com.stal111.forbidden_arcanus.block.CutoutBlock;
import com.stal111.forbidden_arcanus.block.properties.ArcaneCrystalObeliskPart;
import com.stal111.forbidden_arcanus.block.properties.ModBlockStateProperties;
import com.stal111.forbidden_arcanus.common.tile.ArcaneCrystalObeliskTileEntity;
import com.stal111.forbidden_arcanus.init.ModParticles;
import com.stal111.forbidden_arcanus.init.NewModBlocks;
import com.stal111.forbidden_arcanus.init.NewModItems;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.particles.IParticleData;
import net.minecraft.pathfinding.PathType;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.valhelsia.valhelsia_core.helper.VoxelShapeHelper;

public class ArcaneCrystalObeliskBlock
extends CutoutBlock
implements IWaterLoggable {
    public static final EnumProperty<ArcaneCrystalObeliskPart> PART = EnumProperty.func_177709_a((String)"part", ArcaneCrystalObeliskPart.class);
    public static final BooleanProperty RITUAL = ModBlockStateProperties.RITUAL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.field_208198_y;
    private static final Map<ArcaneCrystalObeliskPart, VoxelShape> SHAPES = ImmutableMap.builder().put((Object)ArcaneCrystalObeliskPart.LOWER, (Object)VoxelShapeHelper.combineAll((VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), Block.func_208617_a((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0)})).put((Object)ArcaneCrystalObeliskPart.MIDDLE, (Object)Block.func_208617_a((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0)).put((Object)ArcaneCrystalObeliskPart.UPPER, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)14.0, (double)13.0)).build();

    public ArcaneCrystalObeliskBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(PART, (Comparable)((Object)ArcaneCrystalObeliskPart.LOWER))).func_206870_a((Property)RITUAL, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean hasTileEntity(BlockState state) {
        return (Boolean)state.func_177229_b((Property)RITUAL);
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ArcaneCrystalObeliskTileEntity();
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPES.get(state.func_177229_b(PART));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos = context.func_195995_a();
        World world = context.func_195991_k();
        if (pos.func_177956_o() > world.func_217301_I() - 3 || !world.func_180495_p(pos.func_177984_a()).func_196953_a(context) || !world.func_180495_p(pos.func_177981_b(2)).func_196953_a(context)) {
            return null;
        }
        return (BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)RITUAL, (Comparable)Boolean.valueOf(world.func_180495_p(pos.func_177977_b()).func_177230_c() == NewModBlocks.ARCANE_CHISELED_POLISHED_DARKSTONE.get()))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos).func_206886_c() == Fluids.field_204546_a));
    }

    @Nonnull
    public BlockState func_196271_a(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull IWorld world, @Nonnull BlockPos pos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((Property)WATERLOGGED)).booleanValue()) {
            world.func_205219_F_().func_205360_a(pos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        ArcaneCrystalObeliskPart part = (ArcaneCrystalObeliskPart)((Object)state.func_177229_b(PART));
        if (facing.func_176740_k() == Direction.Axis.Y && (part == ArcaneCrystalObeliskPart.LOWER == (facing == Direction.UP) || part == ArcaneCrystalObeliskPart.MIDDLE)) {
            return facingState.func_177230_c() == this && facingState.func_177229_b(PART) != part ? state : Blocks.field_150350_a.func_176223_P();
        }
        if (part == ArcaneCrystalObeliskPart.LOWER && facing == Direction.DOWN && !state.func_196955_c((IWorldReader)world, pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return super.func_196271_a(state, facing, facingState, world, pos, facingPos);
    }

    public void func_220069_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Block block, @Nonnull BlockPos fromPos, boolean isMoving) {
        super.func_220069_a(state, world, pos, block, fromPos, isMoving);
        if (!fromPos.equals((Object)pos.func_177977_b())) {
            return;
        }
        BlockState newState = (BlockState)state.func_206870_a((Property)RITUAL, (Comparable)Boolean.valueOf(world.func_180495_p(fromPos).func_177230_c() == NewModBlocks.ARCANE_CHISELED_POLISHED_DARKSTONE.get()));
        if (state != newState) {
            world.func_180501_a(pos, newState, 3);
        }
    }

    public void func_176208_a(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull PlayerEntity player) {
        ArcaneCrystalObeliskPart part;
        if (!world.func_201670_d() && player.field_71075_bZ.field_75098_d && (part = (ArcaneCrystalObeliskPart)((Object)state.func_177229_b(PART))) != ArcaneCrystalObeliskPart.LOWER) {
            BlockPos offsetPos = pos.func_177979_c(part == ArcaneCrystalObeliskPart.MIDDLE ? 1 : 2);
            world.func_180501_a(offsetPos, Blocks.field_150350_a.func_176223_P(), 35);
            world.func_217378_a(player, 2001, offsetPos, Block.func_196246_j((BlockState)world.func_180495_p(offsetPos)));
        }
        super.func_176208_a(world, pos, state, player);
    }

    public void func_180633_a(World world, BlockPos pos, BlockState state, @Nullable LivingEntity entity, @Nonnull ItemStack stack) {
        world.func_180501_a(pos.func_177984_a(), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)ArcaneCrystalObeliskPart.MIDDLE))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177984_a()).func_206886_c() == Fluids.field_204546_a)), 3);
        world.func_180501_a(pos.func_177981_b(2), (BlockState)((BlockState)state.func_206870_a(PART, (Comparable)((Object)ArcaneCrystalObeliskPart.UPPER))).func_206870_a((Property)WATERLOGGED, (Comparable)Boolean.valueOf(world.func_204610_c(pos.func_177981_b(2)).func_206886_c() == Fluids.field_204546_a)), 3);
    }

    public boolean func_196260_a(@Nonnull BlockState state, @Nonnull IWorldReader world, @Nonnull BlockPos pos) {
        ArcaneCrystalObeliskPart part = (ArcaneCrystalObeliskPart)((Object)state.func_177229_b(PART));
        BlockPos posDown = pos.func_177977_b();
        if (part == ArcaneCrystalObeliskPart.LOWER) {
            return world.func_180495_p(posDown).func_224755_d((IBlockReader)world, posDown, Direction.UP);
        }
        return true;
    }

    @Nonnull
    public PushReaction func_149656_h(@Nonnull BlockState state) {
        return PushReaction.BLOCK;
    }

    public void func_180655_c(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull Random rand) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            if (!Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70431_c(NewModItems.Stacks.LENS_OF_VERITATIS) || state.func_177229_b(PART) == ArcaneCrystalObeliskPart.LOWER) {
                return;
            }
            double j = 0.6 * (double)rand.nextFloat();
            double k = 0.6 * (double)rand.nextFloat();
            double posX = (double)pos.func_177958_n() + 0.5 + (rand.nextBoolean() ? j : -j);
            double posY = (double)pos.func_177956_o() + 0.1 + (double)(rand.nextFloat() / 2.0f);
            double posZ = (double)pos.func_177952_p() + 0.5 + (rand.nextBoolean() ? k : -k);
            double ySpeed = ((double)rand.nextFloat() - 0.4) * 0.1;
            world.func_195594_a((IParticleData)ModParticles.AUREAL_MOTE.get(), posX, posY, posZ, 0.0, ySpeed, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{PART, RITUAL, WATERLOGGED});
    }

    public boolean func_196266_a(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull PathType type) {
        return false;
    }

    @Nonnull
    public FluidState func_204507_t(BlockState state) {
        return (Boolean)state.func_177229_b((Property)WATERLOGGED) != false ? Fluids.field_204546_a.func_207204_a(false) : super.func_204507_t(state);
    }
}

