/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.aureal.consequence;

import com.stal111.forbidden_arcanus.aureal.capability.AurealProvider;
import com.stal111.forbidden_arcanus.aureal.consequence.Consequences;
import com.stal111.forbidden_arcanus.aureal.consequence.IConsequence;
import com.stal111.forbidden_arcanus.aureal.consequence.IConsequenceType;
import com.stal111.forbidden_arcanus.util.AurealHelper;
import com.stal111.forbidden_arcanus.util.ISavedData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;

public class SoundConsequence
implements IConsequence,
ISavedData {
    private final List<SoundEvent> sounds = new ArrayList<SoundEvent>();
    public int ticksUntilNextSound;
    private int timer;

    public SoundConsequence() {
        this(20, 0);
        this.loadSounds();
    }

    public SoundConsequence(int ticksUntilNextSound, int timer) {
        this.ticksUntilNextSound = ticksUntilNextSound;
        this.timer = timer;
        this.loadSounds();
    }

    private void loadSounds() {
        this.sounds.addAll(Arrays.asList(SoundEvents.field_187835_fT, SoundEvents.field_187572_ar, SoundEvents.field_187559_bL));
    }

    @Override
    public ResourceLocation getName() {
        return new ResourceLocation("forbidden_arcanus", "sound");
    }

    @Override
    public void tick(PlayerEntity player) {
        if (!player.func_130014_f_().func_201670_d()) {
            if (this.ticksUntilNextSound <= 0) {
                player.func_213823_a(this.sounds.get(player.func_70681_au().nextInt(this.sounds.size())), SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.ticksUntilNextSound = Math.max(player.func_70681_au().nextInt(450), 100);
            } else {
                --this.ticksUntilNextSound;
            }
            ++this.timer;
            if (this.timer >= 1800) {
                player.getCapability(AurealProvider.CAPABILITY).ifPresent(aureal -> aureal.removeActiveConsequence(this));
            }
            AurealHelper.sendAurealUpdatePacket(player);
        }
    }

    @Override
    public IConsequenceType getType() {
        return Consequences.SOUND;
    }

    @Override
    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("ticksUntilNextSound", this.ticksUntilNextSound);
        compound.func_74768_a("timer", this.timer);
        return compound;
    }

    @Override
    public void read(CompoundNBT compound) {
        this.ticksUntilNextSound = compound.func_74762_e("ticksUntilNextSound");
        this.timer = compound.func_74762_e("timer");
    }

    public static class Type
    implements IConsequenceType {
        @Override
        public ResourceLocation getName() {
            return new ResourceLocation("forbidden_arcanus", "sound");
        }

        @Override
        public IConsequence createConsequence() {
            return new SoundConsequence();
        }
    }
}

