/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.forbidden_arcanus.aureal.consequence;

import com.stal111.forbidden_arcanus.aureal.consequence.ChangeWeatherConsequence;
import com.stal111.forbidden_arcanus.aureal.consequence.EffectConsequence;
import com.stal111.forbidden_arcanus.aureal.consequence.IConsequenceType;
import com.stal111.forbidden_arcanus.aureal.consequence.SoundConsequence;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.ResourceLocation;

public class Consequences {
    private static final List<IConsequenceType> CONSEQUENCES = new ArrayList<IConsequenceType>();
    public static final ChangeWeatherConsequence.Type CHANGE_WEATHER = new ChangeWeatherConsequence.Type();
    public static final EffectConsequence.Type EFFECT = new EffectConsequence.Type();
    public static final SoundConsequence.Type SOUND = new SoundConsequence.Type();

    public static void registerConsequences() {
        Consequences.register(CHANGE_WEATHER);
        Consequences.register(EFFECT);
        Consequences.register(SOUND);
    }

    private static void register(IConsequenceType consequence) {
        CONSEQUENCES.add(consequence);
    }

    public static List<IConsequenceType> getConsequences() {
        return CONSEQUENCES;
    }

    public static IConsequenceType getRandomConsequence(Random random) {
        return Consequences.getConsequences().get(random.nextInt(Consequences.getConsequences().size()));
    }

    public static IConsequenceType getByName(ResourceLocation name) {
        for (IConsequenceType consequence : Consequences.getConsequences()) {
            if (!consequence.getName().equals((Object)name)) continue;
            return consequence;
        }
        return null;
    }
}

