/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.network.packets.particle.totem;

import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.network.PacketEffects;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.network.NetworkEvent;

public class TotemParticlePacket {
    ArrayList<String> spirits;
    int posX;
    int posY;
    int posZ;
    boolean success;

    public static TotemParticlePacket fromSpirits(ArrayList<MalumSpiritType> spiritIngredients, BlockPos pos, boolean success) {
        ArrayList<String> spirits = new ArrayList<String>();
        for (MalumSpiritType type : spiritIngredients) {
            spirits.add(type.identifier);
        }
        return new TotemParticlePacket(spirits, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), success);
    }

    public TotemParticlePacket(ArrayList<String> spirits, int posX, int posY, int posZ, boolean success) {
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.success = success;
    }

    public static TotemParticlePacket decode(PacketBuffer buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.func_218666_n());
        }
        int posX = buf.readInt();
        int posY = buf.readInt();
        int posZ = buf.readInt();
        boolean sparkles = buf.readBoolean();
        return new TotemParticlePacket(spirits, posX, posY, posZ, sparkles);
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.func_180714_a(string);
        }
        buf.writeInt(this.posX);
        buf.writeInt(this.posY);
        buf.writeInt(this.posZ);
        buf.writeBoolean(this.success);
    }

    public void whenThisPacketIsReceived(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketEffects.totemParticles(this.spirits, new BlockPos(this.posX, this.posY, this.posZ), this.success));
        context.get().setPacketHandled(true);
    }
}

