/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.network.packets.particle.altar;

import com.sammy.malum.core.systems.recipes.SpiritIngredient;
import com.sammy.malum.network.PacketEffects;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpiritAltarCraftParticlePacket {
    ArrayList<String> spirits;
    double posX;
    double posY;
    double posZ;

    public static SpiritAltarCraftParticlePacket fromIngredients(ArrayList<SpiritIngredient> spiritIngredients, double posX, double posY, double posZ) {
        ArrayList<String> spirits = new ArrayList<String>();
        for (SpiritIngredient ingredient : spiritIngredients) {
            spirits.add(ingredient.type.identifier);
        }
        return new SpiritAltarCraftParticlePacket(spirits, posX, posY, posZ);
    }

    public SpiritAltarCraftParticlePacket(ArrayList<String> spirits, double posX, double posY, double posZ) {
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static SpiritAltarCraftParticlePacket decode(PacketBuffer buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.func_218666_n());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return new SpiritAltarCraftParticlePacket(spirits, posX, posY, posZ);
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.func_180714_a(string);
        }
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void whenThisPacketIsReceived(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketEffects.altarCraftParticles(this.spirits, this.posX, this.posY, this.posZ));
        context.get().setPacketHandled(true);
    }
}

