/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.network.packets.particle;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.core.systems.spirits.MalumSpiritType;
import com.sammy.malum.network.PacketEffects;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.fml.network.NetworkEvent;

public class BurstParticlePacket {
    ArrayList<String> spirits;
    double posX;
    double posY;
    double posZ;

    public static BurstParticlePacket fromSpirits(double posX, double posY, double posZ, MalumSpiritType ... spirits) {
        return BurstParticlePacket.fromSpirits(posX, posY, posZ, MalumHelper.toArrayList(spirits));
    }

    public static BurstParticlePacket fromSpirits(double posX, double posY, double posZ, ArrayList<MalumSpiritType> spirits) {
        ArrayList<String> strings = new ArrayList<String>();
        for (MalumSpiritType type : spirits) {
            strings.add(type.identifier);
        }
        return new BurstParticlePacket(strings, posX, posY, posZ);
    }

    public BurstParticlePacket(ArrayList<String> spirits, double posX, double posY, double posZ) {
        this.spirits = spirits;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
    }

    public static BurstParticlePacket decode(PacketBuffer buf) {
        int strings = buf.readInt();
        ArrayList<String> spirits = new ArrayList<String>();
        for (int i = 0; i < strings; ++i) {
            spirits.add(buf.func_218666_n());
        }
        double posX = buf.readDouble();
        double posY = buf.readDouble();
        double posZ = buf.readDouble();
        return new BurstParticlePacket(spirits, posX, posY, posZ);
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.spirits.size());
        for (String string : this.spirits) {
            buf.func_180714_a(string);
        }
        buf.writeDouble(this.posX);
        buf.writeDouble(this.posY);
        buf.writeDouble(this.posZ);
    }

    public void whenThisPacketIsReceived(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> PacketEffects.burstParticles(this.spirits, new Vector3d(this.posX, this.posY, this.posZ)));
        context.get().setPacketHandled(true);
    }
}

