/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.worldgen;

import com.sammy.malum.MalumHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.World;

public class MalumFiller {
    public ArrayList<BlockStateEntry> entries = new ArrayList();

    public void fill(ISeedReader reader, boolean safetyCheck) {
        for (BlockStateEntry entry : this.entries) {
            if (safetyCheck && !entry.canPlace(reader)) continue;
            reader.func_180501_a(entry.pos, entry.state, 3);
            entry.additionalPlacement(reader);
            if (!(reader instanceof World)) continue;
            MalumHelper.updateState((World)reader, entry.pos);
        }
    }

    public static class BlockStateEntry {
        public final BlockState state;
        public final BlockPos pos;

        public BlockStateEntry(BlockState state, BlockPos pos) {
            this.state = state;
            this.pos = pos;
        }

        public boolean canPlace(ISeedReader reader) {
            return this.canPlace(reader, this.pos);
        }

        public boolean canPlace(ISeedReader reader, BlockPos pos) {
            if (World.func_189509_E((BlockPos)pos)) {
                return false;
            }
            BlockState state = reader.func_180495_p(pos);
            return reader.func_175623_d(pos) || state.func_185904_a().func_76222_j();
        }

        public boolean canPlace(ISeedReader reader, BlockPos pos, Block block) {
            if (World.func_189509_E((BlockPos)pos)) {
                return false;
            }
            BlockState state = reader.func_180495_p(pos);
            return state.func_177230_c().equals(block) || reader.func_175623_d(pos) || state.func_185904_a().func_76222_j();
        }

        public void additionalPlacement(ISeedReader reader) {
        }
    }
}

