/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.particles.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.awt.Color;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class MalumParticleData
implements IParticleData {
    public float r1 = 1.0f;
    public float g1 = 1.0f;
    public float b1 = 1.0f;
    public float a1 = 1.0f;
    public float r2 = 1.0f;
    public float g2 = 1.0f;
    public float b2 = 1.0f;
    public float a2 = 0.0f;
    public float scale1 = 1.0f;
    public float scale2 = 0.0f;
    public int lifetime = 20;
    public float spin = 0.0f;
    public boolean gravity = false;
    public boolean noClip = false;
    ParticleType<?> type;
    public static final IParticleData.IDeserializer<MalumParticleData> DESERIALIZER = new IParticleData.IDeserializer<MalumParticleData>(){

        public MalumParticleData deserialize(ParticleType<MalumParticleData> type, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            float r1 = reader.readFloat();
            reader.expect(' ');
            float g1 = reader.readFloat();
            reader.expect(' ');
            float b1 = reader.readFloat();
            reader.expect(' ');
            float a1 = reader.readFloat();
            reader.expect(' ');
            float r2 = reader.readFloat();
            reader.expect(' ');
            float g2 = reader.readFloat();
            reader.expect(' ');
            float b2 = reader.readFloat();
            reader.expect(' ');
            float a2 = reader.readFloat();
            reader.expect(' ');
            float scale1 = reader.readFloat();
            reader.expect(' ');
            float scale2 = reader.readFloat();
            reader.expect(' ');
            int lifetime = reader.readInt();
            reader.expect(' ');
            float spin = reader.readFloat();
            reader.expect(' ');
            boolean gravity = reader.readBoolean();
            reader.expect(' ');
            boolean noClip = reader.readBoolean();
            MalumParticleData data = new MalumParticleData(type);
            data.r1 = r1;
            data.g1 = g1;
            data.b1 = b1;
            data.a1 = a1;
            data.r2 = r2;
            data.g2 = g2;
            data.b2 = b2;
            data.a2 = a2;
            data.scale1 = scale1;
            data.scale2 = scale2;
            data.lifetime = lifetime;
            data.spin = spin;
            data.gravity = gravity;
            data.noClip = noClip;
            return data;
        }

        public MalumParticleData read(ParticleType<MalumParticleData> type, PacketBuffer buf) {
            float r1 = buf.readFloat();
            float g1 = buf.readFloat();
            float b1 = buf.readFloat();
            float a1 = buf.readFloat();
            float r2 = buf.readFloat();
            float g2 = buf.readFloat();
            float b2 = buf.readFloat();
            float a2 = buf.readFloat();
            float scale1 = buf.readFloat();
            float scale2 = buf.readFloat();
            int lifetime = buf.readInt();
            float spin = buf.readFloat();
            boolean gravity = buf.readBoolean();
            boolean noClip = buf.readBoolean();
            MalumParticleData data = new MalumParticleData(type);
            data.r1 = r1;
            data.g1 = g1;
            data.b1 = b1;
            data.a1 = a1;
            data.r2 = r2;
            data.g2 = g2;
            data.b2 = b2;
            data.a2 = a2;
            data.scale1 = scale1;
            data.scale2 = scale2;
            data.lifetime = lifetime;
            data.spin = spin;
            data.gravity = gravity;
            data.noClip = noClip;
            return data;
        }
    };

    public static Codec<MalumParticleData> codecFor(ParticleType<?> type) {
        return RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("r1").forGetter(d -> Float.valueOf(d.r1)), (App)Codec.FLOAT.fieldOf("g1").forGetter(d -> Float.valueOf(d.g1)), (App)Codec.FLOAT.fieldOf("b1").forGetter(d -> Float.valueOf(d.b1)), (App)Codec.FLOAT.fieldOf("a1").forGetter(d -> Float.valueOf(d.a1)), (App)Codec.FLOAT.fieldOf("r2").forGetter(d -> Float.valueOf(d.r2)), (App)Codec.FLOAT.fieldOf("g2").forGetter(d -> Float.valueOf(d.g2)), (App)Codec.FLOAT.fieldOf("b2").forGetter(d -> Float.valueOf(d.b2)), (App)Codec.FLOAT.fieldOf("a2").forGetter(d -> Float.valueOf(d.a2)), (App)Codec.FLOAT.fieldOf("scale1").forGetter(d -> Float.valueOf(d.scale1)), (App)Codec.FLOAT.fieldOf("scale2").forGetter(d -> Float.valueOf(d.scale2)), (App)Codec.INT.fieldOf("lifetime").forGetter(d -> d.lifetime), (App)Codec.FLOAT.fieldOf("spin").forGetter(d -> Float.valueOf(d.spin)), (App)Codec.BOOL.fieldOf("gravity").forGetter(d -> d.gravity), (App)Codec.BOOL.fieldOf("noClip").forGetter(d -> d.noClip)).apply((Applicative)instance, (r1, g1, b1, a1, r2, g2, b2, a2, scale1, scale2, lifetime, spin, gravity, noClip) -> {
            MalumParticleData data = new MalumParticleData(type);
            data.r1 = r1.floatValue();
            data.g1 = g1.floatValue();
            data.b1 = b1.floatValue();
            data.a1 = a1.floatValue();
            data.r2 = r2.floatValue();
            data.g2 = g2.floatValue();
            data.b2 = b2.floatValue();
            data.a2 = a2.floatValue();
            data.scale1 = scale1.floatValue();
            data.scale2 = scale2.floatValue();
            data.lifetime = lifetime;
            data.spin = spin.floatValue();
            data.gravity = gravity;
            data.noClip = noClip;
            return data;
        }));
    }

    public MalumParticleData(ParticleType<?> type) {
        this.type = type;
    }

    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.r1).writeFloat(this.g1).writeFloat(this.b1).writeFloat(this.a1);
        buffer.writeFloat(this.r2).writeFloat(this.g2).writeFloat(this.b2).writeFloat(this.a2);
        buffer.writeFloat(this.scale1).writeFloat(this.scale2);
        buffer.writeInt(this.lifetime);
        buffer.writeFloat(this.spin);
        buffer.writeBoolean(this.gravity);
        buffer.writeBoolean(this.noClip);
    }

    public void setColor(float r1, float g1, float b1, float a1, float r2, float g2, float b2, float a2) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.a1 = a1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
        this.a2 = a2;
    }

    public void setColor(float r1, float g1, float b1, float r2, float g2, float b2) {
        this.r1 = r1;
        this.g1 = g1;
        this.b1 = b1;
        this.r2 = r2;
        this.g2 = g2;
        this.b2 = b2;
    }

    public void setColor(Color color1, Color color2) {
        this.r1 = (float)color1.getRed() / 255.0f;
        this.g1 = (float)color1.getBlue() / 255.0f;
        this.b1 = (float)color1.getBlue() / 255.0f;
        this.r2 = (float)color2.getRed() / 255.0f;
        this.g2 = (float)color2.getBlue() / 255.0f;
        this.b2 = (float)color2.getBlue() / 255.0f;
    }

    public String func_197555_a() {
        return this.getClass().getSimpleName() + ":internal";
    }
}

