/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.systems.inventory;

import com.sammy.malum.MalumHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Hand;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class SimpleInventory
extends ItemStackHandler {
    public int slotCount;
    public int slotSize;
    public Predicate<ItemStack> inputPredicate;
    public Predicate<ItemStack> outputPredicate;
    public final LazyOptional<IItemHandler> inventoryOptional = LazyOptional.of(() -> this);

    public SimpleInventory(int slotCount, int slotSize, Predicate<ItemStack> inputPredicate, Predicate<ItemStack> outputPredicate) {
        this(slotCount, slotSize, inputPredicate);
        this.outputPredicate = outputPredicate;
    }

    public SimpleInventory(int slotCount, int slotSize, Predicate<ItemStack> inputPredicate) {
        this(slotCount, slotSize);
        this.inputPredicate = inputPredicate;
    }

    public SimpleInventory(int slotCount, int slotSize) {
        super(slotCount);
        this.slotCount = slotCount;
        this.slotSize = slotSize;
    }

    public int firstEmptyItem() {
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int nonEmptyItems() {
        int itemCount = 0;
        for (int i = 0; i < this.slotCount; ++i) {
            ItemStack item = this.getStackInSlot(i);
            if (item.func_190926_b()) continue;
            ++itemCount;
        }
        return itemCount;
    }

    public void clearItems() {
        for (int i = 0; i < this.slotCount; ++i) {
            this.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public ArrayList<Item> items() {
        ArrayList<Item> items = new ArrayList<Item>();
        for (int i = 0; i < this.slotCount; ++i) {
            items.add(this.getStackInSlot(i).func_77973_b());
        }
        return items;
    }

    public ArrayList<ItemStack> stacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.slotCount; ++i) {
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    public ArrayList<ItemStack> nonEmptyStacks() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.slotCount; ++i) {
            if (this.getStackInSlot(i).func_190926_b()) continue;
            stacks.add(this.getStackInSlot(i));
        }
        return stacks;
    }

    public void dumpItems(World world, Vector3d pos) {
        for (int i = 0; i < this.slotCount; ++i) {
            if (!this.getStackInSlot(i).func_190926_b()) {
                world.func_217376_c((Entity)new ItemEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), this.getStackInSlot(i)));
            }
            this.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    public int getSlots() {
        return this.slotCount;
    }

    public int getSlotLimit(int slot) {
        return this.slotSize;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (this.inputPredicate != null && !this.inputPredicate.test(stack)) {
            return false;
        }
        return super.isItemValid(slot, stack);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.outputPredicate != null && !this.outputPredicate.test(super.extractItem(slot, amount, true))) {
            return ItemStack.field_190927_a;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public boolean playerHandleItem(World worldIn, PlayerEntity player, Hand handIn) {
        player.func_226292_a_(handIn, true);
        if (player.func_225608_bj_() || player.func_184586_b(handIn).func_190926_b()) {
            return this.playerExtractItem(worldIn, player);
        }
        return this.playerInsertItem(worldIn, player.func_184586_b(handIn));
    }

    public boolean playerExtractItem(World worldIn, PlayerEntity player) {
        if (MalumHelper.areWeOnServer(worldIn)) {
            List nonEmptyStacks = this.stacks.stream().filter(i -> !i.func_190926_b()).collect(Collectors.toList());
            if (nonEmptyStacks.isEmpty()) {
                return false;
            }
            ItemStack takeOutStack = (ItemStack)nonEmptyStacks.get(nonEmptyStacks.size() - 1);
            int slot = this.stacks.indexOf((Object)takeOutStack);
            if (this.extractItem(slot, takeOutStack.func_190916_E(), true).equals(ItemStack.field_190927_a)) {
                return false;
            }
            this.extractItem(player, takeOutStack, this.stacks.indexOf((Object)takeOutStack));
            return true;
        }
        return false;
    }

    public boolean playerInsertItem(World worldIn, ItemStack stack) {
        if (MalumHelper.areWeOnServer(worldIn) && !stack.func_190926_b()) {
            ItemStack simulate = ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)stack, (boolean)true);
            int count = stack.func_190916_E() - simulate.func_190916_E();
            if (count > this.slotSize) {
                count = this.slotSize;
            }
            ItemHandlerHelper.insertItem((IItemHandler)this, (ItemStack)stack.func_77979_a(count), (boolean)false);
            return true;
        }
        return false;
    }

    public void insertItem(ItemStack stack, int slot) {
        ItemStack simulate = this.insertItem(slot, stack, true);
        int count = stack.func_190916_E() - simulate.func_190916_E();
        if (count > this.slotSize) {
            count = this.slotSize;
        }
        this.insertItem(slot, stack.func_77979_a(count), false);
    }

    public void extractItem(PlayerEntity playerEntity, ItemStack stack, int slot) {
        ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)stack, (int)playerEntity.field_71071_by.field_70461_c);
        this.setStackInSlot(slot, ItemStack.field_190927_a);
    }

    public void readData(CompoundNBT compound) {
        this.readData(compound, "inventory");
    }

    public CompoundNBT writeData(CompoundNBT compound) {
        this.writeData(compound, "inventory");
        return compound;
    }

    public void readData(CompoundNBT compound, String name) {
        this.deserializeNBT((CompoundNBT)Objects.requireNonNull(compound.func_74781_a(name)));
    }

    public CompoundNBT writeData(CompoundNBT compound, String name) {
        compound.func_218657_a(name, (INBT)this.serializeNBT());
        return compound;
    }
}

