/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.init.events;

import com.sammy.malum.ClientHelper;
import com.sammy.malum.MalumColors;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.MalumLeavesBlock;
import com.sammy.malum.common.blocks.itempedestal.ItemPedestalBlock;
import com.sammy.malum.common.blocks.itempedestal.ItemPedestalRenderer;
import com.sammy.malum.common.blocks.itemstand.ItemStandBlock;
import com.sammy.malum.common.blocks.itemstand.ItemStandRenderer;
import com.sammy.malum.common.blocks.lighting.EtherBrazierBlock;
import com.sammy.malum.common.blocks.runetable.RuneTableBlock;
import com.sammy.malum.common.blocks.runetable.RuneTableRenderer;
import com.sammy.malum.common.blocks.runetable.bounding.RuneTableBoundingRenderer;
import com.sammy.malum.common.blocks.spiritaltar.SpiritAltarRenderer;
import com.sammy.malum.common.blocks.spiritjar.SpiritJarRenderer;
import com.sammy.malum.common.blocks.totem.TotemBaseBlock;
import com.sammy.malum.common.blocks.totem.pole.TotemPoleBlock;
import com.sammy.malum.common.blocks.totem.pole.TotemPoleRenderer;
import com.sammy.malum.common.entities.boomerang.ScytheBoomerangEntityRenderer;
import com.sammy.malum.common.entities.spirit.SpiritItemRenderer;
import com.sammy.malum.core.init.MalumEntities;
import com.sammy.malum.core.init.blocks.MalumBlocks;
import com.sammy.malum.core.init.blocks.MalumTileEntities;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.modcontent.MalumSpiritTypes;
import com.sammy.malum.core.systems.multiblock.BoundingBlock;
import java.util.HashSet;
import net.minecraft.block.Block;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SaplingBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.entity.EntityType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="malum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientStartupEvents {
    @SubscribeEvent
    public static void bindTERs(FMLClientSetupEvent event) {
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.SPIRIT_ALTAR_TILE_ENTITY.get()), SpiritAltarRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.TOTEM_POLE_TILE_ENTITY.get()), TotemPoleRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.RUNE_TABLE_TILE_ENTITY.get()), RuneTableRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.RUNE_TABLE_BOUNDING_BLOCK_TILE_ENTITY.get()), RuneTableBoundingRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.ITEM_STAND_TILE_ENTITY.get()), ItemStandRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.ITEM_PEDESTAL_TILE_ENTITY.get()), ItemPedestalRenderer::new);
        ClientRegistry.bindTileEntityRenderer((TileEntityType)((TileEntityType)MalumTileEntities.SPIRIT_JAR_TILE_ENTITY.get()), SpiritJarRenderer::new);
    }

    @SubscribeEvent
    public static void onClientSetup(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MalumEntities.SPIRIT_ESSENCE.get()), ClientStartupEvents::essenceRenderer);
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)MalumEntities.SCYTHE_BOOMERANG.get()), ClientStartupEvents::scytheRenderer);
    }

    public static SpiritItemRenderer essenceRenderer(EntityRendererManager manager) {
        return new SpiritItemRenderer(manager, Minecraft.func_71410_x().func_175599_af());
    }

    public static ScytheBoomerangEntityRenderer scytheRenderer(EntityRendererManager manager) {
        return new ScytheBoomerangEntityRenderer(manager, Minecraft.func_71410_x().func_175599_af());
    }

    @SubscribeEvent
    public static void setBlockColors(ColorHandlerEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        HashSet blocks = new HashSet(MalumBlocks.BLOCKS.getEntries());
        MalumHelper.takeAll(blocks, block -> block.get() instanceof MalumLeavesBlock).forEach(block -> blockColors.func_186722_a((state, reader, pos, color) -> {
            float i = ((Integer)state.func_177229_b((Property)MalumLeavesBlock.COLOR)).intValue();
            MalumLeavesBlock malumLeavesBlock = (MalumLeavesBlock)block.get();
            int r = (int)MathHelper.func_219799_g((float)(i / 9.0f), (float)malumLeavesBlock.minColor.getRed(), (float)malumLeavesBlock.maxColor.getRed());
            int g = (int)MathHelper.func_219799_g((float)(i / 9.0f), (float)malumLeavesBlock.minColor.getGreen(), (float)malumLeavesBlock.maxColor.getGreen());
            int b = (int)MathHelper.func_219799_g((float)(i / 9.0f), (float)malumLeavesBlock.minColor.getBlue(), (float)malumLeavesBlock.maxColor.getBlue());
            return r << 16 | g << 8 | b;
        }, new Block[]{(Block)block.get()}));
    }

    @SubscribeEvent
    public static void setItemColors(ColorHandlerEvent.Item event) {
        ItemColors itemColors = event.getItemColors();
        HashSet items = new HashSet(MalumItems.ITEMS.getEntries());
        MalumHelper.takeAll(items, item -> item.get() instanceof BlockItem && ((BlockItem)item.get()).func_179223_d() instanceof MalumLeavesBlock).forEach(item -> {
            MalumLeavesBlock malumLeavesBlock = (MalumLeavesBlock)((BlockItem)item.get()).func_179223_d();
            ClientHelper.registerItemColor(itemColors, (RegistryObject<Item>)item, malumLeavesBlock.minColor);
        });
        ClientHelper.registerItemColor(itemColors, MalumItems.ORANGE_ETHER, MalumHelper.brighter(MalumColors.ORANGE, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.MAGENTA_ETHER, MalumHelper.brighter(MalumColors.MAGENTA, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.LIGHT_BLUE_ETHER, MalumHelper.brighter(MalumColors.LIGHT_BLUE, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.YELLOW_ETHER, MalumHelper.brighter(MalumColors.YELLOW, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.LIME_ETHER, MalumHelper.brighter(MalumColors.LIME, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.CYAN_ETHER, MalumHelper.brighter(MalumColors.CYAN, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.PURPLE_ETHER, MalumHelper.brighter(MalumColors.PURPLE, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.BLUE_ETHER, MalumHelper.brighter(MalumColors.BLUE, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.BROWN_ETHER, MalumHelper.brighter(MalumColors.BROWN, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.GREEN_ETHER, MalumHelper.brighter(MalumColors.GREEN, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.RED_ETHER, MalumHelper.brighter(MalumColors.RED, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.PINK_ETHER, MalumHelper.brighter(MalumColors.PINK, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.ORANGE_ETHER_TORCH, MalumHelper.brighter(MalumColors.ORANGE, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.MAGENTA_ETHER_TORCH, MalumHelper.brighter(MalumColors.MAGENTA, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.LIGHT_BLUE_ETHER_TORCH, MalumHelper.brighter(MalumColors.LIGHT_BLUE, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.YELLOW_ETHER_TORCH, MalumHelper.brighter(MalumColors.YELLOW, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.LIME_ETHER_TORCH, MalumHelper.brighter(MalumColors.LIME, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.CYAN_ETHER_TORCH, MalumHelper.brighter(MalumColors.CYAN, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.PURPLE_ETHER_TORCH, MalumHelper.brighter(MalumColors.PURPLE, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.BLUE_ETHER_TORCH, MalumHelper.brighter(MalumColors.BLUE, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.BROWN_ETHER_TORCH, MalumHelper.brighter(MalumColors.BROWN, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.GREEN_ETHER_TORCH, MalumHelper.brighter(MalumColors.GREEN, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.RED_ETHER_TORCH, MalumHelper.brighter(MalumColors.RED, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.PINK_ETHER_TORCH, MalumHelper.brighter(MalumColors.PINK, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.ORANGE_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.ORANGE, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.MAGENTA_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.MAGENTA, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.LIGHT_BLUE_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.LIGHT_BLUE, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.YELLOW_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.YELLOW, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.LIME_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.LIME, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.CYAN_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.CYAN, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.PURPLE_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.PURPLE, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.BLUE_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.BLUE, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.BROWN_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.BROWN, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.GREEN_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.GREEN, 1));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.RED_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.RED, 3));
        ClientHelper.registerItemColorTint(itemColors, MalumItems.PINK_ETHER_BRAZIER, MalumHelper.brighter(MalumColors.PINK, 3));
        ClientHelper.registerItemColor(itemColors, MalumItems.SACRED_SPIRIT, MalumHelper.brighter(MalumSpiritTypes.SACRED_SPIRIT_COLOR, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.WICKED_SPIRIT, MalumSpiritTypes.WICKED_SPIRIT_COLOR);
        ClientHelper.registerItemColor(itemColors, MalumItems.ARCANE_SPIRIT, MalumHelper.brighter(MalumSpiritTypes.ARCANE_SPIRIT_COLOR, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.ELDRITCH_SPIRIT, MalumHelper.darker(MalumSpiritTypes.ELDRITCH_SPIRIT_COLOR, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.AERIAL_SPIRIT, MalumHelper.brighter(MalumSpiritTypes.AERIAL_SPIRIT_COLOR, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.AQUATIC_SPIRIT, MalumHelper.brighter(MalumSpiritTypes.AQUATIC_SPIRIT_COLOR, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.INFERNAL_SPIRIT, MalumHelper.brighter(MalumSpiritTypes.INFERNAL_SPIRIT_COLOR, 1));
        ClientHelper.registerItemColor(itemColors, MalumItems.EARTHEN_SPIRIT, MalumHelper.brighter(MalumSpiritTypes.EARTHEN_SPIRIT_COLOR, 1));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        if (!event.getMap().func_229223_g_().equals((Object)AtlasTexture.field_110575_b)) {
            return;
        }
        MalumSpiritTypes.SPIRITS.forEach(s -> {
            event.addSprite(MalumHelper.prefix("spirit/overlay_" + s.identifier));
            event.addSprite(MalumHelper.prefix("spirit/cutout_" + s.identifier));
        });
    }

    @SubscribeEvent
    public static void setRenderLayers(FMLClientSetupEvent event) {
        HashSet blocks = new HashSet(MalumBlocks.BLOCKS.getEntries());
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TorchBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof BoundingBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TrapDoorBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof SaplingBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof LeavesBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof LanternBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof EtherBrazierBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof ItemStandBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof ItemPedestalBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TotemBaseBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TotemPoleBlock).forEach(ClientStartupEvents::setCutout);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof RuneTableBlock).forEach(ClientStartupEvents::setCutout);
        ClientStartupEvents.setCutout(MalumBlocks.SPIRIT_JAR);
        ClientStartupEvents.setCutout(MalumBlocks.SPIRIT_ALTAR);
        ClientStartupEvents.setCutout(MalumBlocks.BLAZING_QUARTZ_ORE);
    }

    public static void setCutout(RegistryObject<Block> b) {
        RenderTypeLookup.setRenderLayer((Block)((Block)b.get()), (RenderType)RenderType.func_228643_e_());
    }
}

