/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.lighting.EtherBlock;
import com.sammy.malum.common.blocks.lighting.EtherBrazierBlock;
import com.sammy.malum.common.blocks.lighting.EtherTorchBlock;
import com.sammy.malum.common.items.SpiritItem;
import com.sammy.malum.common.items.tools.ModCombatItem;
import com.sammy.malum.common.items.tools.spirittools.ScytheItem;
import com.sammy.malum.core.init.items.MalumItems;
import java.util.HashSet;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.SwordItem;
import net.minecraft.item.ToolItem;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class MalumItemModelProvider
extends ItemModelProvider {
    private static final ResourceLocation GENERATED = new ResourceLocation("item/generated");
    private static final ResourceLocation HANDHELD = new ResourceLocation("item/handheld");

    public MalumItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "malum", existingFileHelper);
    }

    protected void registerModels() {
        HashSet items = new HashSet(MalumItems.ITEMS.getEntries());
        items.remove(MalumItems.SPIRIT_PIPE);
        items.remove(MalumItems.AWAKENED_TYRVING);
        this.spiritPipeItem(MalumItems.SPIRIT_PIPE);
        MalumHelper.takeAll(items, i -> i.get() instanceof ScytheItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof SpiritItem).forEach(this::spiritSplinterItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof WallBlock).forEach(this::wallBlockItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof FenceBlock).forEach(this::fenceBlockItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof DoorBlock).forEach(this::generatedItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof TrapDoorBlock).forEach(this::trapdoorBlockItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof PressurePlateBlock).forEach(this::pressurePlateBlockItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof AbstractButtonBlock).forEach(this::buttonBlockItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof BushBlock && !(((BlockItem)i.get()).func_179223_d() instanceof DoublePlantBlock)).forEach(this::blockGeneratedItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof DoublePlantBlock).forEach(this::generatedItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof EtherBrazierBlock).forEach(this::etherBrazierItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof LanternBlock).forEach(this::generatedItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof EtherTorchBlock).forEach(this::etherTorchItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof TorchBlock).forEach(this::generatedItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem && ((BlockItem)i.get()).func_179223_d() instanceof EtherBlock).forEach(this::etherItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BlockItem).forEach(this::blockItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof ToolItem).forEach(this::handheldItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof ModCombatItem).forEach(this::handheldItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof SwordItem).forEach(this::handheldItem);
        MalumHelper.takeAll(items, i -> i.get() instanceof BowItem).forEach(this::handheldItem);
        items.forEach(this::generatedItem);
    }

    private void handheldItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", MalumHelper.prefix("item/" + name));
    }

    private void spiritSplinterItem(RegistryObject<Item> i) {
        if (i.get() instanceof SpiritItem) {
            SpiritItem spiritItem = (SpiritItem)i.get();
            String texture = spiritItem.type.isCompound ? "spirit/spirit_cluster_base" : "spirit/spirit_splinter_base";
            String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
            ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumHelper.prefix(texture));
        }
    }

    private void spiritedToolItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, HANDHELD)).texture("layer0", MalumHelper.prefix("item/" + name + "_overlay"))).texture("layer1", MalumHelper.prefix("item/" + name));
    }

    private void etherBrazierItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumHelper.prefix("item/colored_ether_brazier_overlay"))).texture("layer1", MalumHelper.prefix("item/colored_ether_brazier"));
    }

    private void etherTorchItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumHelper.prefix("item/colored_ether_torch_overlay"))).texture("layer1", MalumHelper.prefix("item/colored_ether_torch"));
    }

    private void etherItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumHelper.prefix("item/colored_ether"));
    }

    private void generatedItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumHelper.prefix("item/" + name));
    }

    private void blockGeneratedItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.withExistingParent(name, GENERATED)).texture("layer0", MalumHelper.prefix("block/" + name));
    }

    private void spiritPipeItem(RegistryObject<Item> i) {
        ((ItemModelBuilder)this.getBuilder("spirit_pipe")).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumHelper.prefix("block/spirit_pipe_core")));
    }

    private void blockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumHelper.prefix("block/" + name)));
    }

    private void trapdoorBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumHelper.prefix("block/" + name + "_bottom")));
    }

    private void fenceBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceInventory(name, MalumHelper.prefix("block/" + baseName));
    }

    private void wallBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.wallInventory(name, MalumHelper.prefix("block/" + baseName));
    }

    private void pressurePlateBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumHelper.prefix("block/" + name + "_up")));
    }

    private void buttonBlockItem(RegistryObject<Item> i) {
        String name = Registry.field_212630_s.func_177774_c((Object)i.get()).func_110623_a();
        ((ItemModelBuilder)this.getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile(MalumHelper.prefix("block/" + name + "_inventory")));
    }

    public String func_200397_b() {
        return "Malum Item Models";
    }
}

