/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.core.data;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.blocks.MalumLeavesBlock;
import com.sammy.malum.common.blocks.itempedestal.ItemPedestalBlock;
import com.sammy.malum.common.blocks.itemstand.ItemStandBlock;
import com.sammy.malum.common.blocks.lighting.EtherBlock;
import com.sammy.malum.common.blocks.lighting.EtherBrazierBlock;
import com.sammy.malum.common.blocks.runetable.RuneTableBlock;
import com.sammy.malum.common.blocks.runetable.bounding.RuneTableBoundingBlock;
import com.sammy.malum.common.blocks.totem.TotemBaseBlock;
import com.sammy.malum.common.blocks.totem.pole.TotemPoleBlock;
import com.sammy.malum.core.init.blocks.MalumBlocks;
import java.util.Collection;
import java.util.HashSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractButtonBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.BushBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.GrassBlock;
import net.minecraft.block.LanternBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.WallTorchBlock;
import net.minecraft.data.DataGenerator;
import net.minecraft.state.Property;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;

public class MalumBlockStateProvider
extends BlockStateProvider {
    public MalumBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "malum", exFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Malum BlockStates";
    }

    protected void registerStatesAndModels() {
        HashSet blocks = new HashSet(MalumBlocks.BLOCKS.getEntries());
        blocks.remove(MalumBlocks.BLAZING_QUARTZ_ORE);
        this.glowingBlock(MalumBlocks.BLAZING_QUARTZ_ORE);
        blocks.remove(MalumBlocks.SPIRIT_ALTAR);
        blocks.remove(MalumBlocks.SPIRIT_JAR);
        blocks.remove(MalumBlocks.SPIRIT_PIPE);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TotemBaseBlock).forEach(this::totemBaseBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TotemPoleBlock).forEach(this::totemPoleBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof RuneTableBlock).forEach(this::runeTableBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof RuneTableBoundingBlock).forEach(this::runeTableBoundingBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof ItemPedestalBlock).forEach(this::itemPedestalBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof ItemStandBlock).forEach(this::itemStandBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof EtherBlock).forEach(this::etherBlock);
        MalumHelper.takeAll(blocks, b -> ((Block)b.get()).getRegistryName().func_110623_a().startsWith("cut_") && ((Block)b.get()).getRegistryName().func_110623_a().endsWith("_planks")).forEach(this::cutPlanksBlock);
        MalumHelper.takeAll(blocks, b -> ((Block)b.get()).getRegistryName().func_110623_a().startsWith("cut_")).forEach(this::cutBlock);
        MalumHelper.takeAll(blocks, b -> ((Block)b.get()).func_149739_a().endsWith("_cap")).forEach(this::pillarCapBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof GrassBlock).forEach(this::grassBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof StairsBlock).forEach(this::stairsBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof RotatedPillarBlock).forEach(this::logBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof WallBlock).forEach(this::wallBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof FenceBlock).forEach(this::fenceBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof FenceGateBlock).forEach(this::fenceGateBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof DoorBlock).forEach(this::doorBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TrapDoorBlock).forEach(this::trapdoorBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof PressurePlateBlock).forEach(this::pressurePlateBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof AbstractButtonBlock).forEach(this::buttonBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof DoublePlantBlock).forEach(this::tallPlantBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof BushBlock).forEach(this::plantBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof EtherBrazierBlock).forEach(this::brazierBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof LanternBlock).forEach(this::lanternBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof MalumLeavesBlock).forEach(this::malumLeavesBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof WallTorchBlock).forEach(this::wallEtherTorchBlock);
        MalumHelper.takeAll(blocks, b -> b.get() instanceof TorchBlock).forEach(this::etherTorchBlock);
        Collection<RegistryObject> slabs = MalumHelper.takeAll(blocks, b -> b.get() instanceof SlabBlock);
        blocks.forEach(this::basicBlock);
        slabs.forEach(this::slabBlock);
    }

    public void basicBlock(RegistryObject<Block> blockRegistryObject) {
        this.simpleBlock((Block)blockRegistryObject.get());
    }

    public void glowingBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String glow = name + "_glow";
        ModelBuilder farmland = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumHelper.prefix("block/template_glowing_block"))).texture("all", MalumHelper.prefix("block/" + name))).texture("particle", MalumHelper.prefix("block/" + name))).texture("glow", MalumHelper.prefix("block/" + glow));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$glowingBlock$28((ModelFile)farmland, arg_0));
    }

    public void rotatedBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder file = this.models().cubeAll(name, MalumHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().modelForState().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).addModel();
    }

    public void etherBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder empty = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/air"))).texture("particle", MalumHelper.prefix("item/colored_ether"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$etherBlock$29((ModelFile)empty, arg_0));
    }

    public void etherTorchBlock(RegistryObject<Block> blockRegistryObject) {
        ModelBuilder torch = this.models().torch(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), MalumHelper.prefix("block/colored_ether_torch"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$etherTorchBlock$30((ModelFile)torch, arg_0));
    }

    public void wallEtherTorchBlock(RegistryObject<Block> blockRegistryObject) {
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), MalumHelper.prefix("block/colored_ether_torch"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)torch).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)torch).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)torch).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)torch).addModel();
    }

    public void torchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), MalumHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$torchBlock$31((ModelFile)torch, arg_0));
    }

    public void wallTorchBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder torch = this.models().torchWall(((Block)blockRegistryObject.get()).getRegistryName().func_110623_a(), MalumHelper.prefix("block/" + name.substring(5)));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)torch).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)torch).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)torch).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)torch).addModel();
    }

    public void itemStandBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String particleName = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a().replaceFirst("_item_stand", "");
        if (!particleName.endsWith("_rock")) {
            particleName = particleName + "_planks";
        }
        ModelBuilder stand = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumHelper.prefix("block/template_item_stand"))).texture("stand", MalumHelper.prefix("block/" + name))).texture("particle", MalumHelper.prefix("block/" + particleName));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)stand).rotationX(90).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)stand).rotationX(90).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.DOWN).modelForState().modelFile((ModelFile)stand).rotationX(180).addModel()).partialState().with((Property)BlockStateProperties.field_208155_H, (Comparable)Direction.UP).modelForState().modelFile((ModelFile)stand).addModel();
    }

    public void runeTableBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder table = ((BlockModelBuilder)this.models().withExistingParent(name, MalumHelper.prefix("block/template_rune_table"))).texture("table", MalumHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$runeTableBlock$32((ModelFile)table, arg_0));
    }

    public void runeTableBoundingBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder table = ((BlockModelBuilder)this.models().withExistingParent(name, MalumHelper.prefix("block/template_rune_table_side"))).texture("table", MalumHelper.prefix("block/" + name));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)table).rotationY(270).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)table).rotationY(180).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)table).rotationY(90).addModel()).partialState().with((Property)WallTorchBlock.field_196532_a, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)table).addModel();
    }

    public void itemPedestalBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String particleName = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a().replaceFirst("_item_pedestal", "");
        if (!particleName.endsWith("_rock")) {
            particleName = particleName + "_planks";
        }
        ModelBuilder pedestal = ((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumHelper.prefix("block/template_item_pedestal"))).texture("pedestal", MalumHelper.prefix("block/" + name))).texture("particle", MalumHelper.prefix("block/" + particleName));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$itemPedestalBlock$33((ModelFile)pedestal, arg_0));
    }

    public void wildFarmlandBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder farmland = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(name, MalumHelper.prefix("block/template_farmland"))).texture("side", MalumHelper.prefix("block/sun_kissed_grass_block_side"))).texture("top", MalumHelper.prefix("block/wild_farmland"))).texture("dirt", new ResourceLocation("block/dirt"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$wildFarmlandBlock$34((ModelFile)farmland, arg_0));
    }

    public void cutBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = "smooth_" + name.substring(4);
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(name, MalumHelper.prefix("block/" + name), MalumHelper.prefix("block/" + baseName), MalumHelper.prefix("block/" + baseName)));
    }

    public void cutPlanksBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - "_planks".length()).substring(4) + "_panel";
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(name, MalumHelper.prefix("block/" + name), MalumHelper.prefix("block/" + name), MalumHelper.prefix("block/" + baseName)));
    }

    public void grassBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder file = this.models().cubeBottomTop(name, MalumHelper.prefix("block/" + name + "_side"), new ResourceLocation("block/dirt"), MalumHelper.prefix("block/" + name + "_top"));
        this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().modelForState().modelFile((ModelFile)file).nextModel().modelFile((ModelFile)file).rotationY(90).nextModel().modelFile((ModelFile)file).rotationY(180).nextModel().modelFile((ModelFile)file).rotationY(270).addModel();
    }

    public void totemBaseBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder base = this.models().withExistingParent(name, MalumHelper.prefix("block/template_totem_base"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)base).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)base).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)base).rotationY(90).addModel()).partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)base).addModel();
    }

    public void totemPoleBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder pole = this.models().withExistingParent(name, MalumHelper.prefix("block/template_totem_pole"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.NORTH).modelForState().modelFile((ModelFile)pole).rotationY(0).addModel()).partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.WEST).modelForState().modelFile((ModelFile)pole).rotationY(270).addModel()).partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.SOUTH).modelForState().modelFile((ModelFile)pole).rotationY(180).addModel()).partialState().with((Property)BlockStateProperties.field_208157_J, (Comparable)Direction.EAST).modelForState().modelFile((ModelFile)pole).rotationY(90).addModel();
    }

    public void malumLeavesBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder leaves = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/leaves"))).texture("all", MalumHelper.prefix("block/" + name));
        this.simpleBlock((Block)blockRegistryObject.get(), (ModelFile)leaves);
    }

    public void pillarCapBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 11);
        String pillarName = name.substring(0, name.length() - 4) + "_top";
        this.directionalBlock((Block)blockRegistryObject.get(), (ModelFile)this.models().cubeBottomTop(name, MalumHelper.prefix("block/" + name), MalumHelper.prefix("block/smooth_" + baseName), MalumHelper.prefix("block/" + pillarName)));
    }

    public void trapdoorBlock(RegistryObject<Block> blockRegistryObject) {
        this.trapdoorBlock((TrapDoorBlock)blockRegistryObject.get(), this.blockTexture((Block)blockRegistryObject.get()), true);
    }

    public void doorBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        this.doorBlock((DoorBlock)blockRegistryObject.get(), MalumHelper.prefix("block/" + name + "_bottom"), MalumHelper.prefix("block/" + name + "_top"));
    }

    public void fenceGateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 11);
        this.fenceGateBlock((FenceGateBlock)blockRegistryObject.get(), MalumHelper.prefix("block/" + baseName));
    }

    public void fenceBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 6);
        this.fenceBlock((FenceBlock)blockRegistryObject.get(), MalumHelper.prefix("block/" + baseName));
    }

    public void wallBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.wallBlock((WallBlock)blockRegistryObject.get(), MalumHelper.prefix("block/" + baseName));
    }

    public void stairsBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 7);
        this.stairsBlock((StairsBlock)blockRegistryObject.get(), MalumHelper.prefix("block/" + baseName));
    }

    public void pressurePlateBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 15);
        ModelBuilder pressurePlateDown = ((BlockModelBuilder)this.models().withExistingParent(name + "_down", new ResourceLocation("block/pressure_plate_down"))).texture("texture", MalumHelper.prefix("block/" + baseName));
        ModelBuilder pressurePlateUp = ((BlockModelBuilder)this.models().withExistingParent(name + "_up", new ResourceLocation("block/pressure_plate_up"))).texture("texture", MalumHelper.prefix("block/" + baseName));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)pressurePlateDown).addModel()).partialState().with((Property)PressurePlateBlock.field_176580_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)pressurePlateUp).addModel();
    }

    public void brazierBlock(RegistryObject<Block> blockRegistryObject) {
        ModelFile.ExistingModelFile brazier = this.models().getExistingFile(MalumHelper.prefix("block/template_ether_brazier"));
        ModelFile.ExistingModelFile brazier_hanging = this.models().getExistingFile(MalumHelper.prefix("block/template_ether_brazier_hanging"));
        ((VariantBlockStateBuilder)((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)brazier_hanging).addModel()).partialState().with((Property)EtherBrazierBlock.HANGING, (Comparable)Boolean.valueOf(true)).with((Property)EtherBrazierBlock.ROTATED, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)brazier_hanging).rotationY(90).addModel();
    }

    public void lanternBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder lantern = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/template_lantern"))).texture("lantern", MalumHelper.prefix("block/" + name));
        ModelBuilder hangingLantern = ((BlockModelBuilder)this.models().withExistingParent(name + "_hanging", new ResourceLocation("block/template_hanging_lantern"))).texture("lantern", MalumHelper.prefix("block/" + name));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(true)).modelForState().modelFile((ModelFile)hangingLantern).addModel()).partialState().with((Property)LanternBlock.field_220278_a, (Comparable)Boolean.valueOf(false)).modelForState().modelFile((ModelFile)lantern).addModel();
    }

    public void buttonBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 7);
        ModelBuilder buttom = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/button"))).texture("texture", MalumHelper.prefix("block/" + baseName));
        ModelBuilder buttonPressed = ((BlockModelBuilder)this.models().withExistingParent(name + "_pressed", new ResourceLocation("block/button_pressed"))).texture("texture", MalumHelper.prefix("block/" + baseName));
        Function<BlockState, ModelFile> modelFunc = arg_0 -> MalumBlockStateProvider.lambda$buttonBlock$35((ModelFile)buttom, arg_0);
        Function<BlockState, ModelFile> pressedModelFunc = arg_0 -> MalumBlockStateProvider.lambda$buttonBlock$36((ModelFile)buttonPressed, arg_0);
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(s -> ConfiguredModel.builder().modelFile((Boolean)s.func_177229_b((Property)BlockStateProperties.field_208194_u) != false ? (ModelFile)pressedModelFunc.apply((BlockState)s) : (ModelFile)modelFunc.apply((BlockState)s)).uvLock(((AttachFace)s.func_177229_b((Property)BlockStateProperties.field_208158_K)).equals((Object)AttachFace.WALL)).rotationX(((AttachFace)s.func_177229_b((Property)BlockStateProperties.field_208158_K)).ordinal() * 90).rotationY(((int)((Direction)s.func_177229_b((Property)BlockStateProperties.field_208157_J)).func_185119_l() + 180 + (s.func_177229_b((Property)BlockStateProperties.field_208158_K) == AttachFace.CEILING ? 180 : 0)) % 360).build());
        ((BlockModelBuilder)this.models().withExistingParent(name + "_inventory", new ResourceLocation("block/button_inventory"))).texture("texture", MalumHelper.prefix("block/" + baseName));
    }

    public void tallPlantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder bottom = ((BlockModelBuilder)this.models().withExistingParent(name + "_bottom", new ResourceLocation("block/cross"))).texture("cross", MalumHelper.prefix("block/" + name + "_bottom"));
        ModelBuilder top = ((BlockModelBuilder)this.models().withExistingParent(name + "_top", new ResourceLocation("block/cross"))).texture("cross", MalumHelper.prefix("block/" + name + "_top"));
        ((VariantBlockStateBuilder)this.getVariantBuilder((Block)blockRegistryObject.get()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.LOWER).modelForState().modelFile((ModelFile)bottom).addModel()).partialState().with((Property)DoublePlantBlock.field_176492_b, (Comparable)DoubleBlockHalf.UPPER).modelForState().modelFile((ModelFile)top).addModel();
    }

    public void plantBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        ModelBuilder cross = ((BlockModelBuilder)this.models().withExistingParent(name, new ResourceLocation("block/cross"))).texture("cross", MalumHelper.prefix("block/" + name));
        this.getVariantBuilder((Block)blockRegistryObject.get()).forAllStates(arg_0 -> MalumBlockStateProvider.lambda$plantBlock$38((ModelFile)cross, arg_0));
    }

    public void slabBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name.substring(0, name.length() - 5);
        this.slabBlock((SlabBlock)blockRegistryObject.get(), MalumHelper.prefix(baseName), MalumHelper.prefix("block/" + baseName));
    }

    public void logBlock(RegistryObject<Block> blockRegistryObject) {
        if (blockRegistryObject.equals(MalumBlocks.RUNEWOOD) || blockRegistryObject.equals(MalumBlocks.STRIPPED_RUNEWOOD)) {
            this.woodBlock(blockRegistryObject);
            return;
        }
        if (blockRegistryObject.equals(MalumBlocks.SAP_FILLED_RUNEWOOD_LOG)) {
            this.sapFilledBlock(blockRegistryObject);
            return;
        }
        this.logBlock((RotatedPillarBlock)blockRegistryObject.get());
    }

    public void sapFilledBlock(RegistryObject<Block> blockRegistryObject) {
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), MalumHelper.prefix("block/sap_filled_runewood_log"), MalumHelper.prefix("block/stripped_runewood_log_top"));
    }

    public void woodBlock(RegistryObject<Block> blockRegistryObject) {
        String name = Registry.field_212618_g.func_177774_c((Object)blockRegistryObject.get()).func_110623_a();
        String baseName = name + "_log";
        this.axisBlock((RotatedPillarBlock)blockRegistryObject.get(), MalumHelper.prefix("block/" + baseName), MalumHelper.prefix("block/" + baseName));
    }

    private static /* synthetic */ ConfiguredModel[] lambda$plantBlock$38(ModelFile cross, BlockState s) {
        return ConfiguredModel.builder().modelFile(cross).build();
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$36(ModelFile buttonPressed, BlockState $) {
        return buttonPressed;
    }

    private static /* synthetic */ ModelFile lambda$buttonBlock$35(ModelFile buttom, BlockState $) {
        return buttom;
    }

    private static /* synthetic */ ConfiguredModel[] lambda$wildFarmlandBlock$34(ModelFile farmland, BlockState s) {
        return ConfiguredModel.builder().modelFile(farmland).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$itemPedestalBlock$33(ModelFile pedestal, BlockState s) {
        return ConfiguredModel.builder().modelFile(pedestal).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$runeTableBlock$32(ModelFile table, BlockState s) {
        return ConfiguredModel.builder().modelFile(table).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$torchBlock$31(ModelFile torch, BlockState s) {
        return ConfiguredModel.builder().modelFile(torch).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$etherTorchBlock$30(ModelFile torch, BlockState s) {
        return ConfiguredModel.builder().modelFile(torch).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$etherBlock$29(ModelFile empty, BlockState s) {
        return ConfiguredModel.builder().modelFile(empty).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$glowingBlock$28(ModelFile farmland, BlockState s) {
        return ConfiguredModel.builder().modelFile(farmland).build();
    }
}

