/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.rites;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.core.modcontent.MalumSpiritTypes;
import com.sammy.malum.core.systems.rites.MalumRiteType;
import com.sammy.malum.network.NetworkManager;
import com.sammy.malum.network.packets.particle.UpwardsFromBlockParticlesPacket;
import java.util.ArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.block.IGrowable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.PacketDistributor;

public class RiteOfGrowth
extends MalumRiteType {
    public RiteOfGrowth() {
        super("rite_of_growth", false, MalumSpiritTypes.ARCANE_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT, MalumSpiritTypes.SACRED_SPIRIT);
    }

    @Override
    public void executeRite(ServerWorld world, BlockPos pos) {
        if (world.field_73012_v.nextFloat() < 0.9f) {
            return;
        }
        ArrayList<BlockPos> nearbyBlocks = new ArrayList<BlockPos>(MalumHelper.getBlocks(pos, this.range(), this.range(), this.range(), b -> {
            BlockState state = world.func_180495_p(b);
            if (state.func_177230_c() instanceof IGrowable) {
                IGrowable growable = (IGrowable)state.func_177230_c();
                return growable.func_176473_a((IBlockReader)world, b, state, false);
            }
            return false;
        }));
        if (nearbyBlocks.isEmpty()) {
            return;
        }
        BlockPos nearbyPos = nearbyBlocks.get(world.field_73012_v.nextInt(nearbyBlocks.size()));
        BlockState state = world.func_180495_p(nearbyPos);
        IGrowable iGrowable = (IGrowable)state.func_177230_c();
        iGrowable.func_225535_a_(world, world.field_73012_v, nearbyPos, state);
        BlockPos packetPos = state.func_200132_m() ? nearbyPos : nearbyPos.func_177977_b();
        NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_CHUNK.with(() -> world.func_175726_f(pos)), (Object)UpwardsFromBlockParticlesPacket.fromSpirits(packetPos.func_177958_n(), packetPos.func_177956_o(), packetPos.func_177952_p(), this.spirits));
        super.executeRite(world, pos);
    }

    @Override
    public int range() {
        return 4;
    }
}

