/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.book.pages.SpiritInfusionPage;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.modcontent.MalumSpiritAltarRecipes;
import com.sammy.malum.core.systems.recipes.ItemIngredient;
import com.sammy.malum.core.systems.recipes.SpiritIngredient;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;

public class SpiritAltarRecipeCategory
implements IRecipeCategory<MalumSpiritAltarRecipes.MalumSpiritAltarRecipe> {
    public static final ResourceLocation UID = MalumHelper.prefix("spirit_altar");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    public static final ResourceLocation BACKGROUND = MalumHelper.prefix("textures/gui/spirit_altar_recipe_overlay.png");

    public SpiritAltarRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(132, 163);
        this.localizedName = I18n.func_135052_a((String)"malum.jei.spirit_infusion", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(BACKGROUND, 0, 0, 130, 161);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)MalumItems.SPIRIT_ALTAR.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends MalumSpiritAltarRecipes.MalumSpiritAltarRecipe> getRecipeClass() {
        return MalumSpiritAltarRecipes.MalumSpiritAltarRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MalumSpiritAltarRecipes.MalumSpiritAltarRecipe recipe, IIngredients iIngredients) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (SpiritIngredient spiritIngredient : recipe.spiritIngredients) {
            stacks.add(spiritIngredient.getItem());
        }
        for (ItemIngredient itemIngredient : recipe.extraItemIngredients) {
            stacks.addAll(itemIngredient.stacks());
        }
        stacks.addAll(recipe.inputIngredient.stacks());
        iIngredients.setInputs(VanillaTypes.ITEM, stacks);
        iIngredients.setOutputs(VanillaTypes.ITEM, recipe.outputIngredient.stacks());
    }

    public void draw(MalumSpiritAltarRecipes.MalumSpiritAltarRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        Vector3d itemOffset;
        int i;
        this.overlay.draw(matrixStack);
        Minecraft minecraft = Minecraft.func_71410_x();
        int inputX = 56;
        int inputY = 47;
        for (i = 0; i < recipe.extraItemIngredients.size(); ++i) {
            itemOffset = SpiritInfusionPage.itemOffset(false, i, recipe.extraItemIngredients.size());
            minecraft.func_110434_K().func_110577_a(BACKGROUND);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(inputX + (int)itemOffset.field_72450_a), (int)(inputY + (int)itemOffset.field_72449_c), (float)131.0f, (float)0.0f, (int)20, (int)21, (int)256, (int)256);
        }
        for (i = 0; i < recipe.spiritIngredients.size(); ++i) {
            itemOffset = SpiritInfusionPage.itemOffset(recipe.extraItemIngredients.size() > 1, i, recipe.spiritIngredients.size());
            minecraft.func_110434_K().func_110577_a(BACKGROUND);
            AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(inputX + (int)itemOffset.field_72450_a), (int)(inputY + (int)itemOffset.field_72449_c), (float)131.0f, (float)0.0f, (int)20, (int)21, (int)256, (int)256);
        }
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, MalumSpiritAltarRecipes.MalumSpiritAltarRecipe recipe, IIngredients iIngredients) {
        Vector3d itemOffset;
        int i;
        int itemCounter = 0;
        iRecipeLayout.getItemStacks().init(itemCounter, true, 56, 48);
        iRecipeLayout.getItemStacks().set(itemCounter, recipe.inputIngredient.stacks());
        iRecipeLayout.getItemStacks().init(++itemCounter, true, 56, 115);
        iRecipeLayout.getItemStacks().set(itemCounter, recipe.outputIngredient.stacks());
        ++itemCounter;
        int inputX = 56;
        int inputY = 48;
        for (i = 0; i < recipe.extraItemIngredients.size(); ++i) {
            itemOffset = SpiritInfusionPage.itemOffset(false, i, recipe.extraItemIngredients.size());
            iRecipeLayout.getItemStacks().init(itemCounter, true, inputX + (int)itemOffset.field_72450_a, inputY + (int)itemOffset.field_72449_c);
            iRecipeLayout.getItemStacks().set(itemCounter, recipe.extraItemIngredients.get(i).stacks());
            ++itemCounter;
        }
        for (i = 0; i < recipe.spiritIngredients.size(); ++i) {
            itemOffset = SpiritInfusionPage.itemOffset(recipe.extraItemIngredients.size() > 1, i, recipe.spiritIngredients.size());
            iRecipeLayout.getItemStacks().init(itemCounter, true, inputX + (int)itemOffset.field_72450_a, inputY + (int)itemOffset.field_72449_c);
            iRecipeLayout.getItemStacks().set(itemCounter, recipe.spiritIngredients.get(i).getItem());
            ++itemCounter;
        }
    }
}

