/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.integration.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.sammy.malum.MalumHelper;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.modcontent.MalumRuneTableRecipes;
import com.sammy.malum.core.systems.recipes.ItemIngredient;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

public class RuneTableRecipeCategory
implements IRecipeCategory<MalumRuneTableRecipes.MalumRuneTableRecipe> {
    public static final ResourceLocation UID = MalumHelper.prefix("rune_table");
    private final IDrawable background;
    private final String localizedName;
    private final IDrawable overlay;
    private final IDrawable icon;
    public static final ResourceLocation BACKGROUND = MalumHelper.prefix("textures/gui/rune_table_recipe_overlay.png");

    public RuneTableRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(132, 163);
        this.localizedName = I18n.func_135052_a((String)"malum.jei.rune_table", (Object[])new Object[0]);
        this.overlay = guiHelper.createDrawable(BACKGROUND, 0, 0, 130, 161);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)MalumItems.RUNE_TABLE.get()));
    }

    @Nonnull
    public ResourceLocation getUid() {
        return UID;
    }

    @Nonnull
    public Class<? extends MalumRuneTableRecipes.MalumRuneTableRecipe> getRecipeClass() {
        return MalumRuneTableRecipes.MalumRuneTableRecipe.class;
    }

    @Nonnull
    public String getTitle() {
        return this.localizedName;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(MalumRuneTableRecipes.MalumRuneTableRecipe recipe, IIngredients iIngredients) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemIngredient ingredient : recipe.itemIngredients) {
            stacks.addAll(ingredient.stacks());
        }
        iIngredients.setInputs(VanillaTypes.ITEM, stacks);
        iIngredients.setOutputs(VanillaTypes.ITEM, recipe.outputIngredient.stacks());
    }

    public void draw(MalumRuneTableRecipes.MalumRuneTableRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.overlay.draw(matrixStack);
    }

    public void setRecipe(IRecipeLayout iRecipeLayout, MalumRuneTableRecipes.MalumRuneTableRecipe recipe, IIngredients iIngredients) {
        for (int i = 0; i < recipe.itemIngredients.size(); ++i) {
            ItemIngredient ingredient = recipe.itemIngredients.get(i);
            int itemPosX = 31 + 25 * i;
            int itemPosY = 48;
            iRecipeLayout.getItemStacks().init(i, true, itemPosX, itemPosY);
            iRecipeLayout.getItemStacks().set(i, ingredient.stacks());
        }
        iRecipeLayout.getItemStacks().init(4, true, 56, 115);
        iRecipeLayout.getItemStacks().set(4, recipe.outputIngredient.stacks());
    }
}

