/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.integration.jei;

import com.sammy.malum.common.integration.jei.RuneTableRecipeCategory;
import com.sammy.malum.common.integration.jei.SpiritAltarRecipeCategory;
import com.sammy.malum.common.integration.jei.SpiritRitesRecipeCategory;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.modcontent.MalumRites;
import com.sammy.malum.core.modcontent.MalumRuneTableRecipes;
import com.sammy.malum.core.modcontent.MalumSpiritAltarRecipes;
import javax.annotation.Nonnull;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;

@JeiPlugin
public class JEIHandler
implements IModPlugin {
    private static final ResourceLocation ID = new ResourceLocation("malum", "main");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritAltarRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new SpiritRitesRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new RuneTableRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registry) {
        registry.addRecipes(MalumSpiritAltarRecipes.RECIPES, SpiritAltarRecipeCategory.UID);
        registry.addRecipes(MalumRites.RITES, SpiritRitesRecipeCategory.UID);
        registry.addRecipes(MalumRuneTableRecipes.RECIPES, RuneTableRecipeCategory.UID);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)MalumItems.SPIRIT_ALTAR.get()), new ResourceLocation[]{SpiritAltarRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)MalumItems.TOTEM_BASE.get()), new ResourceLocation[]{SpiritRitesRecipeCategory.UID});
        registry.addRecipeCatalyst((Object)new ItemStack((IItemProvider)MalumItems.RUNE_TABLE.get()), new ResourceLocation[]{RuneTableRecipeCategory.UID});
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return ID;
    }
}

