/*
 * Decompiled with CFR 0.152.
 */
package com.sammy.malum.common.events;

import com.sammy.malum.MalumHelper;
import com.sammy.malum.common.items.tools.spirittools.TyrvingItem;
import com.sammy.malum.core.init.items.MalumItems;
import com.sammy.malum.core.init.worldgen.MalumFeatures;
import com.sammy.malum.core.init.worldgen.MalumStaticFeatures;
import com.sammy.malum.core.modcontent.MalumSpiritTypes;
import com.sammy.malum.network.NetworkManager;
import com.sammy.malum.network.packets.particle.BurstParticlePacket;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber
public class Events {
    @SubscribeEvent
    public static void addFeatures(BiomeLoadingEvent event) {
        if (event.getCategory().equals((Object)Biome.Category.PLAINS)) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> MalumFeatures.CONFIGURED_RUNEWOOD_TREE);
        }
        if (event.getCategory().equals((Object)Biome.Category.FOREST)) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.VEGETAL_DECORATION).add(() -> MalumFeatures.RARE_CONFIGURED_RUNEWOOD_TREE);
        }
        if (event.getCategory().equals((Object)Biome.Category.NETHER)) {
            event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> MalumStaticFeatures.BLAZE_QUARTZ_ORE);
        }
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> MalumStaticFeatures.SOULSTONE_ORE);
        event.getGeneration().getFeatures(GenerationStage.Decoration.UNDERGROUND_ORES).add(() -> MalumStaticFeatures.SOULSTONE_ORE_SURFACE);
    }

    @SubscribeEvent
    public static void showGratitude(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity) {
            PlayerEntity playerEntity = (PlayerEntity)event.getEntity();
            if (MalumHelper.areWeOnServer(playerEntity.field_70170_p) && playerEntity.func_110124_au().equals(UUID.fromString("0ca54301-6170-4c44-b3e0-b8afa6b81ed2")) && !MalumHelper.findCosmeticCurio(s -> s.func_77973_b().equals(MalumItems.TOKEN_OF_GRATITUDE.get()), (LivingEntity)playerEntity).isPresent()) {
                ItemHandlerHelper.giveItemToPlayer((PlayerEntity)playerEntity, (ItemStack)((Item)MalumItems.TOKEN_OF_GRATITUDE.get()).func_190903_i());
            }
        }
    }

    @SubscribeEvent
    public static void onHurt(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity) {
            ItemStack stack;
            PlayerEntity playerEntity = (PlayerEntity)event.getSource().func_76346_g();
            if (playerEntity.field_184622_au != null && (stack = playerEntity.func_184586_b(playerEntity.field_184622_au)).func_77973_b() instanceof TyrvingItem) {
                TyrvingItem tyrvingItem = (TyrvingItem)stack.func_77973_b();
                LivingEntity entity = event.getEntityLiving();
                float amount = event.getAmount() * (1.0f + (float)entity.func_70658_aO() / tyrvingItem.armorCrushing);
                event.setAmount(amount);
                playerEntity.field_70170_p.func_184133_a(null, entity.func_233580_cy_(), tyrvingItem.soundEvent.get(), SoundCategory.PLAYERS, 1.0f, 1.0f + playerEntity.field_70170_p.field_73012_v.nextFloat() * 0.25f);
                if (playerEntity.field_70170_p instanceof ServerWorld) {
                    NetworkManager.INSTANCE.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), (Object)BurstParticlePacket.fromSpirits(entity.func_226277_ct_(), entity.func_226278_cu_() + (double)(entity.func_213302_cg() / 2.0f), entity.func_226281_cx_(), MalumSpiritTypes.WICKED_SPIRIT, MalumSpiritTypes.ELDRITCH_SPIRIT));
                }
            }
        }
    }
}

